/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSequenceOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateSequenceOracle.class);

    public SHCreateSequenceOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateSequenceOracle.clearCR(line);
        if (Token.startsWithString(statement, "CREATE SEQUENCE")) {
            try {
                this.parseSequence(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateSequenceOracle.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseSequence(String statement) {
        SequenceOracle sequence;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (stoDesign != null && (sequence = stoDesign.getSequenceSet().createSequence()) != null) {
            this.initNameAndUser(sequence, stoDesign);
            this.initStartWith(sequence);
            this.initIncrementBy(sequence);
            this.initMaxValue(sequence);
            this.initMinValue(sequence);
            this.initCycle(sequence);
            this.initCache(sequence);
            this.initOrder(sequence);
            this.initSession(sequence);
            this.design.getRelationalDesign().stampModelObjectDDL(sequence);
        }
    }

    private void initNameAndUser(SequenceOracle sequence, StorageDesignOracle storageDesign) {
        String startOfName = Token.getStringAfter(this.statement, "SEQUENCE");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
            String userName = name.substring(0, posPoint);
            name = name.substring(posPoint + 1);
            UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
            if (user == null) {
                user = storageDesign.getUserSet().createUser();
                user.setName(userName);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
            }
            sequence.setUser(user);
        }
        sequence.setName(name);
        if (startOfName.startsWith("\"") && !name.equals(name.toUpperCase())) {
            sequence.setNameHasQuotes(true);
        }
    }

    private void initStartWith(SequenceOracle sequence) {
        if (Token.hasToken(this.statement, "START")) {
            String str = Token.getTokenAfter(this.statement, "WITH");
            sequence.setStartWith(str);
        }
    }

    private void initIncrementBy(SequenceOracle sequence) {
        if (Token.hasToken(this.statement, "INCREMENT")) {
            String str = Token.getTokenAfter(this.statement, "BY");
            sequence.setIncrementBy(str);
        }
    }

    private void initMaxValue(SequenceOracle sequence) {
        if (Token.hasToken(this.statement, "MAXVALUE")) {
            String str = Token.getTokenAfter(this.statement, "MAXVALUE");
            sequence.setMaxValue(str);
        }
    }

    private void initMinValue(SequenceOracle sequence) {
        if (Token.hasToken(this.statement, "MINVALUE")) {
            String str = Token.getTokenAfter(this.statement, "MINVALUE");
            sequence.setMinValue(str);
        }
    }

    private void initCycle(SequenceOracle sequence) {
        if (Token.hasToken(this.statement, "CYCLE")) {
            sequence.setCycle("YES");
        }
    }

    private void initCache(SequenceOracle sequence) {
        if (Token.hasToken(this.statement, "NOCACHE")) {
            sequence.setNoCache("YES");
        } else if (Token.hasToken(this.statement, "CACHE")) {
            String cache = Token.getTokenAfter(this.statement, "CACHE");
            sequence.setCache(cache);
        }
    }

    private void initOrder(SequenceOracle sequence) {
        if (Token.hasToken(this.statement, "ORDER")) {
            sequence.setOrder("YES");
        }
    }

    private void initSession(SequenceOracle sequence) {
        if (Token.hasToken(this.statement, "SESSION")) {
            sequence.setSession("YES");
        }
    }
}

