/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTriggerDB2
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTriggerDB2.class);
    private TriggerDB2 trigger;
    private String line;
    private AbstractStorageDesignDB2 storageDesign;

    public SHCreateTriggerDB2(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTriggerDB2.clearCR(line);
        this.line = line;
        if (Token.startsWithString(statement, "create trigger")) {
            this.parseTrigger(statement.replaceAll("\"", ""));
        } else {
            this.nextHandler(line);
        }
    }

    private void parseTrigger(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            this.trigger = this.storageDesign.getTriggerSet().createTrigger();
            if (this.trigger != null) {
                try {
                    this.initTriggerName();
                    this.initTriggeringTime();
                    this.initAction();
                    this.initOnTable();
                    this.initReferencing();
                    this.initScope();
                    this.initCondition();
                    this.initBody();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.trigger);
                    this.importLog.incrementImportedStatements();
                }
                catch (ParseException e) {
                    LOGGER.error("Parsing " + statement + " for DB2 failed!");
                    this.importLog.addFailedStatement(SHCreateTriggerDB2.FormatCR(this.line, "\n"));
                }
            }
        }
    }

    private void initTriggerName() {
        String name = Token.getTokenAfter(this.statement, "TRIGGER").trim();
        if (name.indexOf(46) > -1) {
            String ownerName = name.substring(0, name.indexOf(46));
            ownerName = Token.getValBetweenSquareBrackets(ownerName);
            Owner owner = (Owner)this.storageDesign.getOwnerSet().getByName(ownerName);
            if (owner != null) {
                this.trigger.setOwner(owner);
            } else {
                Owner newOwner = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                newOwner.setName(ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(newOwner);
                this.trigger.setOwner(newOwner);
            }
            name = name.substring(name.indexOf(46) + 1);
        } else {
            this.trigger.setOwner(this.storageDesign.getOwnerSet().getDefaultOwner());
        }
        this.trigger.setName(name);
    }

    private void initTriggeringTime() throws ParseException {
        if (Token.hasString(this.statement, "NO CASCADE BEFORE")) {
            this.trigger.setTriggerTime(TriggerDB2.TRIGGER_TIMES[0]);
        } else if (Token.hasString(this.statement, "AFTER")) {
            this.trigger.setTriggerTime(TriggerDB2.TRIGGER_TIMES[1]);
        } else {
            this.importLog.addError("Unknown triggering time for trigger " + this.trigger.getName());
            throw new ParseException("Error parsing triggering time for trigger " + this.trigger.getName() + "(DB2) ");
        }
    }

    private void initAction() throws ParseException {
        String trTime = this.trigger.getTriggerTime();
        if (trTime != null) {
            String str = Token.getStringAfter(this.statement, trTime);
            String action = Token.getTokenAfter(this.statement, trTime);
            this.trigger.setActions(action);
            if (action.equalsIgnoreCase("UPDATE")) {
                String of = Token.getFirstToken(str = Token.getStringAfter(str, "UPDATE").trim()).trim();
                if (of.equalsIgnoreCase("OF")) {
                    str = str.substring(2, str.indexOf(" ON "));
                    this.trigger.setColumns(str);
                } else {
                    this.importLog.addError("Cannot find specified columns for UPDATE action while parsing trigger " + this.trigger.getName() + "(DB2)");
                    throw new ParseException("Cannot find specified columns for UPDATE action while parsing trigger " + this.trigger.getName() + "(DB2) ");
                }
            }
        }
    }

    private void initOnTable() throws ParseException {
        String str = this.statement.substring(this.statement.indexOf(" ON ") + 3).trim();
        str = Token.getFirstToken(str);
        String table = Token.getLastToken(str);
        if (((TableProxySetDB2)this.storageDesign.getTableProxySet()).getByName(table) == null) {
            this.importLog.addError("Specified table on trigger " + this.trigger.getName() + "does not exist");
            throw new ParseException("Specified table on trigger " + this.trigger.getName() + "does not exist");
        }
        this.trigger.setTable(((TableProxySetDB2)this.storageDesign.getTableProxySet()).getByName(table));
    }

    private void initReferencing() {
        if (Token.hasString(this.statement, "REFERENCING")) {
            String str;
            String refer = Token.getStringAfter(this.statement, "REFERENCING");
            if (Token.hasString(refer, "OLD AS ")) {
                str = refer.substring(refer.indexOf("OLD AS ") + 6);
                this.trigger.setRef_OLD_AS(Token.getFirstToken(str));
            } else if (Token.hasString(refer, "OLD_AS ")) {
                str = refer.substring(refer.indexOf("OLD_AS ") + 6);
                this.trigger.setRef_OLD_AS(Token.getFirstToken(str));
            } else {
                str = Token.getStringAfter(refer, " OLD ").trim();
                if (!str.equalsIgnoreCase("") && !Token.getFirstToken(str).equalsIgnoreCase("TABLE")) {
                    this.trigger.setRef_OLD_AS(Token.getFirstToken(str));
                }
            }
            if (Token.hasString(refer, "NEW AS ")) {
                str = refer.substring(refer.indexOf("NEW AS ") + 6);
                this.trigger.setRef_NEW_AS(Token.getFirstToken(str));
            } else if (Token.hasString(refer, "NEW_AS ")) {
                str = refer.substring(refer.indexOf("NEW_AS ") + 6);
                this.trigger.setRef_NEW_AS(Token.getFirstToken(str));
            } else {
                str = Token.getStringAfter(refer, " NEW ").trim();
                if (!str.equalsIgnoreCase("") && !Token.getFirstToken(str).equalsIgnoreCase("TABLE")) {
                    this.trigger.setRef_NEW_AS(Token.getFirstToken(str));
                }
            }
            if (Token.hasString(refer, "OLD TABLE AS ")) {
                str = refer.substring(refer.indexOf("OLD TABLE AS ") + 13);
                this.trigger.setOLD_TABLE_AS(Token.getFirstToken(str));
            }
            if (Token.hasString(refer, "NEW TABLE AS ")) {
                str = refer.substring(refer.indexOf("NEW TABLE AS ") + 13);
                this.trigger.setNEW_TABLE_AS(Token.getFirstToken(str));
            }
        }
    }

    private void initScope() throws ParseException {
        if (Token.hasString(this.statement, "FOR EACH ROW")) {
            this.trigger.setScope(TriggerDB2.SCOPE_TYPES[0]);
        } else if (Token.hasString(this.statement, "FOR EACH STATEMENT")) {
            this.trigger.setScope(TriggerDB2.SCOPE_TYPES[1]);
        } else {
            this.importLog.addError("Scope is not specified on trigger " + this.trigger.getName());
            throw new ParseException("Scope is not specified on trigger " + this.trigger.getName());
        }
    }

    private void initCondition() {
        if (Token.hasString(this.statement, "WHEN")) {
            String str = Token.getStringAfter(this.statement, "WHEN");
            this.trigger.setCondition(Token.getValBetweenBrackets(str, 1).trim());
        }
    }

    private void initBody() throws ParseException {
        int pos;
        String body = "";
        if (Token.hasString(this.statement, "FOR EACH ROW")) {
            body = Token.getStringAfter(this.statement, "FOR EACH ROW").trim();
        } else if (Token.hasString(this.statement, "FOR EACH STATEMENT")) {
            body = Token.getStringAfter(this.statement, "FOR EACH STATEMENT").trim();
        }
        if (!"".equals(body) && Token.hasString(body, "MODE DB2SQL")) {
            body = Token.getStringAfter(body, "MODE DB2SQL").trim();
        }
        if (!"".equals(body) && Token.hasString(body, "WHEN") && (pos = Token.getCloseBracketIndex(body = Token.getStringAfter(body, "WHEN").trim())) > -1) {
            body = body.substring(pos + 1).trim();
        }
        if ("".equals(body)) {
            this.importLog.addError("Incorrect syntax of body on trigger " + this.trigger.getName());
            throw new ParseException("Incorrect syntax of body on trigger " + this.trigger.getName());
        }
        this.trigger.setBody(body);
    }
}

