/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespace
extends DDLStatementHandler {
    private static final String LARGE = "LARGE";
    private TableSpaceDB2 tableSpace;
    private RDBMSSite site;
    private AbstractStorageDesignDB2 stoDesign;
    private String statementUC;
    private static final Logger LOGGER = new Logger(SHCreateTablespace.class);

    public SHCreateTablespace(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTablespace.clearCR(line);
        if (Token.startsWithString(statement, "create tablespace") || Token.startsWithString(statement, "create large tablespace") || Token.startsWithString(statement, "create lob tablespace")) {
            try {
                this.parseTablespace(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCreateTablespace.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseTablespace(String statement) {
        this.statement = statement;
        this.statementUC = statement.toUpperCase();
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = this.stoDesign.getTableSpaceSet().createTableSpace();
            this.initName();
            this.initLob();
            this.initNameDatabase();
            this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
            StorageTemplateDB2 storageTemplate = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
            this.design.getRelationalDesign().stampModelObjectDDL(storageTemplate);
            this.tableSpace.setStorageTemplate(storageTemplate);
            boolean hasNumParts = this.initNumParts();
            if (hasNumParts) {
                this.tableSpace.setType("PARTITIONED");
                String numPartBrackets = Token.getValBetweenBrackets(this.statement);
                PartitionSetDB2 partitionSet = this.tableSpace.getPartitionSet();
                StringTokenizer parts = new StringTokenizer(numPartBrackets, ",");
                while (parts.hasMoreElements()) {
                    String part = parts.nextToken().trim();
                    PartitionDB2 partition = partitionSet.createPartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(partition);
                    this.initPartPosition(part, partition);
                    StorageTemplateDB2 st = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    this.design.getRelationalDesign().stampModelObjectDDL(st);
                    partition.setStorageTemplate(st);
                    partition.setTableSpace(this.tableSpace);
                    this.initUsingBlockPart(part, partition);
                    this.initFreeBlockPart(part, partition);
                    this.initGbpcacheBlockPart(part, partition);
                    this.initTrackmodeBlockPart(part, partition);
                    this.initCompressPart(part, partition);
                    StorageTemplateDB2 realst = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(partition.getStorageTemplate());
                    if (realst == partition.getStorageTemplate()) continue;
                    partition.setStorageTemplate(realst);
                }
            }
            this.initUsingBlock();
            this.initFreeBlock();
            this.initGbpcacheBlock();
            this.initTrackmodeBlock();
            this.initLog();
            this.initDefine();
            this.initDSSize();
            this.initMemberCluster(hasNumParts);
            this.initSegsize();
            this.initBufferpool();
            this.initLocksize();
            this.initLockmax();
            this.initClose();
            this.initCompress();
            this.initCCsid();
            this.initLockpart();
            this.initMaxrows();
            StorageTemplateDB2 realst = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(this.tableSpace.getStorageTemplate());
            if (realst != this.tableSpace.getStorageTemplate()) {
                this.tableSpace.setStorageTemplate(realst);
            }
        }
    }

    private void initName() {
        String name = Token.getNameAfterToken(this.statement, "TABLESPACE", '\"', '\"').trim();
        this.tableSpace.setName(name);
    }

    private void initNameDatabase() {
        if (Token.hasToken(this.statement, "IN")) {
            String databaseName = Token.getNameAfterToken(this.statement, "IN", '\"', '\"').trim();
            if (!databaseName.equals("")) {
                DataBaseSetDB2 dbSet = this.stoDesign.getDataBaseSet();
                for (DataBaseDB2 database : dbSet) {
                    if (!database.getName().equalsIgnoreCase(databaseName)) continue;
                    this.tableSpace.setDataBase(database);
                    break;
                }
                if (this.tableSpace.getDataBase() == null) {
                    DataBaseDB2 database;
                    database = dbSet.createDataBase();
                    database.setName(databaseName);
                    this.tableSpace.setDataBase(database);
                }
            } else {
                DataBaseDB2 db = null;
                if (this.stoDesign != null) {
                    Iterator it = this.stoDesign.getDataBaseSet().iterator();
                    while (it.hasNext() && !(db = (DataBaseDB2)it.next()).isSystemDatabase()) {
                    }
                    if (db != null) {
                        this.tableSpace.setDataBase(db);
                    }
                }
            }
        } else {
            DataBaseDB2 database = (DataBaseDB2)this.stoDesign.getDataBaseSet().getByName("DSNDB04");
            this.tableSpace.setDataBase(database);
        }
    }

    private void initLog() {
        String log = Token.getTokenAfter(this.statement, "LOG").trim();
        if (log.equalsIgnoreCase("NO")) {
            this.tableSpace.setLobLogging(false);
        }
    }

    private void initDefine() {
        String define = Token.getTokenAfter(this.statement, "DEFINE").trim();
        if (define.equalsIgnoreCase("YES")) {
            this.tableSpace.getStorageTemplate().setDefine(true);
        }
    }

    private void initDSSize() {
        if (Token.hasToken(this.statement, "DSSIZE")) {
            String dssizeNumber = Token.getTokenAfter(this.statement, "DSSIZE");
            String dssizeLetter = this.initNumParts() ? Token.getTokenBefore(this.statement, "NUMPARTS") : (this.statement.indexOf("SEGSIZE") > -1 ? Token.getTokenBefore(this.statement, "SEGSIZE") : (this.statement.indexOf("MEMBER") > -1 ? Token.getTokenBefore(this.statement, "MEMBER") : (this.statement.indexOf("BUFFER_POOL") > -1 ? Token.getTokenBefore(this.statement, "BUFFER_POOL") : (this.statement.indexOf("LOCKSIZE") > -1 ? Token.getTokenBefore(this.statement, "LOCKSIZE") : Token.getTokenBefore(this.statement, "LOCKMAX")))));
            String dssizeString = dssizeNumber + " " + dssizeLetter;
            if (!dssizeString.equals("") && !dssizeNumber.equals("0")) {
                this.tableSpace.setDsSize(dssizeString);
            } else if (this.statementUC.indexOf(LARGE) > 0) {
                this.tableSpace.setDsSize("4 G");
            }
        }
    }

    private void initMemberCluster(boolean hasPartitions) {
        String memberCluster;
        boolean hasMemberProp = Token.hasToken(this.statement, "MEMBER");
        if (hasMemberProp && (memberCluster = Token.getTokenAfter(this.statement, "MEMBER")).equalsIgnoreCase("CLUSTER")) {
            this.tableSpace.setClustered(TableSpaceDB2.YES_NO_STATES[0]);
        }
    }

    private boolean initNumParts() {
        boolean hasNumParts = Token.hasToken(this.statement, "NUMPARTS");
        if (hasNumParts) {
            try {
                String numberPartsString = Token.getTokenAfter(this.statement, "NUMPARTS").trim();
                if (!numberPartsString.equals("")) {
                    int numberParts = Integer.parseInt(numberPartsString);
                    this.tableSpace.setNumParts(numberParts);
                    hasNumParts = numberParts > 0;
                }
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initNumParts: ");
                message.append(e.getMessage());
                LOGGER.error(message.toString(), e);
                this.importLog.addWarning("Wrong Numparts format in statement " + this.statement);
            }
        }
        return hasNumParts;
    }

    private void initSegsize() {
        String segsizeSt = Token.getTokenAfter(this.statement, "SEGSIZE").trim();
        if (!segsizeSt.equals("")) {
            this.tableSpace.setSegSize(segsizeSt);
        }
    }

    private void initBufferpool() {
        String nameBP = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        if (!nameBP.equals("")) {
            BufferPoolSetDB2 bpSet = this.stoDesign.getBufferPoolSet();
            for (BufferPoolDB2 bufferPool : bpSet) {
                if (!bufferPool.getName().equalsIgnoreCase(nameBP)) continue;
                this.tableSpace.setBufferPool(bufferPool);
                break;
            }
        }
    }

    private void initLocksize() {
        String locksize = Token.getTokenAfter(this.statement, "LOCKSIZE").trim();
        if (!locksize.equals("")) {
            String[] choises = TableSpaceDB2.getLockSizeValues();
            for (int i = 0; i < choises.length; ++i) {
                if (!choises[i].equalsIgnoreCase(locksize)) continue;
                this.tableSpace.setLockSize(choises[i]);
                break;
            }
        }
    }

    private void initLockmax() {
        try {
            String lockMaxSt = Token.getTokenAfter(this.statement, "LOCKMAX").trim();
            if (!"".equalsIgnoreCase(lockMaxSt)) {
                if ("SYSTEM".equalsIgnoreCase(lockMaxSt)) {
                    this.tableSpace.setLockMax(-1);
                } else {
                    int lockMax = Integer.parseInt(lockMaxSt);
                    this.tableSpace.setLockMax(lockMax);
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initLockmax: ");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong lockmax format in statement " + this.statement);
        }
    }

    private void initClose() {
        String close = Token.getTokenAfter(this.statement, "CLOSE").trim();
        if (close.equalsIgnoreCase("NO")) {
            this.tableSpace.setClose(false);
        }
    }

    private void initCompress() {
        String compress = Token.getTokenAfter(this.statement, "COMPRESS").trim();
        if (compress.equalsIgnoreCase("YES")) {
            this.tableSpace.setCompress(true);
        }
    }

    private void initCompressPart(String partString, PartitionDB2 partition) {
        String compress = Token.getTokenAfter(partString, "COMPRESS").trim();
        if (compress.equalsIgnoreCase("YES")) {
            partition.setCompress(true);
        }
    }

    private void initCCsid() {
        String ccsid = Token.getTokenAfter(this.statement, "CCSID").trim();
        if (!ccsid.equals("")) {
            String[] choices = TableSpaceDB2.getCCSIDValues();
            for (int i = 0; i < choices.length; ++i) {
                if (!choices[i].equals(ccsid)) continue;
                this.tableSpace.setCcsid(choices[i]);
                break;
            }
        }
    }

    private void initLockpart() {
        String lockpart = Token.getTokenAfter(this.statement, "LOCKPART").trim();
        if (lockpart.equalsIgnoreCase("YES")) {
            this.tableSpace.setLockPart(true);
        }
    }

    private void initMaxrows() {
        try {
            String maxRowSt = Token.getTokenAfter(this.statement, "MAXROWS").trim();
            if (!maxRowSt.equals("")) {
                int maxRow = Integer.parseInt(maxRowSt);
                this.tableSpace.setMaxRows(maxRow);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initMaxrows: ");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong maxrows format in statement " + this.statement);
        }
    }

    private void initUsingBlock() {
        String using = Token.getTokenAfter(this.statement, "USING").trim();
        if (using.equalsIgnoreCase("VCAT")) {
            String vcatName = Token.getTokenAfter(this.statement, "VCAT").trim();
            for (VCatDB2 vcat : this.stoDesign.getVCatSet()) {
                if (!vcat.getName().equalsIgnoreCase(vcatName)) continue;
                this.tableSpace.getStorageTemplate().setVCat(vcat);
                break;
            }
        } else if (using.equalsIgnoreCase("STOGROUP")) {
            String stogroupName = Token.getTokenAfter(this.statement, "STOGROUP").trim();
            StorageGroupSetDB2 stoGroupSet = this.stoDesign.getStorageGroupSet();
            this.tableSpace.getStorageTemplate().setStorageGroup(stoGroupSet.getOrCreateStorageGroup(stogroupName));
            try {
                String secqtyString;
                String priqtyString = Token.getTokenAfter(this.statement, "PRIQTY").trim();
                if (!priqtyString.equals("")) {
                    int priqty = Integer.parseInt(priqtyString);
                    this.tableSpace.getStorageTemplate().setSgPriqty(priqty);
                }
                if (!(secqtyString = Token.getTokenAfter(this.statement, "SECQTY").trim()).equals("")) {
                    int secqty = Integer.parseInt(secqtyString);
                    this.tableSpace.getStorageTemplate().setSgSeqty(secqty);
                }
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlock: ");
                message.append(e.getMessage());
                LOGGER.error(message.toString(), e);
                this.importLog.addWarning("Wrong using block format in statement " + this.statement);
            }
            String erase = Token.getTokenAfter(this.statement, "ERASE").trim();
            if (erase.equalsIgnoreCase("YES")) {
                this.tableSpace.getStorageTemplate().setSgErase(true);
            }
        }
    }

    private void initPartPosition(String partString, PartitionDB2 partition) {
        try {
            String posStr = Token.getTokenAfter(partString, "PART").trim();
            if (!posStr.equals("")) {
                int pos = Integer.parseInt(posStr);
                partition.setPartNumber(pos);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initPartPosition: ");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong part position format in statement " + this.statement);
        }
    }

    private void initUsingBlockPart(String partString, PartitionDB2 partition) {
        String using = Token.getTokenAfter(partString, "USING").trim();
        if (using.equalsIgnoreCase("VCAT")) {
            String vcatName = Token.getTokenAfter(partString, "VCAT").trim();
            VCatDB2 vcat = this.stoDesign.getVCatSet().getOrCreateVCat(vcatName);
            partition.getStorageTemplate().setVCat(vcat);
        } else if (using.equalsIgnoreCase("STOGROUP")) {
            String stogroupName = Token.getTokenAfter(partString, "STOGROUP").trim();
            StorageGroupSetDB2 stoGroupSet = this.stoDesign.getStorageGroupSet();
            partition.getStorageTemplate().setStorageGroup(stoGroupSet.getOrCreateStorageGroup(stogroupName));
            try {
                String secqtyString;
                String priqtyString = Token.getTokenAfter(partString, "PRIQTY").trim();
                if (!priqtyString.equals("")) {
                    int priqty = Integer.parseInt(priqtyString);
                    partition.getStorageTemplate().setSgPriqty(priqty);
                }
                if (!(secqtyString = Token.getTokenAfter(partString, "SECQTY").trim()).equals("")) {
                    int secqty = Integer.parseInt(secqtyString);
                    partition.getStorageTemplate().setSgSeqty(secqty);
                }
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlockPart: ");
                message.append(e.getMessage());
                LOGGER.error(message.toString(), e);
                this.importLog.addWarning("Wrong using block part format in statement " + this.statement);
            }
            String erase = Token.getTokenAfter(partString, "ERASE").trim();
            if (erase.equalsIgnoreCase("YES")) {
                partition.getStorageTemplate().setSgErase(true);
            }
        }
    }

    private void initFreeBlock() {
        try {
            String pctfreeString;
            String freepageString = Token.getTokenAfter(this.statement, "FREEPAGE").trim();
            if (!freepageString.equals("")) {
                int freepage = Integer.parseInt(freepageString);
                this.tableSpace.getStorageTemplate().setFreePage(freepage);
            }
            if (!(pctfreeString = Token.getTokenAfter(this.statement, "PCTFREE").trim()).equals("")) {
                int pctfree = Integer.parseInt(pctfreeString);
                this.tableSpace.getStorageTemplate().setPctFree(pctfree);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlock: ");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong free block format in statement " + this.statement);
        }
    }

    private void initFreeBlockPart(String partString, PartitionDB2 partition) {
        try {
            String pctfreeString;
            String freepageString = Token.getTokenAfter(partString, "FREEPAGE").trim();
            if (!freepageString.equals("")) {
                int freepage = Integer.parseInt(freepageString);
                partition.getStorageTemplate().setFreePage(freepage);
            }
            if (!(pctfreeString = Token.getTokenAfter(partString, "PCTFREE").trim()).equals("")) {
                int pctfree = Integer.parseInt(pctfreeString);
                partition.getStorageTemplate().setPctFree(pctfree);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlockPart: ");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong free block part format in statement " + this.statement);
        }
    }

    private void initGbpcacheBlock() {
        String gbpcache = Token.getTokenAfter(this.statement, "GBPCACHE").trim().toUpperCase();
        if (!gbpcache.equals("")) {
            String[] choices = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < choices.length; ++i) {
                if (!gbpcache.equalsIgnoreCase(choices[i])) continue;
                this.tableSpace.getStorageTemplate().setGbCache(choices[i]);
                break;
            }
        }
    }

    private void initGbpcacheBlockPart(String partString, PartitionDB2 partition) {
        String gbpcache = Token.getTokenAfter(partString, "GBPCACHE").trim().toUpperCase();
        if (!gbpcache.equals("")) {
            String[] choices = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < choices.length; ++i) {
                if (!gbpcache.equalsIgnoreCase(choices[i])) continue;
                partition.getStorageTemplate().setGbCache(choices[i]);
            }
        }
    }

    private void initTrackmodeBlockPart(String partString, PartitionDB2 partition) {
        String trackmod = Token.getTokenAfter(partString, "TRACKMOD").trim();
        if (trackmod.equalsIgnoreCase("YES")) {
            partition.getStorageTemplate().setTrackMode(true);
        }
    }

    private void initTrackmodeBlock() {
        String trackmod = Token.getTokenAfter(this.statement, "TRACKMOD").trim();
        if (!trackmod.equals("") && trackmod.equalsIgnoreCase("NO")) {
            this.tableSpace.getStorageTemplate().setTrackMode(false);
        }
    }

    public TableSpaceDB2 getTablespace() {
        return this.tableSpace;
    }

    private void initLob() {
        if (Token.getTokenAfter(this.statement, "CREATE").trim().equalsIgnoreCase("LOB")) {
            this.tableSpace.setType("LOB");
        }
    }
}

