/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.parser.ScriptParser;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class DDLStatementHandler
implements StatementsConstants {
    private DDLStatementHandler successor = null;
    protected String statement = null;
    protected Design design = null;
    private Owner owner;
    protected ImportLogger importLog;
    private boolean asSelectOnly = true;
    private static String saveClearCRInput = "";
    private static String saveClearCROutput = "";

    public DDLStatementHandler(Design design) {
        this.design = design;
    }

    public void add(DDLStatementHandler succ) {
        DDLStatementHandler end = this;
        while (end.successor != null) {
            end = end.successor;
        }
        end.successor = succ;
    }

    public void handle(String line) {
        this.nextHandler(line);
        saveClearCRInput = "";
        saveClearCROutput = "";
    }

    public void nextHandler(String line) {
        if (this.successor != null) {
            this.successor.setImportLog(this.importLog);
            this.successor.handle(line);
        } else {
            String upperCaseStatement = DDLStatementHandler.clearCR(line).toUpperCase();
            if (upperCaseStatement.equals("/") || upperCaseStatement.startsWith("SET CURRENT SCHEMA") || upperCaseStatement.startsWith("SET CURRENT SQLID")) {
                this.importLog.incrementImportedStatements();
            } else {
                this.importLog.addNotRecognized(line);
            }
        }
    }

    public static String clearCR(String line) {
        if (line != saveClearCRInput) {
            saveClearCRInput = line;
            int quoteIndex = (line = ScriptParser.removeComments(line)).indexOf("'");
            if (quoteIndex > -1) {
                int startIndex = 0;
                StringBuffer buffer = new StringBuffer();
                while (quoteIndex > -1) {
                    String beforeLit = line.substring(startIndex, quoteIndex);
                    int endQuoteIndex = line.indexOf("'", quoteIndex + 1);
                    if (endQuoteIndex == -1 || beforeLit.endsWith("Q") || beforeLit.endsWith("q")) {
                        saveClearCROutput = line.replaceAll("[ \t\n\f\r\u000b]+", " ");
                        return saveClearCROutput;
                    }
                    buffer.append(beforeLit.replaceAll("[ \t\n\f\r\u000b]+", " "));
                    buffer.append(line.substring(quoteIndex, endQuoteIndex + 1));
                    startIndex = endQuoteIndex + 1;
                    quoteIndex = line.indexOf("'", startIndex);
                }
                buffer.append(line.substring(startIndex).replaceAll("[ \t\n\f\r\u000b]+", " "));
                saveClearCROutput = buffer.toString();
            } else {
                saveClearCROutput = line.replaceAll("[ \t\n\f\r\u000b]+", " ");
            }
        }
        return saveClearCROutput;
    }

    public static String FormatCR(String line, String newStr) {
        return line;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public void setAsSelectOnly(boolean asSelectOnly) {
        this.asSelectOnly = asSelectOnly;
    }

    public boolean isAsSelectOnly() {
        return this.asSelectOnly;
    }

    protected void determineAndCutLength(String token) {
        int lengthCut = token.length();
        if (lengthCut < this.statement.length()) {
            ++lengthCut;
        }
        this.statement = this.statement.substring(lengthCut).trim();
    }

    protected String cutStringFromFront(String sentence, String word) {
        int lengthCut = word.length();
        if (lengthCut < this.statement.length()) {
            ++lengthCut;
        }
        String result = sentence.substring(lengthCut).trim();
        return result;
    }

    public Table getTableFromDesign(String name) {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table[] tables = (Table[])tableSet.toArray();
        for (int i = 0; i < tables.length; ++i) {
            if (!tables[i].getName().equalsIgnoreCase(name)) continue;
            return tables[i];
        }
        return null;
    }

    public Column getColumnFromTable(Table table, String name) {
        Column[] columns = (Column[])table.getElements();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equalsIgnoreCase(name)) continue;
            return columns[i];
        }
        return null;
    }

    public String getNameOnly(String fullName) {
        if (fullName.indexOf(46) > 0) {
            return Token.getValAfterCharacter(fullName, '.').trim();
        }
        return fullName;
    }

    protected String getNumberOnly(String value) {
        char lastChar;
        if (value.length() > 1 && Character.isLetter(lastChar = value.charAt(value.length() - 1))) {
            lastChar = Character.toUpperCase(lastChar);
            long multFactor = 1024L;
            if (lastChar != 'K') {
                multFactor *= 1024L;
                if (lastChar != 'M') {
                    multFactor *= 1024L;
                    if (lastChar != 'G') {
                        multFactor *= 1024L;
                        if (lastChar != 'T') {
                            multFactor *= 1024L;
                            if (lastChar != 'P') {
                                multFactor *= 1024L;
                                if (lastChar != 'E') {
                                    return value;
                                }
                            }
                        }
                    }
                }
            }
            String numericPart = value.substring(0, value.length() - 1).trim();
            try {
                long v = Long.parseLong(numericPart) * multFactor;
                value = String.valueOf(v);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return value;
    }

    public CreateTableHandler getCreateTableHandler() {
        if (this instanceof CreateTableHandler) {
            return (CreateTableHandler)((Object)this);
        }
        if (this.successor != null) {
            return this.successor.getCreateTableHandler();
        }
        return null;
    }

    public AlterTableHandler getAlterTableHandler() {
        if (this instanceof AlterTableHandler) {
            return (AlterTableHandler)((Object)this);
        }
        if (this.successor != null) {
            return this.successor.getAlterTableHandler();
        }
        return null;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        if (this.successor != null) {
            this.successor.setOwner(owner);
        }
    }

    public ImportLogger getImportLog() {
        return this.importLog;
    }

    public void setImportLog(ImportLogger importLog) {
        this.importLog = importLog;
    }

    public StorageDesign getStorageDesign() {
        return this.design.getStorageDesign(this.design.getSelectedRDBMSSite());
    }
}

