/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.ddl.AbstractDDLObjectHandler;
import oracle.dbtools.crest.imports.ddl.DDLDesignObject;
import oracle.dbtools.crest.imports.ddl.DDLExtractionHandler;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class DDLRelationalDesign
extends AbstractDDLObjectHandler {
    public static final String OBJECT_TYPE = "PHYSICAL DESIGN";

    public DDLRelationalDesign(DDLExtractionHandler handler, ApplicationView view) {
        super(handler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(List appSystems) throws Exception {
        ArrayList list = new ArrayList();
        for (DDLDesignObject object : appSystems) {
            if (!object.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            RelationalDesign physical = (RelationalDesign)object.getSelectedRelDesign();
            if (!physical.isLoaded()) {
                physical.setShouldBeOpen(true);
                this.getDesign().setClosing(true);
                physical.clearDesignPart();
                this.getDesign().setClosing(false);
                physical.load();
                if (object.getSelectedRelDesign() instanceof RelationalDesign) {
                    physical.setImportTo((RelationalDesign)object.getSelectedRelDesign());
                    continue;
                }
                physical.setImportTo(null);
                continue;
            }
            RelationalDesign physDes = (RelationalDesign)object.getSelectedRelDesign();
            physDes.setShouldBeOpen(false);
        }
        return list;
    }

    @Override
    public void generate(List selectedObjects, ImportLogger importLog) throws Exception {
        for (DDLDesignObject object : selectedObjects) {
            if (!object.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            RelationalDesign physical = (RelationalDesign)object.getSelectedRelDesign();
            if (physical.getImportTo() == null) {
                physical.setName(physical.getName() + "_" + physical.getDesign().getName());
                RelationalDesign newphysical = this.getOldDesign().addRelationalDesign(physical.getName());
                newphysical.setShouldEngineer(physical.getShouldEngineer());
                newphysical.setComment(physical.getComment());
                physical.setImportTo(newphysical);
            }
            this.importNotes(physical, physical.getImportTo());
            importLog.incrementImportedStatements();
        }
    }

    private void importNotes(RelationalDesign physical, RelationalDesign newPhysical) {
        for (int k = 0; k < physical.getNoteSet().size(); ++k) {
            Note newNote;
            Note note = (Note)physical.getNoteSet().getElement(k);
            if (newPhysical.getNoteSet().getByName(note.getName()) != null) {
                if (!this.canImport()) continue;
                String name = this.getPrefix() + note.getName();
                newNote = newPhysical.getNoteSet().createNote(null);
                newNote.copy(newNote);
                newNote.setText(note.getText());
                newNote.setName(name);
                newNote.setImportedDesign(physical.getDesign());
                newNote.setImportedId(note.getObjectID());
                continue;
            }
            newNote = newPhysical.getNoteSet().createNote(null);
            newNote.copy(newNote);
            newNote.setText(note.getText());
            newNote.setImportedDesign(physical.getDesign());
            newNote.setImportedId(note.getObjectID());
        }
    }
}

