/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.ChangeListTreePanel;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOperationCommit;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.TimeLog;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.xspi.ALMCommitContext;
import oracle.jdevimpl.vcs.xspi.XVCSCommandState;
import oracle.jdevimpl.vcs.xspi.XVCSComponents;

public class SVNCommitCommand
extends DMSVNOperationCommit {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.commit" : SVNCommitCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.commit", SVNCommitCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    protected VersionOperationSelectTablePanel versionOperationPanel = null;

    public SVNCommitCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.commit");
    }

    protected boolean isSilent(Context context, VCSProfile profile) {
        return true;
    }

    public boolean isAvailableImpl() {
        ArrayList<VersioningTreeNode> treeNodesForCommit = new ArrayList<VersioningTreeNode>();
        ChangeListTreePanel outgoingChangesPanel = (ChangeListTreePanel)SVNChangeListWindow.getSVNOutgoingChangesChangeList().getPanel();
        if (outgoingChangesPanel.getTree().getSelectionCount() > 0) {
            outgoingChangesPanel.getSelectedFilePaths(treeNodesForCommit, true, true);
            if (treeNodesForCommit.size() == 1 && ((VersioningTreeNode)treeNodesForCommit.get(0)).getStorableObjectStatus().isMissing()) {
                return false;
            }
        }
        return SVN_CLIENT_HELPER.actionsEnabled(SVNChangeListWindow.getSVNOutgoingChangesChangeList(), null, false, false, false, true, true, false, false, false);
    }

    public boolean isAvailable() {
        ArrayList<VersioningTreeNode> treeNodesForCommit = new ArrayList<VersioningTreeNode>();
        SVNOutgoingChangesChangeList outgoingChangesChangeList = SVNChangeListWindow.getSVNOutgoingChangesChangeList();
        this.collectTreeNodes(outgoingChangesChangeList, treeNodesForCommit);
        this.removeMissingAndDeletedDependantNodes(treeNodesForCommit);
        if (treeNodesForCommit.size() > 0) {
            for (int i = 0; i < treeNodesForCommit.size(); ++i) {
                StorableObjectStatus storableObjectStatus = ((VersioningTreeNode)treeNodesForCommit.get(i)).getStorableObjectStatus();
                if (storableObjectStatus.getTextStatus().compareTo("C") != 0) continue;
                return false;
            }
            return true;
        }
        return super.isAvailable();
    }

    private void addModelDirectory(List<VersioningTreeNode> treeNodesForCommit) {
        ArrayList<VersioningTreeNode> added = new ArrayList<VersioningTreeNode>();
        ArrayList<VersioningTreeNode> removed = new ArrayList<VersioningTreeNode>();
        for (VersioningTreeNode node : treeNodesForCommit) {
            VersioningTreeNode dnode;
            String dir;
            StorableObjectStatus stat = node.getStorableObjectStatus();
            if (stat == null || stat.getObjectClass() == null) continue;
            if ("A".equals(stat.getTextStatus()) && Design.class.isAssignableFrom(stat.getObjectClass())) {
                dir = ChangeListTreePanel.getModelDir(stat);
                dnode = new VersioningTreeNode(node.getShortLabel(), new File(dir), File.class);
                dnode.setTextStatus(stat.getTextStatus());
                dnode.setRecursuve(true);
                added.add(dnode);
                continue;
            }
            if ("A".equals(stat.getTextStatus()) && DesignPart.class.isAssignableFrom(stat.getObjectClass())) {
                dir = ChangeListTreePanel.getModelDir(stat);
                dnode = new VersioningTreeNode(node.getShortLabel(), new File(dir), File.class);
                dnode.setTextStatus(stat.getTextStatus());
                dnode.setRecursuve(true);
                added.add(dnode);
                if (ChangeListTreePanel.isFileAndDirModel(stat.getObjectClass())) continue;
                removed.add(node);
                continue;
            }
            if ("A".equals(stat.getTextStatus()) && StorageDesign.class.isAssignableFrom(stat.getObjectClass())) {
                String name = stat.getStorableObjectName();
                String dir2 = ChangeListTreePanel.getModelDir(stat);
                VersioningTreeNode dnode2 = new VersioningTreeNode(name, new File(dir2), stat.getObjectClass());
                dnode2.setTextStatus(stat.getTextStatus());
                dnode2.setRecursuve(true);
                added.add(dnode2);
                removed.add(node);
                continue;
            }
            if (!"A".equals(stat.getTextStatus()) || !TransformationPackage.class.isAssignableFrom(stat.getObjectClass())) continue;
            dir = ChangeListTreePanel.getModelDir(stat);
            dnode = new VersioningTreeNode(node.getShortLabel(), new File(dir), File.class);
            dnode.setTextStatus(stat.getTextStatus());
            dnode.setRecursuve(true);
            added.add(dnode);
            if (ChangeListTreePanel.isFileAndDirModel(stat.getObjectClass())) continue;
            removed.add(node);
        }
        treeNodesForCommit.removeAll(removed);
        treeNodesForCommit.addAll(added);
    }

    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        if (this.context.getView().getId().equals("FileNavigatorWindow.Files")) {
            return super.doitImpl(vcsProfile);
        }
        SVNOutgoingChangesChangeList outgoingChangesChangeList = SVNChangeListWindow.getSVNOutgoingChangesChangeList();
        ArrayList<VersioningTreeNode> treeNodesForCommit = new ArrayList<VersioningTreeNode>();
        XVCSCommandState state = new XVCSCommandState();
        TimeLog.log("Start collectTreeNodes");
        this.collectTreeNodes(outgoingChangesChangeList, treeNodesForCommit);
        TimeLog.log("Start removeMissingAndDeletedDependantNodes");
        this.removeMissingAndDeletedDependantNodes(treeNodesForCommit);
        TimeLog.log("end removeMissingAndDeletedDependantNodes");
        this.addModelDirectory(treeNodesForCommit);
        Locatable[] nodesForCommit = treeNodesForCommit.toArray(new Locatable[0]);
        TimeLog.log("Start removeMissingAndDeletedDependantNodes");
        TimeLog.log("state.setLocatables");
        state.setLocatables(nodesForCommit);
        TimeLog.log("Start commit");
        boolean res = super.invokeCommand(vcsProfile, (CommandState)state);
        TimeLog.log("End commit");
        if (res) {
            outgoingChangesChangeList.refresh();
            TimeLog.log("End outgoingChangesChangeList.refresh();");
            TimeLog.log("Start  for(int i = 0; i < treeNodesForCommit.size(); i++) {");
            TimeLog.log("END  for(int i = 0; i < treeNodesForCommit.size(); i++) {");
        }
        return 0;
    }

    protected void collectTreeNodes(SVNOutgoingChangesChangeList changeList, List<VersioningTreeNode> treeNodes) {
        IChangeListPanel pan = changeList.getPanel();
        if (pan instanceof ChangeListTreePanel) {
            ChangeListTreePanel tpan = (ChangeListTreePanel)pan;
            if (tpan.getSelectedNode() == null) {
                tpan.getAllFilePathsForCommit(treeNodes, true, true);
            } else {
                pan.getSelectedFilePaths(treeNodes, true, true);
            }
        } else {
            pan.getSelectedFilePaths(treeNodes, true, true);
        }
    }

    protected void removeMissingAndDeletedDependantNodes(List<VersioningTreeNode> nodes) {
        for (int i = nodes.size() - 1; i >= 0; --i) {
            VersioningTreeNode node = nodes.get(i);
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            if ((!storableObjectStatus.isDeleted() || node.getDependingOn() == null) && !storableObjectStatus.isMissing()) continue;
            nodes.remove(i);
        }
    }

    @Override
    protected void invokeCommit(VCSProfile profile, CommandState state, Map options, IndeterminateProgressMonitor progress) throws Exception {
        if (this.versionOperationPanel != null) {
            state.setLocatables(this.versionOperationPanel.getSelectedLocatables());
        }
        boolean recursive = false;
        Locatable[] locatables = state.getLocatables();
        ArrayList<File> filePaths = new ArrayList<File>(locatables.length);
        for (Locatable locatable : locatables) {
            File dependantFilePath;
            VersioningTreeNode versioningTreeNode = (VersioningTreeNode)locatable;
            recursive = recursive || versioningTreeNode.isRecursuve();
            this.findNotAddedParents(versioningTreeNode, filePaths);
            if (!this.isFilePathAdded(filePaths, versioningTreeNode.getFilePath())) {
                filePaths.add(versioningTreeNode.getFilePath());
            }
            if ((dependantFilePath = versioningTreeNode.getDependantFilePath()) == null || this.isFilePathAdded(filePaths, dependantFilePath)) continue;
            filePaths.add(dependantFilePath);
        }
        Collections.sort(filePaths);
        Boolean kl = (Boolean)options.get("oracle.jdeveloper.subversion.KEEP_LOCKS");
        SVN_CLIENT_HELPER.doCommit(filePaths.toArray(new File[0]), (String)options.get("setting_comments"), recursive, kl == null ? false : kl);
    }

    @Override
    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        this.versionOperationPanel = SVN_CLIENT_HELPER.createVersionOperationTablePanel((List)nodes);
        this.setSVNVersionOperationPanel(VCSComponents.createSelectFileListerComponent((Collection)nodes));
        return XVCSComponents.createCommitOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)this.versionOperationPanel, (VCSOptionsCustomizer)customizer, (String)this.getHelpTopicId(), (ALMCommitContext)((XVCSCommandState)commandState).getALMCommitContext());
    }

    public void findNotAddedParents(VersioningTreeNode versioningTreeNode, List<File> notAddedParentFilePaths) {
        StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
        if (storableObjectStatus != null && "A".equals(storableObjectStatus.getTextStatus())) {
            this.findNotAddedParents(versioningTreeNode.getFilePath(), notAddedParentFilePaths);
        }
    }

    public void findNotAddedParents(File filePath, List<File> filePaths) {
        File parentFilePath = filePath.getParentFile();
        if (SVN_CLIENT_HELPER.isVersioned(parentFilePath) && SVN_CLIENT_HELPER.getLastChangedRevision(parentFilePath) <= 0L) {
            if (!this.isFilePathAdded(filePaths, parentFilePath)) {
                filePaths.add(parentFilePath);
            }
            this.findNotAddedParents(parentFilePath, filePaths);
        }
    }

    private boolean isFilePathAdded(List<File> filePaths, File dependantFilePath) {
        for (File listFile : filePaths) {
            if (!listFile.getAbsolutePath().equalsIgnoreCase(dependantFilePath.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }
}

