/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionHistoryCommand;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.jdeveloper.vcs.spi.VCSController;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;

public class SVNCommandController
extends VCSController {
    private static SVNCommandController instance;
    private Map<String, Command> commandsMap = new HashMap<String, Command>();

    private SVNCommandController() {
        super(AbstractSVNOperation.class.getPackage());
    }

    public static SVNCommandController getInstance() {
        if (instance == null) {
            instance = new SVNCommandController();
        }
        return instance;
    }

    public void register(IdeAction action, Command command) {
        this.commandsMap.put(action.getCommand(), command);
        action.addController((Controller)this);
    }

    protected boolean isHandledAction(IdeAction action) {
        return this.commandsMap.keySet().contains(action.getCommand());
    }

    protected Command createCommand(String commandName, Context context) {
        Command command = this.commandsMap.get(commandName);
        command.setContext(context);
        return command;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        String command_ID = action.getCommand();
        if (command_ID.compareTo(SVNVersionHistoryCommand.class.getName()) == 0) {
            SVNVersionHistoryCommand command = new SVNVersionHistoryCommand();
            try {
                command.setContext(context);
                command.doit();
                return true;
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                return true;
            }
        }
        return super.handleEvent(action, context);
    }
}

