/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.BrowserDockable;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.RevisionRange;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNViewPropertiesWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeWindow;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.XMLFromMapToSteramTransformer;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.io.LocalFileFilter;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.model.Locatable;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class VCSClientHelper<L, R, S, U, I, D, P> {
    private static final Logger LOGGER = new Logger(VCSClientHelper.class);
    public static final String DM_PROPERTIES = "dm:properties";
    public static final String DM_PROPERTIES_SEPARATOR = ":::";
    public static final String SUBVERSION_EXTRA_FOLDER_NAME = ".svn";
    public static final String DMD_OPEN = "dmd_open";
    public static final int PROPERTY_ID = 0;
    public static final int PROPERTY_CLASS_NAME = 1;
    public static final int PROPERTY_PARENT_ID = 2;
    public static final int PROPERTY_SOURCE_ID = 3;
    public static final int PROPERTY_TARGET_ID = 4;
    public static final int PROPERTY_NAME = 5;
    public static final int PROPERTIES_COUNT = 6;
    public static final int PROPERTIES_COUNT_OLD = 4;

    public abstract I doInfo(File var1);

    protected abstract void doAdd(File var1, boolean var2);

    public void doAdd(File filePath) {
        if (filePath.isDirectory()) {
            File[] allFiles = filePath.listFiles();
            this.doAdd(filePath, false);
            this.doIgnore(filePath, "*.localz");
            this.doIgnore(filePath, "*.local");
            for (File childFilePath : allFiles) {
                if (childFilePath.isDirectory()) {
                    this.doAdd(childFilePath);
                    continue;
                }
                if (!VCSClientHelper.acceptFile(childFilePath)) continue;
                this.doAdd(childFilePath, false);
            }
        } else if (VCSClientHelper.accept(filePath)) {
            this.doAdd(filePath, false);
        }
    }

    public void doAddFolder(File filePath) {
        this.doAdd(filePath, true);
    }

    public void doRemove(List<String> fileNames) {
        if (!fileNames.isEmpty()) {
            ArrayList<File> filePaths = new ArrayList<File>();
            for (String fileName : fileNames) {
                File filePath = new File(fileName);
                if (!filePath.exists()) continue;
                filePaths.add(filePath);
            }
            if (!filePaths.isEmpty()) {
                this.doRemove(filePaths.toArray(new File[0]));
            }
        }
    }

    public abstract void doRemove(File[] var1);

    public abstract boolean isDeleted(File var1);

    public abstract List<S> doStatus(File var1, boolean var2);

    public abstract void doUpdate(File[] var1, boolean var2);

    public abstract void doCommit(File[] var1, String var2, boolean var3, boolean var4);

    public abstract void doRevert(File[] var1, boolean var2);

    public abstract void doCleanup(File var1);

    public abstract InputStream doGetRevision(U var1, R var2);

    public abstract InputStream doGetRevision(File var1, R var2);

    public abstract void doResolved(File var1);

    public abstract void doIgnore(File var1, String var2);

    public abstract List<D> doDiffSummarize(U var1, U var2);

    public abstract List<MergeConflict> doMerge(U var1, File var2, List<RevisionRange> var3, boolean var4, boolean var5);

    public abstract boolean doMergeReintegrate(U var1, File var2, List<MergeConflict> var3);

    public abstract void doCopy(String var1, File var2, Long var3);

    public abstract List<StorableObjectStatus> getStatuses(Design var1, boolean var2, boolean var3, boolean var4);

    public abstract VersionOperationSelectTablePanel createVersionOperationTablePanel(List<DisplayableLocatableNode> var1);

    public boolean hasProperty(File file, String propertyName) {
        return this.doGetProperty(file, propertyName) != null;
    }

    public abstract String doGetProperty(U var1, String var2, Long var3);

    public abstract String doGetProperty(File var1, String var2);

    public String doGetProperty(U url, int propertyIndex, Long revision) {
        return this.getProperty(this.doGetProperty(url, DM_PROPERTIES, revision), propertyIndex);
    }

    public String doGetProperty(File file, int propertyIndex) {
        return this.getProperty(this.doGetProperty(file, DM_PROPERTIES), propertyIndex);
    }

    public abstract P[] doGetProperties(String var1, Long var2);

    public abstract void doSetProperty(File var1, String var2, String var3);

    public abstract boolean isVersioned(File var1);

    public abstract boolean exists(String var1);

    public abstract long getRevision(File var1);

    public abstract long getLastChangedRevision(File var1);

    public abstract Long getLastMergedRevision(File var1, Long var2, String var3);

    public abstract List<L> doGetLogMessages(U var1, Long var2, Long var3, boolean var4, boolean var5, int var6);

    public abstract List<L> doGetLogMessages(File var1, Long var2, Long var3, boolean var4, boolean var5, int var6);

    public abstract void doLock(File[] var1, boolean var2, String var3);

    public abstract void doUnlock(File[] var1, boolean var2);

    public boolean isVersioned(String workingCopyRoot) {
        return StringUtilities.isNotEmpty(workingCopyRoot) && this.isVersioned(new File(workingCopyRoot));
    }

    public abstract ISVNStatus getSingleStatusLocal(File var1);

    public void checkVersioned(Design design) {
        if (this.isVersioned(design.getStoragePath())) {
            design.setVersioned(true);
            this.checkProperties(design, true);
        } else {
            design.setVersioned(false);
        }
    }

    public void checkAndSetVersionedDesignOnly(Design design) {
        if (StringUtilities.isNotEmpty(design.getStoragePath())) {
            ISVNStatus stat = this.getSingleStatusLocal(new File(design.getStoragePath()));
            if (stat != null && stat.getRevision() != null && stat.getRevision().getNumber() > 0L) {
                design.setVersioned(true);
            } else {
                design.setVersioned(false);
            }
        }
    }

    public void checkProperties(Design design, boolean showWarning) {
        this.checkProperties(design, showWarning, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkProperties(Design design, boolean showWarning, boolean commit) {
        String designFilePath = design.getStoragePath();
        if (this.isVersioned(designFilePath) && !this.hasProperties(design)) {
            DockStation dockStation;
            File[] filesToCommit = new File[]{new File(design.getStorageName()), new File(designFilePath)};
            if (showWarning) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("VCSClientHelper.SetProperties"), Messages.getString("VCSClientHelper.SetPropertiesTitle"), 2);
            }
            if ((dockStation = DockStation.getDockStation()).getDockable(SVNChangeListWindow.VIEW_ID) != null) {
                SVNChangeListWindow changeListWindow = (SVNChangeListWindow)dockStation.getDockable(SVNChangeListWindow.VIEW_ID);
                changeListWindow.getSVNOutgoingChangesChangeList().setDataModelerChangesTimerTaskUpdatable(false);
                changeListWindow.getSVNIncomingChangesChangeList().setDataModelerChangesTimerTaskUpdatable(false);
                changeListWindow.getSVNUnversionedFilesChangeList().setDataModelerChangesTimerTaskUpdatable(false);
            }
            try {
                ProgressDialog monitor = new ProgressDialog(design.getAppView(), Messages.getString("VCSClientHelper.SetIntegrityProperties"), 0, 100);
                try {
                    monitor.setNote(Messages.getString("VCSClientHelper.SettingIgnoreList"));
                    monitor.setProgress(10);
                    design.getAppView().setCurrentDesign(design);
                    this.deleteLocalFilesAndSetIgnoreList(designFilePath);
                    monitor.setProgress(20);
                    monitor.setProgress(30);
                }
                catch (Exception e) {
                    LOGGER.error(e.getStackTrace()[0].toString());
                }
                if (!design.isLoadedCompletely()) {
                    try {
                        monitor.setNote(Messages.getString("VCSClientHelper.LoadingCompleteDesign"));
                        design.loadAllModels();
                        monitor.setProgress(35);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getStackTrace()[0].toString());
                    }
                }
                try {
                    monitor.setNote(Messages.getString("VCSClientHelper.SavingNewlyCreatedProperties"));
                    ApplicationView.log("save properties - start");
                    TimeLog.log("save properties - start");
                    this.saveProperties(design);
                    ApplicationView.log("save properties - end");
                    TimeLog.log("save properties - end");
                    monitor.setProgress(80);
                }
                catch (Exception e) {
                    LOGGER.error(e.getStackTrace()[0].toString());
                }
                if (commit) {
                    try {
                        monitor.setNote(Messages.getString("VCSClientHelper.CommittingToRepository"));
                        this.doCommit(filesToCommit, null, true, false);
                        ApplicationView.log("save properties - end commit");
                        TimeLog.log("save properties - end commit");
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getStackTrace()[0].toString());
                    }
                }
                try {
                    monitor.setNote(Messages.getString("VCSClientHelper.FinishingIntegrityCheck"));
                    monitor.setProgress(95);
                    monitor.setProgress(100);
                }
                catch (Exception e) {
                    LOGGER.error(e.getStackTrace()[0].toString());
                }
                finally {
                    if (dockStation.getDockable(SVNChangeListWindow.VIEW_ID) != null) {
                        SVNChangeListWindow changeListWindow = (SVNChangeListWindow)dockStation.getDockable(SVNChangeListWindow.VIEW_ID);
                        changeListWindow.getSVNOutgoingChangesChangeList().setDataModelerChangesTimerTaskUpdatable(true);
                        changeListWindow.getSVNIncomingChangesChangeList().setDataModelerChangesTimerTaskUpdatable(true);
                        changeListWindow.getSVNUnversionedFilesChangeList().setDataModelerChangesTimerTaskUpdatable(true);
                    }
                    monitor.close();
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getStackTrace()[0].toString());
            }
        }
    }

    public boolean hasProperties(Design design) {
        String designFileName = design.getStorageName();
        if (design.isCompressedDesign()) {
            designFileName = designFileName + "z";
        }
        return this.hasProperty(new File(designFileName), DM_PROPERTIES);
    }

    public void saveProperties(Design design) {
        if (design.isVersioned()) {
            String designFileName = design.getStorageName();
            if (design.isCompressedDesign()) {
                designFileName = designFileName + "z";
            }
            this.setProperties(null, new File(designFileName), new String[]{design.getObjectID(), design.getClass().getName(), "", null, null, design.getName()});
            this.saveDesignPartProperties(design.getBusinessInfoDesign());
            this.saveDesignPartProperties(design.getDataTypesDesign());
            this.saveDPVs(design.getDataTypesDesign(), true);
            this.saveDesignPartProperties(design.getLogicalDesign());
            this.saveDPVs(design.getLogicalDesign(), true);
            for (DesignPart designPart : design.getRelationalDesigns()) {
                this.saveDesignPartProperties(designPart);
                this.saveDPVs(designPart, true);
                for (StorageDesign stoDesign : ((RelationalDesign)designPart).getStorageDesignFactory().getSorageDesigns()) {
                    this.saveProperties(stoDesign);
                    Iterator storableObjects = stoDesign.getStorableObjects().iterator();
                    while (storableObjects.hasNext()) {
                        this.saveProperties((ModelIDObject)storableObjects.next());
                    }
                }
            }
            for (DesignPart designPart : design.getMultidimensionalDesigns()) {
                this.saveDesignPartProperties(designPart);
                this.saveDPVs(designPart, false);
            }
            this.saveDesignPartProperties(design.getProcessModel());
            for (DesignPart designPart : design.getProcessModel().getDataFlowDesigns()) {
                this.saveDesignPartProperties(designPart);
                this.saveDPVs(designPart, false);
            }
            for (DesignPart designPart : design.getProcessModel().getAllTransformationTasks()) {
                this.saveDesignPartProperties(designPart);
                this.saveDPVs(designPart, false);
            }
        }
    }

    public void saveDesignPartProperties(DesignPart designPart) {
        this.saveDesignPartProperties(designPart, false);
    }

    public void saveDesignPartProperties(DesignPart designPart, boolean skipChecks) {
        this.saveProperties((ModelIDObject)designPart, skipChecks);
        Iterator storableObjects = designPart.getStorableDesignObjects().iterator();
        while (storableObjects.hasNext()) {
            this.saveProperties((ModelIDObject)storableObjects.next(), skipChecks);
        }
    }

    public void saveDPVs(DesignPart designPart, boolean saveSubViews) {
        this.saveDPVs(designPart, saveSubViews, false);
    }

    public void saveDPVs(DesignPart designPart, boolean saveSubViews, boolean skipChecks) {
        this.saveProperties((ModelIDObject)designPart.getMainView().getPlaceHolder(), skipChecks);
        if (saveSubViews) {
            Iterator designSubviews = designPart.getDesignSubviews().iterator();
            while (designSubviews.hasNext()) {
                this.saveProperties((ModelIDObject)((DesignPartViewPlaceHolder)designSubviews.next()), skipChecks);
            }
        }
    }

    public void saveProperties(StorableObject storableObject) {
        String pathName;
        if (storableObject instanceof ModelIDObject) {
            this.saveProperties((ModelIDObject)storableObject);
        } else if (storableObject instanceof DesignPartView) {
            this.saveProperties(((DesignPartView)storableObject).getPlaceHolder());
        } else if (storableObject instanceof RMExtendedMap) {
            String pathName2 = storableObject.getStorageName();
            if (pathName2 != null) {
                File file;
                if (storableObject.getDesign().isCompressedDesign() && pathName2.endsWith(".xml")) {
                    pathName2 = pathName2 + "z";
                }
                if (!this.isVersioned(file = new File(pathName2))) {
                    this.doAdd(this.findFirstNotAddedParent(file));
                }
            }
        } else if (storableObject instanceof RMDeletedMap && (pathName = storableObject.getStorageName()) != null) {
            File file;
            if (storableObject.getDesign().isCompressedDesign() && pathName.endsWith(".xml")) {
                pathName = pathName + "z";
            }
            if (!this.isVersioned(file = new File(pathName))) {
                this.doAdd(this.findFirstNotAddedParent(file));
            }
        }
    }

    protected void saveProperties(ModelIDObject object) {
        this.saveProperties(object, false);
    }

    public void saveProperties(ModelIDObject object, boolean skipChecks) {
        if (object == null) {
            return;
        }
        if (object instanceof StorageObject && ((StorageObject)object).isNullInstance() && !((StorageObject)object).isStorableNullInstance()) {
            return;
        }
        String pathName = object instanceof DesignPartViewPlaceHolder ? object.getStorageName() : object.getSegmentedStorageName();
        this.saveProperties(object, pathName, skipChecks);
    }

    public void saveProperties(ModelIDObject object, String pathName) {
        this.saveProperties(object, pathName, false);
    }

    public void saveProperties(ModelIDObject object, String pathName, boolean skipChecks) {
        if (pathName != null) {
            if (object.getDesign().isCompressedDesign() && pathName.endsWith(".xml")) {
                pathName = pathName + "z";
            }
            File file = new File(pathName);
            if (!skipChecks && this.isVersioned(object.getDesign().getStoragePath()) && !this.isVersioned(file)) {
                this.doAdd(this.findFirstNotAddedParent(file));
            }
            if (object instanceof TransformationTask) {
                String parentID = ((TransformationTask)object).getTransformationPackage().getObjectID();
                String[] propertiesArray = new String[]{object.getObjectID(), object.getClass().getName(), parentID, null, null, object.getName()};
                if (this.isDmPropertiesChanged(object, propertiesArray, pathName)) {
                    this.setProperties(object, file, propertiesArray);
                }
            } else if (object instanceof DataFlowDesign) {
                String parentID = ((DataFlowDesign)object).getProcess() != null ? ((DataFlowDesign)object).getProcess().getObjectID() : ((DataFlowDesign)object).getProcessModel().getObjectID();
                String[] propertiesArray = new String[]{object.getObjectID(), object.getClass().getName(), parentID, null, null, object.getName()};
                if (this.isDmPropertiesChanged(object, propertiesArray, pathName)) {
                    this.setProperties(object, file, propertiesArray);
                }
            } else if (object instanceof DesignPartViewPlaceHolder) {
                DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)object;
                DesignPart dp = dpvph.getDesignPart();
                if (dp instanceof DataFlowDesign) {
                    String parentID = ((DataFlowDesign)dp).getObjectID();
                    String[] propertiesArray = new String[]{object.getObjectID(), dp.getClass().getName(), parentID, null, null, object.getName()};
                    if (this.isDmPropertiesChanged(object, propertiesArray, pathName)) {
                        this.setProperties(object, file, propertiesArray);
                    }
                } else {
                    String[] propertiesArray = new String[]{object.getObjectID(), dp.getClass().getName(), dp.getObjectID(), null, null, object.getName()};
                    if (this.isDmPropertiesChanged(object, propertiesArray, pathName)) {
                        this.setProperties(object, file, propertiesArray);
                    }
                }
            } else if (object instanceof DesignPart) {
                String[] propertiesArray = new String[]{object.getObjectID(), object.getClass().getName(), "", null, null, object.getName()};
                if (this.isDmPropertiesChanged(object, propertiesArray, pathName)) {
                    this.setProperties(object, file, propertiesArray);
                }
            } else if (object instanceof DesignObject) {
                String[] propertiesArray;
                String parentID = ((DesignObject)object).getDesignPartId();
                String sourceObjectID = null;
                String targetObjectID = null;
                if (object instanceof ConnectionInterface) {
                    ConnectionInterface connection = (ConnectionInterface)((Object)object);
                    DesignObject sourceObject = connection.getSourceObject();
                    DesignObject targetObject = connection.getTargetObject();
                    if (sourceObject != null) {
                        sourceObjectID = sourceObject.getObjectID();
                    }
                    if (targetObject != null) {
                        targetObjectID = targetObject.getObjectID();
                    }
                }
                if (this.isDmPropertiesChanged(object, propertiesArray = new String[]{object.getObjectID(), object.getClass().getName(), parentID, sourceObjectID, targetObjectID, object.getName()}, pathName)) {
                    this.setProperties(object, file, propertiesArray);
                }
            } else if (object instanceof StorageObject) {
                String parentID = ((StorageObject)object).getStorageDesign().getRDBMSSite().getShortObjectID();
                String[] propertiesArray = new String[]{object.getObjectID(), object.getClass().getName(), parentID, null, null, object.getName()};
                if (this.isDmPropertiesChanged(object, propertiesArray, pathName)) {
                    this.setProperties(object, file, propertiesArray);
                }
            } else if (object instanceof StorageDesign) {
                String parentID = ((StorageDesign)object).getPhysicalDesign().getShortObjectID();
                String[] propertiesArray = new String[]{((StorageDesign)object).getRDBMSSite().getShortObjectID(), object.getClass().getName(), parentID, null, null, object.getName()};
                if (this.isDmPropertiesChanged(object, propertiesArray, pathName)) {
                    this.setProperties(object, file, propertiesArray);
                }
            } else {
                String[] propertiesArray = new String[]{object.getObjectID(), object.getClass().getName(), "", null, null, object.getName()};
                if (this.isDmPropertiesChanged(object, propertiesArray, pathName)) {
                    this.setProperties(object, file, propertiesArray);
                }
            }
        } else {
            LOGGER.info("Not recognized: " + object.getName());
        }
    }

    public static String getProperties(ModelIDObject object) {
        String res = "";
        if (object instanceof TransformationTask) {
            String parentID = ((TransformationTask)object).getTransformationPackage().getObjectID();
            res = VCSClientHelper.generateProperty(new String[]{object.getObjectID(), object.getClass().getName(), parentID, null, null, object.getName()});
        } else if (object instanceof DataFlowDesign) {
            String parentID = ((DataFlowDesign)object).getProcess() != null ? ((DataFlowDesign)object).getProcess().getObjectID() : ((DataFlowDesign)object).getProcessModel().getObjectID();
            res = VCSClientHelper.generateProperty(new String[]{object.getObjectID(), object.getClass().getName(), parentID, null, null, object.getName()});
        } else if (object instanceof DesignPartViewPlaceHolder) {
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)object;
            DesignPart dp = dpvph.getDesignPart();
            if (dp instanceof DataFlowDesign) {
                String parentID = ((DataFlowDesign)dp).getObjectID();
                res = VCSClientHelper.generateProperty(new String[]{object.getObjectID(), dp.getClass().getName(), parentID, null, null, object.getName()});
            } else {
                res = VCSClientHelper.generateProperty(new String[]{object.getObjectID(), dp.getClass().getName(), dp.getObjectID(), null, null, object.getName()});
            }
        } else if (object instanceof DesignPart) {
            res = VCSClientHelper.generateProperty(new String[]{object.getObjectID(), object.getClass().getName(), "", null, null, object.getName()});
        } else if (object instanceof DesignObject) {
            String parentID = ((DesignObject)object).getDesignPartId();
            String sourceObjectID = null;
            String targetObjectID = null;
            if (object instanceof ConnectionInterface) {
                ConnectionInterface connection = (ConnectionInterface)((Object)object);
                DesignObject sourceObject = connection.getSourceObject();
                DesignObject targetObject = connection.getTargetObject();
                if (sourceObject != null) {
                    sourceObjectID = sourceObject.getObjectID();
                }
                if (targetObject != null) {
                    targetObjectID = targetObject.getObjectID();
                }
            }
            res = VCSClientHelper.generateProperty(new String[]{object.getObjectID(), object.getClass().getName(), parentID, sourceObjectID, targetObjectID, object.getName()});
        } else if (object instanceof StorageObject) {
            String parentID = ((StorageObject)object).getStorageDesign().getRDBMSSite().getShortObjectID();
            res = VCSClientHelper.generateProperty(new String[]{object.getObjectID(), object.getClass().getName(), parentID, null, null, object.getName()});
        } else if (object instanceof StorageDesign) {
            String parentID = ((StorageDesign)object).getPhysicalDesign().getShortObjectID();
            res = VCSClientHelper.generateProperty(new String[]{((StorageDesign)object).getRDBMSSite().getShortObjectID(), object.getClass().getName(), parentID, null, null, object.getName()});
        } else {
            res = VCSClientHelper.generateProperty(new String[]{object.getObjectID(), object.getClass().getName(), "", null, null, object.getName()});
        }
        return res;
    }

    public boolean actionsEnabled(DataModelerChangeList changeList, Context context, boolean checkContext, boolean checkSelection, boolean checkSingleSelection, boolean checkConflicts, boolean checkDependances, boolean checkDeletedForDependences, boolean checkNotExisting, boolean checkRootNode) {
        Design selectedDesign;
        List<StorableObjectStatus> statuses;
        if (changeList != null && ((statuses = changeList.getPanel().getStatuses()) == null || statuses.size() == 0)) {
            return false;
        }
        if (checkContext) {
            if (context != null) {
                View contextView = context.getView();
                DisplayableLocatableNode[] selection = VCSClientHelper.getSelection(contextView);
                if (!(selection != null && selection.length != 0 || contextView instanceof SVNViewPropertiesWindow)) {
                    return false;
                }
                if (DataModelerChangeListWindow.class.isAssignableFrom(contextView.getClass())) {
                    changeList = (DataModelerChangeList)((DataModelerChangeListWindow)context.getView()).getContextChangeList();
                } else {
                    if (contextView instanceof BrowserDockable) {
                        File selectedObjectFile = selection[0].getFilePath();
                        String selectedObjectFileName = selectedObjectFile.toString();
                        if (!selectedObjectFile.exists()) {
                            if (selectedObjectFileName.toLowerCase().endsWith(".xml")) {
                                selectedObjectFileName = selectedObjectFileName.substring(0, selectedObjectFileName.indexOf(".xml")) + ".xmlz";
                                selectedObjectFile = new File(selectedObjectFileName);
                                selection[0].setFilePath(selectedObjectFile);
                            } else if (selectedObjectFileName.toLowerCase().endsWith(".dmd")) {
                                selectedObjectFileName = selectedObjectFileName.substring(0, selectedObjectFileName.indexOf(".dmd")) + ".dmdz";
                                selectedObjectFile = new File(selectedObjectFileName);
                                selection[0].setFilePath(selectedObjectFile);
                            }
                        }
                        return selection[0].getFilePath().exists();
                    }
                    if (contextView instanceof DMDiagramEditor) {
                        DesignPartView designPartView = ((DMDiagramEditor)contextView).getDesignPartView();
                        File selectedObjectFile = selection[0].getFilePath();
                        String selectedObjectFileName = selectedObjectFile.toString();
                        if (designPartView.getDesign().isCompressedDesign()) {
                            if (selectedObjectFileName.toLowerCase().endsWith(".xml")) {
                                selectedObjectFileName = selectedObjectFileName.substring(0, selectedObjectFileName.indexOf(".xml")) + ".xmlz";
                                selectedObjectFile = new File(selectedObjectFileName);
                                selection[0].setFilePath(selectedObjectFile);
                            } else if (selectedObjectFileName.toLowerCase().endsWith(".dmd")) {
                                selectedObjectFileName = selectedObjectFileName.substring(0, selectedObjectFileName.indexOf(".dmd")) + ".dmdz";
                                selectedObjectFile = new File(selectedObjectFileName);
                                selection[0].setFilePath(selectedObjectFile);
                            }
                        }
                        return designPartView.getDesign().isVersioned() && selectedObjectFile.exists();
                    }
                    if (contextView instanceof SVNHistoryWindow) {
                        StorableObjectStatus storableObjectStatus = ((SVNHistoryWindow)contextView).getSelectedStorableObjectStatus();
                        File filePath = selection[0].getFilePath();
                        URL url = selection[0].getURL();
                        return (filePath != null || url != null) && !storableObjectStatus.isDeleted();
                    }
                    if (contextView instanceof SVNViewPropertiesWindow && ((SVNViewPropertiesWindow)contextView).isReadOnly()) {
                        return false;
                    }
                }
            } else {
                return false;
            }
        }
        if ((selectedDesign = DataModelerChangeList.getSelectedDesign()) != null && selectedDesign.isVersioned()) {
            ArrayList<VersioningTreeNode> treeNodesForRefreshing = new ArrayList<VersioningTreeNode>();
            if (checkRootNode && changeList != null && this.containsRootPath(changeList.getPanel().getSelectedFilePaths(treeNodesForRefreshing, true, true))) {
                return false;
            }
            if (checkSelection && changeList != null && !changeList.getPanel().hasSelection()) {
                return false;
            }
            if (checkSingleSelection && changeList != null && !changeList.getPanel().hasSingleSelection()) {
                return false;
            }
            if (checkConflicts && this.containsConflicted(treeNodesForRefreshing)) {
                return false;
            }
            if (checkDependances && !this.containsAllDependances(treeNodesForRefreshing, checkDeletedForDependences)) {
                return false;
            }
            return !checkNotExisting || !this.containsNotExisting(treeNodesForRefreshing);
        }
        return false;
    }

    public boolean containsAllDependances(List<VersioningTreeNode> treeNodes, boolean checkDeletedForDependences) {
        for (VersioningTreeNode treeNode : treeNodes) {
            VersioningTreeNode dependingOn;
            StorableObjectStatus status;
            if (!checkDeletedForDependences && (status = treeNode.getStorableObjectStatus()) != null && status.isDeleted() || (dependingOn = treeNode.getDependingOn()) == null || treeNodes.contains(dependingOn)) continue;
            return false;
        }
        return true;
    }

    public boolean containsConflicted(List<VersioningTreeNode> treeNodes) {
        for (VersioningTreeNode treeNode : treeNodes) {
            if (!treeNode.isConflicted()) continue;
            return true;
        }
        return false;
    }

    public boolean containsNotExisting(List<VersioningTreeNode> treeNodes) {
        for (VersioningTreeNode treeNode : treeNodes) {
            StorableObjectStatus objectStatus = treeNode.getStorableObjectStatus();
            if (objectStatus != null && !objectStatus.isAdded() && !objectStatus.isDeleted()) continue;
            return true;
        }
        return false;
    }

    public boolean containsRootPath(List<File> selectedFilePaths) {
        String designPath = DataModelerChangeList.getSelectedDesign().getDesignPath();
        for (File filePath : selectedFilePaths) {
            if (!filePath.getPath().equals(designPath)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRootNode(List<VersioningTreeNode> treeNodes) {
        for (VersioningTreeNode treeNode : treeNodes) {
            if (!treeNode.isRoot()) continue;
            return true;
        }
        return false;
    }

    public File findFirstNotAddedParent(File notAddedFile) {
        File parent = notAddedFile.getParentFile();
        if (!this.isVersioned(parent)) {
            return this.findFirstNotAddedParent(parent);
        }
        return notAddedFile;
    }

    public List<File> findNotAddedParents(File notAddedFile, List<File> notAddedParents) {
        File parent = notAddedFile.getParentFile();
        if (parent != null && !this.isVersioned(parent)) {
            notAddedParents.add(parent);
            return this.findNotAddedParents(parent, notAddedParents);
        }
        return notAddedParents;
    }

    public static boolean accept(File file) {
        String fileName = file.getName();
        return fileName.endsWith(".xml") || fileName.endsWith(".xmlz") || fileName.endsWith(".dmd") || fileName.endsWith(".udposdm") || fileName.endsWith(".dmdz");
    }

    public static boolean acceptFile(File file) {
        String fileName = file.getName();
        return !file.isDirectory() && !fileName.endsWith(".local") && !fileName.endsWith(".localz");
    }

    public void merge(StorableObjectStatus storableObjectStatus, File localFile, Map mergedMap) {
        Class<DesignLevelSettings> objectClass;
        DesignPart designPart;
        boolean compressedDesign;
        StorableObject storableObject = storableObjectStatus.getStorableObject();
        if (storableObjectStatus.getTextStatus() == null) {
            compressedDesign = storableObject.getDesign().isCompressedDesign();
            designPart = ((DesignObject)storableObject).getDesignPart();
            objectClass = storableObject.getClass();
        } else {
            compressedDesign = storableObjectStatus.getDesign().isCompressedDesign();
            designPart = storableObjectStatus.getDesignPart();
            objectClass = storableObjectStatus.getObjectClass();
        }
        if (objectClass != null && objectClass.isAssignableFrom(DesignLevelSettings.class)) {
            storableObjectStatus.getDesign().getDesignLevelSettings().loadDesignLevelSettingsFile(storableObjectStatus.getDesign().getStoragePath());
        } else {
            if (compressedDesign) {
                XMLFromMapTransformer.transformMapToXMLFile(mergedMap, localFile.getPath(), compressedDesign);
            } else {
                XMLFromMapToSteramTransformer.transformMapToXMLFileStram(mergedMap, localFile.getPath());
            }
            if (storableObject != null) {
                this.reloadStorableObject(storableObject, localFile, designPart);
            }
        }
    }

    public void reloadStorableObject(StorableObject storableObject, File file, DesignPart designPart) {
        DesignPartView dpv;
        XMLTransformationManager xmlTransformationManager = ApplicationView.getInstance().getXMLTransformationManager();
        Design design = storableObject.getDesign();
        xmlTransformationManager.transformFromXMLToObject(storableObject, file, design.isCompressedDesign());
        if (designPart != null) {
            designPart.executeTasks();
        }
        if (storableObject instanceof DesignPartView && (dpv = (DesignPartView)storableObject).isVisible()) {
            dpv.setVisible(true);
            for (DesignPartView sdpv : dpv.getSubordinateViews()) {
                sdpv.setVisible(true);
            }
        }
    }

    public StorageDesign findStorageDesign(Design design, String storableObjectID) {
        for (StorageDesign storageDesign : design.getStorageDesignFactory().getOpenStorageDesigns()) {
            if (storageDesign.getStorageObject(storableObjectID) == null) continue;
            return storageDesign;
        }
        return null;
    }

    protected String getProperty(String svnProperties, int propertyIndex) {
        if (svnProperties != null) {
            String[] svnPropertiesSplitted = svnProperties.split(DM_PROPERTIES_SEPARATOR, svnProperties.length());
            if (svnPropertiesSplitted.length == 4 && propertyIndex == 5) {
                propertyIndex = 3;
            }
            if (svnPropertiesSplitted.length > propertyIndex) {
                return svnPropertiesSplitted[propertyIndex];
            }
        }
        return null;
    }

    public static String generateProperty(String[] properties) {
        StringBuilder result = new StringBuilder();
        String propertyId = properties[0];
        String propertyClassName = properties[1];
        String propertyParentId = properties[2];
        String propertySourceId = properties[3];
        String propertyTargetId = properties[4];
        String propertyName = properties[5];
        if (StringUtilities.isNotEmpty(propertyId)) {
            result.append(propertyId);
        }
        result.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(propertyClassName)) {
            result.append(propertyClassName);
        }
        result.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(propertyParentId)) {
            result.append(propertyParentId);
        }
        result.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(propertySourceId)) {
            result.append(propertySourceId);
        }
        result.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(propertyTargetId)) {
            result.append(propertyTargetId);
        }
        result.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(propertyName)) {
            result.append(propertyName);
        }
        return result.toString();
    }

    private void setProperties(ModelIDObject object, File file, String[] properties) {
        String objectDMProperties = VCSClientHelper.generateProperty(properties);
        if (this.isVersioned(file)) {
            this.doSetProperty(file, DM_PROPERTIES, objectDMProperties);
        }
        if (object != null && object.getDesign() != null) {
            try {
                Design.SVNStatusAndPropertiesPair svnStatusAndPropertiesPair = object.getDesign().getSVNPropertiesCache().get(new SVNUrl("file://" + file.toString()));
                if (svnStatusAndPropertiesPair != null) {
                    svnStatusAndPropertiesPair.svnProperties = objectDMProperties;
                }
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.getStackTrace()[0].toString());
            }
        }
    }

    public static Icon getIcon(Class objectClass) {
        if (objectClass != null && File.class.isAssignableFrom(objectClass)) {
            return NavigationTreeRenderer.getDefaultIcon();
        }
        Icon icon = NavigationTreeRenderer.getIcon(objectClass);
        if (icon == null && objectClass != null && (StorageObject.class.isAssignableFrom(objectClass) || RelationalObjectProxy.class.isAssignableFrom(objectClass))) {
            icon = NavigationTreeRenderer.getIcon(StorageObject.class);
        }
        return icon;
    }

    public static boolean replace(File file, String replacementFileExtension) {
        File replacementFile = new File(file.getPath() + replacementFileExtension);
        if (!replacementFile.exists()) {
            return false;
        }
        if (file.canWrite()) {
            file.delete();
        } else {
            LOGGER.info("File " + file.getPath() + " can not be deleted!");
        }
        return replacementFile.renameTo(file);
    }

    public static boolean copyOverConflicted(File conflicted, String replacementFileExtension) {
        File source = new File(conflicted.getPath() + replacementFileExtension);
        if (source.exists()) {
            try {
                Files.copy(source.toPath(), conflicted.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.info("File " + source.getPath() + " \ncan not be copied over \n" + conflicted.getPath() + "\n", e);
            }
        }
        return false;
    }

    public static CommandState createCommandState(View contextView) {
        return VCSClientHelper.createCommandState(contextView, false);
    }

    public static CommandState createCommandState(View contextView, boolean expandSelection) {
        return VCSClientHelper.createCommandState(contextView, expandSelection, false);
    }

    public static CommandState createCommandState(View contextView, boolean expandSelection, boolean allowMultiSelect) {
        CommandState commandState = new CommandState();
        Locatable[] selection = VCSClientHelper.getSelection(contextView, allowMultiSelect);
        if (selection == null) {
            commandState.setLocatables((Locatable[])new DisplayableLocatableNode[0]);
            return commandState;
        }
        if (expandSelection) {
            ArrayList<DisplayableLocatableNode> extendedSelection = new ArrayList<DisplayableLocatableNode>();
            for (Locatable node : selection) {
                StorableObject storableObject = node.getStorableObject();
                extendedSelection.add((DisplayableLocatableNode)node);
                if (storableObject == null) continue;
                if (storableObject instanceof DesignPart) {
                    DesignPart designPart = (DesignPart)storableObject;
                    for (DesignObject designObject : designPart.getStorableDesignObjects()) {
                        extendedSelection.add(new DisplayableLocatableNode(designObject));
                    }
                    for (DesignPartView designPartView : designPart.getAllDiagrams()) {
                        extendedSelection.add(new DisplayableLocatableNode(designPartView));
                    }
                }
                if (storableObject instanceof DesignPartView) {
                    VCSClientHelper.addDesignPartView((DesignPartView)storableObject, extendedSelection);
                    continue;
                }
                if (!(storableObject instanceof DesignPartViewPlaceHolder)) continue;
                VCSClientHelper.addDesignPartView(((DesignPartViewPlaceHolder)storableObject).getDesignPartView(), extendedSelection);
            }
            selection = extendedSelection.toArray(new DisplayableLocatableNode[0]);
        }
        commandState.setLocatables(selection);
        return commandState;
    }

    private static void addDesignPartView(DesignPartView designPartView, List<DisplayableLocatableNode> nodes) {
        List tvArcs = designPartView.getTVArcs();
        List tvShapes = designPartView.getTVShapes();
        List tvConnectors = designPartView.getTVConnectors();
        for (TopView topView : tvArcs) {
            nodes.add(new DisplayableLocatableNode(topView.getModel()));
        }
        for (TopView topView : tvShapes) {
            nodes.add(new DisplayableLocatableNode(topView.getModel()));
        }
        for (TopView topView : tvConnectors) {
            nodes.add(new DisplayableLocatableNode(topView.getModel()));
        }
    }

    public static DisplayableLocatableNode[] getSelection(View contextView) {
        return VCSClientHelper.getSelection(contextView, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DisplayableLocatableNode[] getSelection(View contextView, boolean allowMultiSelect) {
        StorableObjectStatus storableObjectStatus;
        if (contextView instanceof DataModelerChangeListWindow) {
            DataModelerChangeList dataModelerChangeList = (DataModelerChangeList)((DataModelerChangeListWindow)contextView).getContextChangeList();
            List<File> filePaths = dataModelerChangeList.getPanel().getSelectedFilePaths(new ArrayList<VersioningTreeNode>(), false, false);
            File[] filePathsArray = filePaths.toArray(new File[filePaths.size()]);
            return DisplayableLocatableNode.convert(filePathsArray);
        }
        if (contextView instanceof BrowserDockable) {
            Object pathComponent = ((BrowserPanel)((BrowserDockable)contextView).getBrowser()).getJTree().getLastSelectedPathComponent();
            if (pathComponent instanceof DesignObjectPlaceHolder) {
                pathComponent = ((DesignObjectPlaceHolder)pathComponent).getObject();
            }
            if (pathComponent instanceof ModelIDObject && ((ModelIDObject)pathComponent).getDesign().isVersioned() && pathComponent instanceof StorableObject && ((StorableObject)pathComponent).getStorageName() != null) {
                return new DisplayableLocatableNode[]{new DisplayableLocatableNode((StorableObject)pathComponent)};
            }
            if (!(pathComponent instanceof Domain) || !SVNClientHelper.getInstance().isVersioned(((Domain)pathComponent).getDesign().getAppView().getSettings().getDefaultSystemTypesPath()) || !(pathComponent instanceof StorableObject) || ((StorableObject)pathComponent).getStorageName() == null) return null;
            return new DisplayableLocatableNode[]{new DisplayableLocatableNode((StorableObject)pathComponent)};
        }
        if (contextView instanceof DMDiagramEditor) {
            Object[] selectedObjects = ((DMDiagramEditor)contextView).getDesignPartView().getSelectedObjects();
            if (selectedObjects != null && selectedObjects.length > 0) {
                if (selectedObjects.length == 1 || !allowMultiSelect) {
                    return new DisplayableLocatableNode[]{new DisplayableLocatableNode((StorableObject)selectedObjects[0])};
                }
                if (!allowMultiSelect) return null;
                DisplayableLocatableNode[] arr = new DisplayableLocatableNode[selectedObjects.length];
                for (int i = 0; i < selectedObjects.length; ++i) {
                    arr[i] = new DisplayableLocatableNode((StorableObject)selectedObjects[i]);
                }
                return arr;
            }
            DesignPartView designPartView = ((DMDiagramEditor)contextView).getDesignPartView();
            if (designPartView.isMasterDPV()) return new DisplayableLocatableNode[]{new DisplayableLocatableNode(designPartView)};
            designPartView = designPartView.getMasterDPV();
            return new DisplayableLocatableNode[]{new DisplayableLocatableNode(designPartView)};
        }
        if (contextView instanceof SVNViewPropertiesWindow) {
            File[] filePaths = ((SVNViewPropertiesWindow)contextView).getContextResources();
            return DisplayableLocatableNode.convert(filePaths);
        }
        if (!(contextView instanceof SVNHistoryWindow) || (storableObjectStatus = ((SVNHistoryWindow)contextView).getSelectedStorableObjectStatus()) == null) return null;
        if (contextView instanceof SVNMergeWindow) {
            return new DisplayableLocatableNode[]{new DisplayableLocatableNode(storableObjectStatus.getURL())};
        }
        StorableObject storableObject = storableObjectStatus.getStorableObject();
        if (storableObject == null) return new DisplayableLocatableNode[]{new DisplayableLocatableNode(storableObjectStatus.getFilePath())};
        return new DisplayableLocatableNode[]{new DisplayableLocatableNode(storableObject)};
    }

    public static Design getSelectionDesign(View contextView) {
        try {
            if (contextView instanceof DataModelerChangeListWindow) {
                return DataModelerChangeList.getSelectedDesign();
            }
            if (contextView instanceof BrowserDockable) {
                Object obj = ((BrowserPanel)((BrowserDockable)contextView).getBrowser()).getJTree().getLastSelectedPathComponent();
                if (obj instanceof StorableObject) {
                    return ((StorableObject)obj).getDesign();
                }
                if (obj instanceof ModelObject) {
                    return ((ModelObject)obj).getDesign();
                }
            } else {
                if (contextView instanceof DMDiagramEditor) {
                    if (((DMDiagramEditor)contextView).getDesignPartView() != null) {
                        return ((DMDiagramEditor)contextView).getDesignPartView().getDesign();
                    }
                    return null;
                }
                if (contextView instanceof SVNViewPropertiesWindow) {
                    return ((SVNViewPropertiesWindow)contextView).getDesign();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isDataModelerContextView(Context context) {
        if (context != null) {
            View contextView = context.getView();
            if (contextView instanceof DataModelerChangeListWindow) {
                return true;
            }
            if (contextView instanceof BrowserDockable) {
                return true;
            }
            if (contextView instanceof DMDiagramEditor) {
                return true;
            }
            if (contextView instanceof SVNViewPropertiesWindow) {
                return true;
            }
        }
        return false;
    }

    private void deleteLocalFilesAndSetIgnoreList(String filePath) {
        File dir = new File(filePath);
        LocalFileFilter fileFilterLocalz = new LocalFileFilter(".localz");
        LocalFileFilter fileFilterLocal = new LocalFileFilter(".local");
        this.doIgnore(dir, "*.localz");
        this.doIgnore(dir, "*.local");
        File[] files = dir.listFiles();
        if (files.length != 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (files[i].getName().equals(SUBVERSION_EXTRA_FOLDER_NAME)) continue;
                    try {
                        this.deleteLocalFilesAndSetIgnoreList(files[i].getCanonicalFile().toString());
                    }
                    catch (IOException e) {
                        ApplicationView.log("Unable to delete local file in " + files[i].getName() + " folder");
                        LOGGER.error(e.getStackTrace()[0].toString());
                    }
                    continue;
                }
                if (!fileFilterLocalz.accept(files[i]) && !fileFilterLocal.accept(files[i]) || !this.isVersioned(files[i])) continue;
                this.doRemove(new File[]{files[i]});
            }
        }
    }

    private boolean isDmPropertiesChanged(ModelIDObject object, String[] propertiesArray, String pathName) {
        if (pathName != null && pathName.length() > 0) {
            Design.SVNStatusAndPropertiesPair svnStatusAndPropertiesPair = null;
            try {
                String dmProperties;
                svnStatusAndPropertiesPair = object.getDesign().getSVNPropertiesCache().get(new SVNUrl("file://" + pathName));
                if (svnStatusAndPropertiesPair != null && (dmProperties = svnStatusAndPropertiesPair.svnProperties) != null) {
                    for (int i = 0; i <= 5; ++i) {
                        String propertiesComponentValue;
                        if (propertiesArray[i] == null || (propertiesComponentValue = this.getProperty(dmProperties, i)).compareTo(propertiesArray[i]) == 0) continue;
                        return true;
                    }
                    return false;
                }
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.getStackTrace()[0].toString());
                return true;
            }
        }
        return true;
    }
}

