/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JPanel;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.EditableContributor;
import oracle.javatools.compare.view.text.TextCompareView;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.editor.plugins.StatusBarPlugin;
import oracle.jdeveloper.compare.CompareConstants;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.merge.TextMergeContributor;
import oracle.jdeveloper.merge.TextMergeNode;
import oracle.jdevimpl.compare.BaseCompareEditor;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareUtil;

public class TextCompareEditor
extends BaseCompareEditor {
    private JPanel gui;
    private CompareView compareView;
    private CompareController compareController;
    private static final Logger LOGGER = new Logger(TextCompareEditor.class);
    private XMLContributor leftContributor;
    private XMLContributor rightContributor;

    public TextCompareEditor(InputStream leftText, InputStream rightText, String leftTextTitle, String rightTextTitle, boolean leftTextReadOnly, boolean rightTextReadOnly) {
        this(new InputStreamReader(leftText), new InputStreamReader(rightText), leftTextTitle, rightTextTitle, leftTextReadOnly, rightTextReadOnly);
    }

    public TextCompareEditor(Reader leftTextReader, Reader rightTextReader, String leftTextTitle, String rightTextTitle, boolean leftTextReadOnly, boolean rightTextReadOnly) {
        try {
            BasicEditorPane[] editorPanes;
            this.compareView = this.createCompareView(leftTextReader, rightTextReader, leftTextTitle, rightTextTitle, leftTextReadOnly, rightTextReadOnly);
            for (BasicEditorPane editorPane : editorPanes = ((TextCompareView)this.compareView).getEditorPanes()) {
                editorPane.putBooleanProperty("show-line-numbers", true);
                editorPane.installPlugin((EditorPlugin)new BraceMatchingPlugin());
                FindHighlightPlugin findPlugin = new FindHighlightPlugin();
                editorPane.installPlugin((EditorPlugin)findPlugin);
                StatusBarPlugin statusBar = new StatusBarPlugin(editorPane.getFont());
                editorPane.installPlugin((EditorPlugin)statusBar);
                editorPane.putProperty("finder", (Object)findPlugin);
                editorPane.putBooleanProperty("brace-matching-auto", true);
                editorPane.putBooleanProperty("code-folding-enabled", true);
                editorPane.putBooleanProperty("use-auto-indent", true);
                editorPane.putBooleanProperty("use-smart-indent", true);
                editorPane.putBooleanProperty("merge-navigation", true);
            }
            this.compareController = this.createCompareController();
            this.gui = (JPanel)this.getGUI();
            this.gui.add((Component)this.createToolbar(), "North");
            this.gui.add(this.compareView.getGUI(), "Center");
        }
        catch (IOException e) {
            LOGGER.error(e);
        }
        catch (CompareFailedException e) {
            LOGGER.error((Object)e);
        }
    }

    public String getLeftText() {
        TextBuffer buffer = this.leftContributor.getTextBuffer();
        return buffer.getString(0, buffer.getLength());
    }

    public String getRightText() {
        TextBuffer buffer = this.rightContributor.getTextBuffer();
        return buffer.getString(0, buffer.getLength());
    }

    private CompareController createCompareController() {
        final Context compareContext = Context.newIdeContext((View)this);
        return new CompareController(){

            protected CompareView getCompareView(Context context) {
                return super.getCompareView(compareContext);
            }

            public boolean update(IdeAction action, Context context) {
                return super.update(action, compareContext);
            }

            public boolean handleEvent(IdeAction action, Context context) {
                return super.handleEvent(action, compareContext);
            }
        };
    }

    public CompareView getCompareView() {
        return this.compareView;
    }

    public void open() {
    }

    private Toolbar createToolbar() {
        Toolbar toolbar = new Toolbar();
        toolbar.add((ToggleAction)this._createLocalAction(CompareConstants.GO_FIRST_CMD_ID));
        toolbar.add((ToggleAction)this._createLocalAction(CompareConstants.GO_PREVIOUS_CMD_ID));
        toolbar.add((ToggleAction)this._createLocalAction(CompareConstants.GO_NEXT_CMD_ID));
        toolbar.add((ToggleAction)this._createLocalAction(CompareConstants.GO_LAST_CMD_ID));
        return toolbar;
    }

    protected IdeAction _createLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction localAction = ideAction.newLocalAction((View)this);
            localAction.addController((Controller)this.compareController);
            localAction.setEnabled(true);
            return localAction;
        }
        return null;
    }

    private CompareView createCompareView(Reader leftTextReader, Reader rightTextReader, String leftTextTitle, String rightTextTitle, boolean leftTextReadOnly, boolean rightTextReadOnly) throws IOException, CompareFailedException {
        this.leftContributor = new XMLContributor(leftTextReader, leftTextReadOnly, leftTextTitle);
        this.rightContributor = new XMLContributor(rightTextReader, rightTextReadOnly, rightTextTitle);
        TextMergeNode contextNode = new TextMergeNode(URLFactory.newFileURL((String)rightTextTitle));
        CompareInvocation invocationContext = CompareUtil.createInvocationContext((Element)contextNode, (CompareContributor)this.leftContributor, (CompareContributor)this.rightContributor, (StreamType)StreamType.XML);
        CompareModel compareModel = CompareUtil.createCompareModel((CompareContributor)this.leftContributor, (CompareContributor)this.rightContributor, (CompareInvocation)invocationContext);
        return CompareViewFactory.createCompareView((CompareModel)compareModel);
    }

    public void update(Object o, UpdateMessage updateMessage) {
    }

    protected Controller getControllerImpl() {
        return null;
    }

    private static final class XMLContributor
    extends TextMergeContributor
    implements EditableContributor {
        private boolean readOnly;

        private XMLContributor(Reader reader, boolean readOnly, String title) throws IOException {
            super(TextBufferFactory.createTextBuffer(), "xml", title);
            this.readOnly = readOnly;
            this.getTextBuffer().setReadOnly(readOnly);
            this.getTextBuffer().read(reader);
        }

        public boolean isEditable() {
            return !this.readOnly;
        }

        public String getType() {
            return "xml";
        }

        public boolean isModified() {
            return this.getTextBuffer().isModified();
        }
    }
}

