/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.File;
import java.util.List;
import java.util.TimerTask;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNIncomingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public abstract class DataModelerChangesTimerTask
extends TimerTask {
    protected DataModelerChangeList changeList;
    protected boolean containsConflicts = false;
    private static int numberOfRuns = 0;
    private static final Logger LOGGER = new Logger(DataModelerChangesTimerTask.class);
    private static int getStatusesCallNumber = 0;
    private static long lastCallStartTime = System.nanoTime();
    protected static List<StorableObjectStatus> storableObjectStatuses = null;
    protected static boolean updateSecondDependantChangeList = false;
    protected static List<StorableObjectStatus> originalStatuses = null;

    public DataModelerChangesTimerTask(DataModelerChangeList changeList) {
        this.changeList = changeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            block20: {
                if (this.changeList == null) break block20;
                DataModelerChangesTimerTask dataModelerChangesTimerTask = this;
                if (dataModelerChangesTimerTask.changeList.getSelectedDesign() != null && this.changeList.getDataModelerChangesTimerTaskUpdatable()) break block21;
            }
            if (this.changeList instanceof SVNIncomingChangesChangeList) {
                this.changeList.setDataModelerChangesTimerTaskUpdatable(true);
                ++numberOfRuns;
            }
            this.cancel();
            return;
        }
        ++numberOfRuns;
        int pp = 0;
        while (SVNClientInteraction.getInstance().isClientInUse()) {
            try {
                Thread.sleep(2500L);
                if (++pp <= 8) continue;
                break;
            }
            catch (InterruptedException e) {
                LOGGER.error(e);
            }
        }
        SVNChangeListWindow.getSVNOutgoingChangesChangeList().setBusy(false);
        SVNChangeListWindow.getSVNIncomingChangesChangeList().setBusy(false);
        SVNChangeListWindow.getSVNUnversionedFilesChangeList().setBusy(false);
        List<StorableObjectStatus> statuses = null;
        if (this.changeList instanceof SVNOutgoingChangesChangeList && DataModelerChangeList.getSelectedDesign().getStorableObjectStatuses() != null) {
            this.updateUI(DataModelerChangeList.getSelectedDesign().getStorableObjectStatuses());
        } else {
            this.changeList.setBusy(true);
            try {
                SVNClientHelper.getInstance().createSVNClientManagerInstance();
                statuses = this.findChanges(false);
                TimeLog.log("Start updateUI with statuses");
                this.updateUI(statuses);
                TimeLog.log("end  updateUI with statuses");
                if (this.changeList instanceof SVNOutgoingChangesChangeList) {
                    DataModelerChangeList.getSelectedDesign().setStorableObjectStatuses(statuses);
                }
            }
            catch (Exception e) {
                LOGGER.error(e);
                e.printStackTrace();
            }
            finally {
                this.changeList.setBusy(false);
                SVNClientHelper.getInstance().disposeSVNClientManagerInstance();
            }
        }
        TimeLog.log("Start refresh DependantChangeList");
        if (this.changeList.isAutoRefreshDependantChangeList() && this.changeList.getDependantChangeList() != null) {
            this.changeList.getDependantChangeList().refresh();
        }
        TimeLog.log("end refresh DependantChangeList");
        if (this.changeList.isAutoRefreshSecondDependantChangeList() && this.changeList.getSecondDependantChangeList() != null) {
            updateSecondDependantChangeList = true;
            originalStatuses = statuses;
            this.changeList.getSecondDependantChangeList().refresh();
        }
        TimeLog.log("Start refresh second DependantChangeList");
    }

    public void updateUI(List<StorableObjectStatus> statuses) {
        DataModelerChangeList dependantChangeList;
        if (updateSecondDependantChangeList) {
            statuses = originalStatuses;
        }
        if (statuses != null && (dependantChangeList = this.changeList.getDependantChangeList()) != null) {
            IChangeListPanel dependantChangeListPanel = dependantChangeList.getPanel();
            TimeLog.log("start  markConflictedStatuses");
            if (this.markConflictedStatuses(statuses, dependantChangeListPanel.getStatuses())) {
                TimeLog.log("end  markConflictedStatuses");
                dependantChangeListPanel.update();
            }
            TimeLog.log("end  markConflictedStatuses +dependantChangeListPanel.update()");
        }
        TimeLog.log("start ");
        this.changeList.updateUI(statuses);
        if (updateSecondDependantChangeList) {
            updateSecondDependantChangeList = false;
        }
        TimeLog.log("end  changeList.updateUI");
    }

    protected boolean markConflictedStatuses(List<StorableObjectStatus> statuses, List<StorableObjectStatus> dependantStatuses) {
        this.containsConflicts = false;
        if (statuses != null && dependantStatuses != null && !statuses.isEmpty() && !dependantStatuses.isEmpty()) {
            for (StorableObjectStatus status : statuses) {
                StorableObjectStatus sameFileStatus;
                if (this.isNormalStatus(status) || (sameFileStatus = this.findStatusForFile(status.getFilePath(), dependantStatuses)) == null || this.isNormalStatus(sameFileStatus)) continue;
                status.setInconflict(true);
                sameFileStatus.setInconflict(true);
                this.containsConflicts = true;
            }
        }
        return this.containsConflicts;
    }

    private boolean isNormalStatus(StorableObjectStatus status) {
        return status.getTextStatus().equals(" ") || status.getTextStatus().equals("");
    }

    protected StorableObjectStatus findStatusForFile(File file, List<StorableObjectStatus> statuses) {
        for (StorableObjectStatus status : statuses) {
            if (!status.getFilePath().equals(file) || status.getTextStatus().equals(SVNStatusKind.NORMAL)) continue;
            return status;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<StorableObjectStatus> findChanges(boolean versionedOnly) {
        if (getStatusesCallNumber > 1) {
            long timeBetweenCalls = System.nanoTime() - lastCallStartTime;
            lastCallStartTime = System.nanoTime();
        } else {
            lastCallStartTime = System.nanoTime();
        }
        Design design = DataModelerChangeList.getSelectedDesign();
        if (design != null) {
            if (!design.isNewDesign() || design.isVersioned()) {
                String designFilePath = design.getDesignPath();
                if (!StringUtilities.isNotEmpty(designFilePath)) return null;
                storableObjectStatuses = this.changeList instanceof SVNOutgoingChangesChangeList ? this.getVCSClientHelper().getStatuses(design, this.checkRemoteStatus(), false, versionedOnly) : this.getVCSClientHelper().getStatuses(design, this.checkRemoteStatus(), this.acceptAll(), versionedOnly);
                ++getStatusesCallNumber;
                return storableObjectStatuses;
            }
            if (!this.getVCSClientHelper().isVersioned(design.getAppView().getSettings().getDefaultSystemTypesPath())) return null;
            storableObjectStatuses = this.getVCSClientHelper().getStatuses(design, this.checkRemoteStatus(), this.acceptAll(), versionedOnly);
            ++getStatusesCallNumber;
            return storableObjectStatuses;
        }
        if (!SVNClientHelper.getInstance().isVersioned(ApplicationView.getInstance().getSettings().getDefaultSystemTypesPath()) || (design = ApplicationView.getInstance().getCurrentDesign()) == null) return null;
        storableObjectStatuses = this.getVCSClientHelper().getStatuses(design, this.checkRemoteStatus(), this.acceptAll(), versionedOnly);
        ++getStatusesCallNumber;
        return storableObjectStatuses;
    }

    protected abstract VCSClientHelper getVCSClientHelper();

    protected abstract boolean checkRemoteStatus();

    protected boolean acceptAll() {
        return false;
    }

    public boolean containsConflicts() {
        return this.containsConflicts;
    }
}

