/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class ReportsPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_REPORTSPP";
    private static final String DRP = "def_reports_path";
    private static final String DSAXP = "def_saxon_path";
    private static final String CN = "company_name";
    private static final String PB = "use_page_breaks";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected ReportsPreferences(HashStructure hash) {
        super(hash);
    }

    public static ReportsPreferences getInstance(PropertyStorage prefs) {
        return new ReportsPreferences(ReportsPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public String getDefaultReportsPath() {
        return this._hash.getString(DRP);
    }

    public void setDefaultReportsPath(String defaultReportsPath) {
        this._hash.putString(DRP, defaultReportsPath);
    }

    public String getDefaultSaxonPath() {
        return this._hash.getString(DSAXP);
    }

    public void setDefaultSaxonPath(String defaultSaxonPath) {
        this._hash.putString(DSAXP, defaultSaxonPath);
    }

    public String getCompanyName() {
        return this._hash.getString(CN);
    }

    public void setCompanyName(String companyName) {
        this._hash.putString(CN, companyName);
    }

    public boolean isUsePageBreaks() {
        return this._hash.getBoolean(PB);
    }

    public void setUsePageBreaks(boolean value) {
        this._hash.putBoolean(PB, value);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(CN)) {
            settings.setReportsCompanyName(this.getCompanyName());
        }
        if (this.contains(PB)) {
            settings.setUsePageBreaksInReports(this.isUsePageBreaks());
        }
        if (this.contains(DRP)) {
            settings.setDefaultReportsPath(this.getDefaultReportsPath());
        }
        if (this.contains(DSAXP)) {
            settings.setDefaultSaxonPath(this.getDefaultSaxonPath());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setCompanyName(settings.getReportsCompanyName());
        this.setUsePageBreaks(settings.isUsePageBreaksInReports());
        this.setDefaultReportsPath(settings.getDefaultReportsPath());
        this.setDefaultSaxonPath(settings.getDefaultSaxonPath());
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

