/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelSynchronizationPhysicalOraclePreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelSynchronizationPhysicalPP";
    private static final String ST = "synchronization_types";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelSynchronizationPhysicalOraclePreferences(HashStructure hash) {
        super(hash);
    }

    public static ModelSynchronizationPhysicalOraclePreferences getInstance(PropertyStorage prefs) {
        return new ModelSynchronizationPhysicalOraclePreferences(ModelSynchronizationPhysicalOraclePreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public HashStructure getSynchronizationTypes() {
        return this._hash.getHashStructure(ST);
    }

    public void rebuildHashStructure(Settings settings) {
        int counter = 0;
        Iterator it = settings.getSyncObjects().iterator();
        HashStructure hsBasic = HashStructure.newInstance();
        while (it.hasNext()) {
            ++counter;
            SyncObject sync = (SyncObject)it.next();
            HashStructure hs = HashStructure.newInstance();
            hs.putString("db", sync.getDatabase());
            hs.putString("name", sync.getType());
            hs.putBoolean("used", sync.isUsed());
            hsBasic.putHashStructure(Integer.toString(counter), hs);
        }
        this._hash.putHashStructure(ST, hsBasic);
    }

    public boolean isImportPartitions() {
        return this._hash.getBoolean("import_partitions");
    }

    public void setImportPartitions(boolean importPartitions) {
        this._hash.putBoolean("import_partitions", importPartitions);
    }

    public boolean isImportTriggers() {
        return this._hash.getBoolean("import_triggers");
    }

    public void setImportTriggers(boolean importTriggers) {
        this._hash.putBoolean("import_triggers", importTriggers);
    }

    public boolean isScanForUsedStructuredTypes() {
        return this._hash.getBoolean("scan_for_used_structured_types");
    }

    public void setScanForUsedStructuredTypes(boolean scanForUsedStructuredTypes) {
        this._hash.putBoolean("scan_for_used_structured_types", scanForUsedStructuredTypes);
    }

    public boolean isImportSecondaryTables() {
        return this._hash.getBoolean("import_secondary_tables");
    }

    public void setImportSecondaryTables(boolean importSecondaryTables) {
        this._hash.putBoolean("import_secondary_tables", importSecondaryTables);
    }

    public boolean isImportSpatialProperties() {
        return this._hash.getBoolean("import_spatial_properties");
    }

    public void setImportSpatialProperties(boolean importSpatialProperties) {
        this._hash.putBoolean("import_spatial_properties", importSpatialProperties);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        HashStructure stHash;
        if (this.contains("import_partitions")) {
            settings.setImportPartitions(this.isImportPartitions());
        }
        if (this.contains("import_triggers")) {
            settings.setImportTriggers(this.isImportTriggers());
        }
        if (this.contains("scan_for_used_structured_types")) {
            settings.setScanForUsedStructuredTypes(this.isScanForUsedStructuredTypes());
        }
        if (this.contains("import_secondary_tables")) {
            settings.setImportSecondaryTables(this.isImportSecondaryTables());
        }
        if (this.contains("import_spatial_properties")) {
            settings.setImportSpatialProperties(this.isImportSpatialProperties());
        }
        if ((stHash = this.getSynchronizationTypes()) != null) {
            Set stringKeys = stHash.keySet();
            TreeSet<Integer> integerKeys = new TreeSet<Integer>();
            Iterator it = stringKeys.iterator();
            while (it.hasNext()) {
                integerKeys.add(new Integer((String)it.next()));
            }
            for (Integer key : integerKeys) {
                HashStructure hs = stHash.getHashStructure(Integer.toString(key));
                String elementDb = hs.getString("db");
                String elementName = hs.getString("name");
                boolean elementIsUsed = hs.getBoolean("used");
                SyncObject so = settings.getSyncObject(elementName, elementDb);
                if (so != null) {
                    so.setUsed(elementIsUsed);
                    continue;
                }
                SyncObject sOb = new SyncObject(elementName, elementIsUsed, elementDb);
                settings.getSyncObjects().add(sOb);
            }
        }
    }

    public void loadFromSettings(Settings settings) {
        HashStructure hs = this.getSynchronizationTypes();
        if (hs != null) {
            hs.clear();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

