/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelRelationalPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelRelationalPP";
    private static final String DFK_S = "delete_fk_columns_strategy";
    private static final String DFK_R = "default_fk_rule";
    private static final String COL_REORD = "allow_columns_reorder";
    private static final String SYNC_REMOTE = "sync_remote_objects_on_load";
    private static final String SURROGATE_KEY_LDT_PRECEISION = "surrogate_key_ldt_precision";
    private static final String SURROGATE_KEY_DOMAIN = "surrogate_key_domain";
    private static final String USE_DB_SYNC_SRC_CONNECTION = "use_db_sync_src_connection";
    private static final String USE_DB_SYNC_SRC_SCHEMA = "use_db_sync_src_schema";
    private static final String DB_SYNC_WHOLE_SCHEMA = "db_sync_whole_schema";
    private static final String USE_DB_SYNC_SRC_OBJECT = "use_db_sync_src_object";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelRelationalPreferences(HashStructure hash) {
        super(hash);
    }

    public static ModelRelationalPreferences getInstance(PropertyStorage prefs) {
        return new ModelRelationalPreferences(ModelRelationalPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public void setDeleteFKColumnStrategy(int deleteFKColumnStrategy) {
        this._hash.putInt(DFK_S, deleteFKColumnStrategy);
    }

    public int getDeleteFKColumnStrategy() {
        return this._hash.getInt(DFK_S);
    }

    public void setDefaultFKDeleteRule(String defaultFKDeleteRule) {
        this._hash.putString(DFK_R, defaultFKDeleteRule);
    }

    public String getDefaultFKDeleteRule() {
        return this._hash.getString(DFK_R);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public boolean getAllowColumnsReorder() {
        return this._hash.getBoolean(COL_REORD);
    }

    public void setAllowColumnsReorder(boolean value) {
        this._hash.putBoolean(COL_REORD, value);
    }

    public boolean getSyncRemoteObjectsOnLoad() {
        return this._hash.getBoolean(SYNC_REMOTE);
    }

    public void setSyncRemoteObjectsOnLoad(boolean value) {
        this._hash.putBoolean(SYNC_REMOTE, value);
    }

    public void setSurrogateKeyLDTPrecision(String value) {
        this._hash.putString(SURROGATE_KEY_LDT_PRECEISION, value);
    }

    public String getSurrogateKeyLDTPrecision() {
        return this._hash.getString(SURROGATE_KEY_LDT_PRECEISION);
    }

    public void setSurrogateKeyDomain(Object value) {
        if (value instanceof Domain) {
            this._hash.putString(SURROGATE_KEY_DOMAIN, ((Domain)value).getObjectID());
        } else {
            this._hash.putString(SURROGATE_KEY_DOMAIN, " ");
        }
    }

    public String getSurrogateKeyDomain() {
        return this._hash.getString(SURROGATE_KEY_DOMAIN);
    }

    public boolean getUseDBSyncSourceConnection() {
        return this._hash.getBoolean(USE_DB_SYNC_SRC_CONNECTION);
    }

    public void setUseDBSyncSourceConnection(boolean value) {
        this._hash.putBoolean(USE_DB_SYNC_SRC_CONNECTION, value);
    }

    public boolean getUseDBSyncSourceSchema() {
        return this._hash.getBoolean(USE_DB_SYNC_SRC_SCHEMA);
    }

    public void setUseDBSyncSourceSchema(boolean value) {
        this._hash.putBoolean(USE_DB_SYNC_SRC_SCHEMA, value);
    }

    public boolean getUseDBSyncSourceObject() {
        return this._hash.getBoolean(USE_DB_SYNC_SRC_OBJECT);
    }

    public void setUseDBSyncSourceObject(boolean value) {
        this._hash.putBoolean(USE_DB_SYNC_SRC_OBJECT, value);
    }

    public boolean getSyncWholeSchema() {
        return this._hash.getBoolean(DB_SYNC_WHOLE_SCHEMA);
    }

    public void setSyncWholeSchema(boolean value) {
        this._hash.putBoolean(DB_SYNC_WHOLE_SCHEMA, value);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(DFK_R)) {
            settings.setDefaultFKDeleteRule(this.getDefaultFKDeleteRule());
        }
        if (this.contains(DFK_S)) {
            settings.setDeleteFKColumnStrategy(this.getDeleteFKColumnStrategy());
        }
        if (this.contains(COL_REORD)) {
            settings.setDefaultAllowColumnsReorder(this.getAllowColumnsReorder());
        }
        if (this.contains(SYNC_REMOTE)) {
            settings.setSyncRemoteObjectsOnLoad(this.getSyncRemoteObjectsOnLoad());
        }
        if (this.contains(SURROGATE_KEY_LDT_PRECEISION)) {
            settings.setSurrogateKeyLDTPrecision(this.getSurrogateKeyLDTPrecision());
        }
        if (this.contains(SURROGATE_KEY_DOMAIN)) {
            settings.setSurrogateKeyDomain(this.getSurrogateKeyDomain());
        }
        if (this.contains(USE_DB_SYNC_SRC_CONNECTION)) {
            settings.setUseDBSyncSourceConnection(this.getUseDBSyncSourceConnection());
        }
        if (this.contains(USE_DB_SYNC_SRC_SCHEMA)) {
            settings.setUseDBSyncSourceSchema(this.getUseDBSyncSourceSchema());
        }
        if (this.contains(USE_DB_SYNC_SRC_OBJECT)) {
            settings.setUseDBSyncSourceObject(this.getUseDBSyncSourceObject());
        }
        if (this.contains(DB_SYNC_WHOLE_SCHEMA)) {
            settings.setSyncWholeSchema(this.getSyncWholeSchema());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setDefaultFKDeleteRule(settings.getDefaultFKDeleteRule());
        this.setDeleteFKColumnStrategy(settings.getDeleteFKColumnStrategy());
        this.setAllowColumnsReorder(settings.isDefaultAllowColumnsReorder());
        this.setSyncRemoteObjectsOnLoad(settings.isSyncRemoteObjectsOnLoad());
        this.setSurrogateKeyLDTPrecision(settings.getSurrogateKeyLDTPrecision());
        this.setSurrogateKeyDomain(settings.getSurrogateKeyDomain());
        this.setUseDBSyncSourceConnection(settings.isUseDBSyncSourceConnection());
        this.setUseDBSyncSourceSchema(settings.isUseDBSyncSourceSchema());
        this.setUseDBSyncSourceObject(settings.isUseDBSyncSourceObject());
        this.setSyncWholeSchema(settings.isSyncWholeSchema());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

