/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelPP";
    private static final String D_RDBMS_T = "default_rdbms_type";
    private static final String D_RDBMS_S = "default_rdbms_site";
    private static final String NA = "nulls_allowed";
    private static final String ALLOW_SIM_TYPES = "allow_similar_types_fk";
    private static final String FK_COLUMN_ON_NEWFK = "fk_column_on_new_fk_option";
    private static final String CDD = "column_default_datatype";
    private static final String PD = "preferred_domains";
    private static final String PL = "preferred_logical_types";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelPreferences(HashStructure hash) {
        super(hash);
    }

    public static ModelPreferences getInstance(PropertyStorage prefs) {
        return new ModelPreferences(ModelPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public String getDefaultRDBMSSite() {
        return this._hash.getString(D_RDBMS_S);
    }

    public void setDefaultRDBMSSite(String defaultRDBMSSite) {
        this._hash.putString(D_RDBMS_S, defaultRDBMSSite);
    }

    public int getDefaultRDBMSType() {
        return this._hash.getInt(D_RDBMS_T);
    }

    public void setDefaultRDBMSType(int defaultRDBMSType) {
        this._hash.putInt(D_RDBMS_T, defaultRDBMSType);
    }

    public boolean isNullsAllowed() {
        return this._hash.getBoolean(NA);
    }

    public void setNullsAllowed(boolean nullsAllowed) {
        this._hash.putBoolean(NA, nullsAllowed);
    }

    public void setAllowSimilarTypesFK(boolean allow) {
        this._hash.putBoolean(ALLOW_SIM_TYPES, allow);
    }

    public boolean isAllowSimilarTypesFK() {
        return this._hash.getBoolean(ALLOW_SIM_TYPES);
    }

    public void setFKColumnOnNewOption(int value) {
        this._hash.putInt(FK_COLUMN_ON_NEWFK, value);
    }

    public int getFKColumnOnNewFKOption() {
        return this._hash.getInt(FK_COLUMN_ON_NEWFK);
    }

    public String getColumnDefaultDatatype() {
        return this._hash.getString(CDD);
    }

    public void setColumnDefaultDatatype(String columnDefaultDatatype) {
        this._hash.putString(CDD, columnDefaultDatatype);
    }

    public HashStructure getPreferredLogicaltypes() {
        return this._hash.getHashStructure(PL);
    }

    public void setPreferredLogicaltypes(List preferredLogicaltypes) {
        HashStructure hsPrferredLogicalTypes = HashStructure.newInstance();
        int counter = 0;
        for (LogicalDatatype lt : preferredLogicaltypes) {
            HashStructure hsPrferredLT = HashStructure.newInstance();
            hsPrferredLT.putString("name", lt.getName());
            hsPrferredLT.putString("id", lt.getObjectID());
            hsPrferredLogicalTypes.putHashStructure(Integer.toString(++counter), hsPrferredLT);
        }
        this._hash.putHashStructure(PL, hsPrferredLogicalTypes);
    }

    public HashStructure getPreferredDomains() {
        return this._hash.getHashStructure(PD);
    }

    public void setPreferredDomains(List preferredDomains) {
        HashStructure hsPrferredDomains = HashStructure.newInstance();
        int counter = 0;
        Iterator it = preferredDomains.iterator();
        while (it.hasNext()) {
            ++counter;
            PreferredDomain d = (PreferredDomain)it.next();
            HashStructure hsPreferredDomain = HashStructure.newInstance();
            hsPreferredDomain.putString("name", d.getName());
            hsPreferredDomain.putString("filename", d.getFileName());
            hsPreferredDomain.putString("id", d.getObjectId());
            hsPrferredDomains.putHashStructure(Integer.toString(counter), hsPreferredDomain);
        }
        this._hash.putHashStructure(PD, hsPrferredDomains);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        HashStructure hs;
        Iterator it;
        TreeSet<Integer> integerKeys;
        Set stringKeys;
        if (this.contains(D_RDBMS_T)) {
            settings.setDefaultRDBMSType(this.getDefaultRDBMSType());
        }
        if (this.contains(D_RDBMS_S)) {
            settings.setDefaultRDBMSSite(this.getDefaultRDBMSSite());
        }
        if (this.contains(NA)) {
            settings.setNullsAllowed(this.isNullsAllowed());
        }
        if (this.contains(ALLOW_SIM_TYPES)) {
            settings.setAllowSimilarTypesFK(this.isAllowSimilarTypesFK());
        }
        if (this.contains(FK_COLUMN_ON_NEWFK)) {
            settings.setFkColumnOnNewFKOption(this.getFKColumnOnNewFKOption());
        }
        if (this.contains(CDD)) {
            settings.setColumnDefaultDatatype(this.getColumnDefaultDatatype());
        }
        if (this.contains(PL)) {
            settings.getPreferredLT().clear();
            HashStructure hsPreferredLT = this._hash.getHashStructure(PL);
            if (hsPreferredLT != null) {
                stringKeys = hsPreferredLT.keySet();
                integerKeys = new TreeSet<Integer>();
                it = stringKeys.iterator();
                while (it.hasNext()) {
                    integerKeys.add(new Integer((String)it.next()));
                }
                for (Integer key : integerKeys) {
                    hs = hsPreferredLT.getHashStructure(Integer.toString(key));
                    settings.getPreferredLT().add(hs.getString("id"));
                }
            }
        }
        if (this.contains(PD)) {
            settings.getPreferredDomains().clear();
            HashStructure hsPreferredDom = this._hash.getHashStructure(PD);
            if (hsPreferredDom != null) {
                stringKeys = hsPreferredDom.keySet();
                integerKeys = new TreeSet();
                it = stringKeys.iterator();
                while (it.hasNext()) {
                    integerKeys.add(new Integer((String)it.next()));
                }
                for (Integer key : integerKeys) {
                    hs = hsPreferredDom.getHashStructure(Integer.toString(key));
                    PreferredDomain pDomain = new PreferredDomain();
                    pDomain.setFileName(hs.getString("filename"));
                    pDomain.setObjectId(hs.getString("id"));
                    pDomain.setName(hs.getString("name"));
                    settings.getPreferredDomains().add(pDomain);
                }
            }
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setDefaultRDBMSSite(settings.getDefaultRDBMSSite());
        this.setDefaultRDBMSType(settings.getDefaultRDBMSType());
        this.setColumnDefaultDatatype(settings.getColumnDefaultDatatype());
        this.setNullsAllowed(settings.getNullsAllowed());
        this.setAllowSimilarTypesFK(settings.isAllowSimilarTypesFK());
        this.setFKColumnOnNewOption(settings.getFkColumnOnNewFKOption());
        HashStructure hsLT = this.getPreferredLogicaltypes();
        if (hsLT != null) {
            hsLT.clear();
        }
        this.setPreferredLogicaltypes(settings.getPreferredLogicaltypes());
        HashStructure hsD = this.getPreferredDomains();
        if (hsD != null) {
            hsD.clear();
        }
        this.setPreferredDomains(settings.getPreferredDomains());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

