/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DiagramPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.ide.panels.TraversableContext;

final class DiagramPP
extends AbstractPP {
    private static final long serialVersionUID = -6009897543848041925L;
    private JCheckBox chbSynchronizeTree;
    private JIntegerField ifGridSize;

    public DiagramPP() {
        this.setHelpID("DIAGRAM_PREFS_PANEL");
        JPanel panelGeneral = new JPanel(new GridBagLayout());
        panelGeneral.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.General")));
        this.addItem(panelGeneral, new JLabel(""), 2, 0, 1, 1, 17, 1, 100);
        this.chbSynchronizeTree = new JCheckBox(Messages.getString("OptionsDialog.SynchronizeWithTree"));
        this.addItem(panelGeneral, this.chbSynchronizeTree, 1, 0, 1, 1, 17, 0, 100);
        JPanel relSeparatorPanel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(Messages.getString("OptionsDialog.GridSize"));
        this.addItem(relSeparatorPanel, label, 1, 0, 1, 1, 17, 0, 100);
        this.ifGridSize = new JIntegerField();
        this.ifGridSize.setPreferredSize(new Dimension(40, 20));
        this.addItem(relSeparatorPanel, this.ifGridSize, 2, 0, 1, 20, 17, 0, 100);
        this.addItem(panelGeneral, relSeparatorPanel, 1, 1, 1, 20, 17, 0, 100);
        this.getApplicationView();
        this.add(panelGeneral, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        this.chbSynchronizeTree.setSelected(settings.synchronizeTree());
        this.ifGridSize.setValue((long)settings.getGridSize());
    }

    public void onExit(TraversableContext tc) {
        settings.setSynchronizeTree(this.chbSynchronizeTree.isSelected());
        int gridSize = this.ifGridSize.getIntValue();
        if (gridSize <= 0) {
            gridSize = 10;
        }
        settings.setGridSize(gridSize);
        DiagramPreferences preferences = this.getDiagramPreferences(tc);
        preferences.setSynchronizeWithTree(this.chbSynchronizeTree.isSelected());
        preferences.setGridSize(gridSize);
    }

    private DiagramPreferences getDiagramPreferences(TraversableContext tc) {
        return DiagramPreferences.getInstance(tc.getPropertyStorage());
    }
}

