/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.oracle.MOHCollectionTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDirectoryOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHObjectColumnsOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHProcedureOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSequenceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSynonymOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHUserOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHBitmapIndexesv10g;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeOraclev9i;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class ExtractionHandlerOracle
extends AbstractDBMExtractionHandler {
    private List mohObjectsv9i = null;
    private List mohObjectsv10g = null;
    private ApplicationView view;
    private MOHDirectoryOracle directoryHandler;
    private MOHTableOracle tableHandler;

    public ExtractionHandlerOracle(ApplicationView view) {
        this.view = view;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.getMOHObjectsv9i();
            }
        }
        return this.getMOHObjectsv10g();
    }

    public List getMOHObjectsv9i() {
        if (this.mohObjectsv9i == null) {
            this.mohObjectsv9i = new ArrayList();
            this.mohObjectsv9i.add(new MOHTypeIncompleteOraclev9i(this, this.view));
            this.mohObjectsv9i.add(new MOHTypeOraclev9i(this, this.view));
            this.mohObjectsv9i.add(new MOHCollectionTypeOracle(this, this.view));
            this.directoryHandler = new MOHDirectoryOracle(this, this.view);
            this.mohObjectsv9i.add(this.directoryHandler);
            this.mohObjectsv9i.add(new MOHUserOracle(this, this.view));
            MOHViewOracle viewHandler = new MOHViewOracle(this, this.view);
            this.tableHandler = new MOHTableOraclev9i(this, this.view);
            viewHandler.setTableHandlerOracle(this.tableHandler);
            this.tableHandler.setViewHandlerOracle(viewHandler);
            this.mohObjectsv9i.add(viewHandler);
            this.mohObjectsv9i.add(this.tableHandler);
            this.mohObjectsv9i.add(new MOHBitmapIndexesv10g(this, this.view));
            this.mohObjectsv9i.add(new MOHObjectColumnsOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHProcedureOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHSequenceOracle(this, this.view));
            this.mohObjectsv9i.add(new MOHSynonymOracle(this, this.view));
        }
        return this.mohObjectsv9i;
    }

    public List getMOHObjectsv10g() {
        if (this.mohObjectsv10g == null) {
            this.mohObjectsv10g = new ArrayList();
            this.mohObjectsv10g.add(new MOHTypeIncompleteOraclev9i(this, this.view));
            this.mohObjectsv10g.add(new MOHTypeOraclev9i(this, this.view));
            this.mohObjectsv10g.add(new MOHCollectionTypeOracle(this, this.view));
            this.directoryHandler = new MOHDirectoryOracle(this, this.view);
            this.mohObjectsv10g.add(this.directoryHandler);
            this.mohObjectsv10g.add(new MOHUserOracle(this, this.view));
            MOHViewOracle viewHandler = new MOHViewOracle(this, this.view);
            this.tableHandler = new MOHTableOraclev9i(this, this.view);
            viewHandler.setTableHandlerOracle(this.tableHandler);
            this.tableHandler.setViewHandlerOracle(viewHandler);
            this.mohObjectsv10g.add(viewHandler);
            this.mohObjectsv10g.add(this.tableHandler);
            this.mohObjectsv10g.add(new MOHBitmapIndexesv10g(this, this.view));
            this.mohObjectsv10g.add(new MOHObjectColumnsOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHProcedureOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHSequenceOracle(this, this.view));
            this.mohObjectsv10g.add(new MOHSynonymOracle(this, this.view));
        }
        return this.mohObjectsv10g;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        RDBMSSiteSet rdbmsSiteSet = this.view.getCurrentDesign().getRDBMSSiteSet();
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
            }
            case 10: {
                return rdbmsSiteSet.get(StorageDesignOraclev10g.RDBMS_TYPE);
            }
            case 11: {
                return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
            }
            case 12: {
                return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
            }
        }
        return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        List mhoList = this.getMOHObjects();
        if (selectedObjects.size() > 0 && mhoList.size() > 0 && conn != null && !this.isNullStorageDesign(this.view.getCurrentDesign().getRelationalDesign().getStorageDesign())) {
            try {
                int counter = 0;
                double step = 10.0;
                int size = mhoList.size();
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.generate(conn, selectedObjects, importLog);
                    moHandler.clearHandledObjects(selectedObjects);
                    ++counter;
                    monitor.setProgress((int)(step += 75.0 / (double)size));
                }
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.postGenerateProcessing(conn);
                }
            }
            catch (Exception e) {
                importLog.addError(e.getMessage());
            }
        }
    }

    public MOHDirectoryOracle getDirectoryHandler() {
        return this.directoryHandler;
    }

    @Override
    public AbstractMOHandler getTableHandler() {
        return this.tableHandler;
    }
}

