/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.odbc.MOHForeignKeyODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHTableODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHViewODBC;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class ExtractionHandlerODBC
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private static final String DB_NAME_UDB = "UDB";
    private static final String DB_NAME_ORACLE = "ORACLE";
    private static final String DB_NAME_SQL_SERVER = "SQL SERVER";
    private List mohObjects = null;
    private ApplicationView view;

    public ExtractionHandlerODBC(ApplicationView view) {
        this.view = view;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public List getMOHObjects() {
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHTableODBC(this, this.view));
            this.mohObjects.add(new MOHForeignKeyODBC(this, this.view));
            this.mohObjects.add(new MOHViewODBC(this, this.view));
        }
        return this.mohObjects;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        if (this.dbMajorVersion == -1) {
            String version = this.dbProductVersion.indexOf(46) > -1 ? this.dbProductVersion.substring(0, this.dbProductVersion.indexOf(46)) : this.dbProductVersion;
            try {
                this.dbMajorVersion = Integer.parseInt(version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RDBMSSiteSet rdbmsSiteSet = this.view.getCurrentDesign().getRDBMSSiteSet();
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_ORACLE) > -1) {
            switch (this.dbMajorVersion) {
                case 8: 
                case 9: {
                    return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
                }
                case 10: {
                    return rdbmsSiteSet.get(StorageDesignOraclev10g.RDBMS_TYPE);
                }
                case 11: {
                    return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
                }
                case 12: {
                    return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
                }
            }
            return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_SQL_SERVER) > -1) {
            return rdbmsSiteSet.get(StorageDesignSqlServerv2k.RDBMS_TYPE);
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_UDB) > -1) {
            switch (this.dbMajorVersion) {
                case 7: {
                    return rdbmsSiteSet.get(StorageDesignUDBv71.RDBMS_TYPE);
                }
                case 8: {
                    return rdbmsSiteSet.get(StorageDesignUDBv81.RDBMS_TYPE);
                }
                case 9: {
                    return rdbmsSiteSet.get(StorageDesignUDBv9.RDBMS_TYPE);
                }
            }
            return rdbmsSiteSet.get(StorageDesignUDBv9.RDBMS_TYPE);
        }
        return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        List mhoList = this.getMOHObjects();
        if (selectedObjects.size() > 0 && mhoList.size() > 0 && conn != null && !this.isNullStorageDesign(this.view.getCurrentDesign().getRelationalDesign().getStorageDesign())) {
            try {
                int counter = 0;
                double step = 10.0;
                int size = mhoList.size();
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.setSupportInformation_Schema(true);
                    moHandler.generate(conn, selectedObjects, importLog);
                    moHandler.clearHandledObjects(selectedObjects);
                    ++counter;
                    monitor.setProgress((int)(step += 75.0 / (double)size));
                }
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.postGenerateProcessing(conn);
                }
            }
            catch (Exception e) {
                importLog.addError(e.getMessage());
            }
        }
    }
}

