/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.Icons;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Ide;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;

public class NavigatorDockable
extends DockableWindow {
    public static final String VIEW_NAME = "DM_NAVIGATOR";
    public static final ViewId VIEW_ID = new ViewId("EXTDockable", "DM_NAVIGATOR");
    private JPanel jpanel;
    private HelpInfo helpInfo;
    private Component navigator = null;

    public NavigatorDockable() {
        super(Ide.getMainWindow(), VIEW_ID.getId());
    }

    public int getDefaultVisibility(Layout layout) {
        if (!Extension.isDataModeler()) {
            return 0;
        }
        return 3;
    }

    public Component getGUI() {
        return this.getPanel();
    }

    public String getTitleName() {
        return Messages.getString("NavigatorDockable.DataModelingNavigator");
    }

    public String getTabName() {
        return this.getTitleName();
    }

    private JPanel getPanel() {
        if (this.jpanel == null) {
            this.jpanel = new JPanel(new BorderLayout());
        }
        return this.jpanel;
    }

    public Icon getTabIcon() {
        return Icons.getNavigatorIcon();
    }

    public void setNavigator(Component navigator) {
        if (this.navigator != navigator) {
            if (this.navigator != null) {
                this.getPanel().remove(this.navigator);
            }
            this.getPanel().add(navigator);
            this.navigator = navigator;
            this.getPanel().updateUI();
        }
    }

    public void clearNavigator() {
        if (this.navigator != null) {
            this.getPanel().remove(this.navigator);
            this.navigator = null;
            this.getPanel().updateUI();
        }
    }

    public HelpInfo getHelpInfo() {
        if (this.helpInfo == null) {
            this.helpInfo = new HelpInfo("NAVIGATOR_PANEL");
        }
        return this.helpInfo;
    }
}

