/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.xmla;

import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.xmla.XMLADataTypesMapping;
import oracle.dbtools.crest.exports.xmla.XMLAExportOptions;
import oracle.dbtools.crest.imports.xmla.XMLAConstants;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.ExportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;

public class XMLAExporter
implements XMLAConstants {
    public static final String NEW_LINE = "\n";
    public static final String TAB = "    ";
    private Design design;
    private static final Logger LOGGER = new Logger(XMLAExporter.class);
    private ApplicationView appView;
    private StringBuffer content = new StringBuffer();
    private MultidimensionalDesign mdmDesign;
    private String schema = "DEFAULT_SCHEMA";
    private String catalog = "DEMO_DB";
    private List appendedDimensions;
    private ExportLogger exportLog;

    public XMLAExporter(ApplicationView appView) {
        this.appView = appView;
        this.design = appView.getCurrentDesign();
        this.appendedDimensions = new ArrayList();
        this.exportLog = new ExportLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        block7: {
            try {
                XMLAExportOptions exportOptions = new XMLAExportOptions(this.appView);
                boolean result = exportOptions.showDialog();
                if (result) {
                    this.mdmDesign = exportOptions.getMultidimensionalDesign();
                    this.exportLog.setModelName(this.mdmDesign.getName());
                    this.catalog = exportOptions.getCatalog();
                    if (this.mdmDesign == null) break block7;
                    boolean saved = false;
                    try {
                        this.prepareContent();
                        saved = this.saveOutput();
                        break block7;
                    }
                    finally {
                        if (saved && this.appView.getSettings().showImportLog()) {
                            LogReport logPanel = new LogReport(this.appView);
                            logPanel.setLog(this.exportLog.generateReport(this.appView));
                            logPanel.showDialog(new Dimension(750, 550));
                        }
                    }
                }
                ApplicationView.log(Messages.getString("XMLAExporter.ExportCanceled"));
            }
            catch (Exception e) {
                LOGGER.error("Error Exporting to Microsoft XMLA File", e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAExporter.UnableToExportToMicrosoftXMLAFile"), Messages.getString("XMLAExporter.Error"), 0);
            }
        }
    }

    private void prepareContent() {
        this.appendCreateHeader();
        this.appendObjectDefinition();
        this.appendCreateEnd();
    }

    private void appendCreateHeader() {
        this.content.append("<Create xmlns=\"http://schemas.microsoft.com/analysisservices/2003/engine\">");
    }

    private void appendObjectDefinition() {
        this.content.append(NEW_LINE);
        this.content.append(TAB);
        this.content.append("<ObjectDefinition>");
        this.content.append(NEW_LINE);
        this.appendTabs(2);
        this.content.append("<Database xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        this.appendID(this.catalog, 3);
        this.appendName(this.catalog, 3);
        this.appendDescription("A Unified Dimensional Model generated by Oracle SQL Developer Modeler.", 3);
        this.appendDataSourceImpersonationInfo();
        this.appendDimensions();
        this.appendCubes();
        this.appendDataSources();
        this.appendDataSourceViews();
        this.content.append(NEW_LINE);
        this.appendTabs(2);
        this.content.append("</Database>");
        this.content.append(NEW_LINE);
        this.content.append(TAB);
        this.content.append("</ObjectDefinition>");
    }

    private void appendCreateEnd() {
        this.content.append(NEW_LINE);
        this.content.append("</Create>");
    }

    private void appendTabs(int tabs) {
        for (int i = 0; i < tabs; ++i) {
            this.content.append(TAB);
        }
    }

    private void appendID(String id, int tabs) {
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("<ID>");
        this.content.append(id);
        this.content.append("</ID>");
    }

    private void appendName(String name, int tabs) {
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("<Name>");
        this.content.append(name);
        this.content.append("</Name>");
    }

    private void appendUsage(String usage, int tabs) {
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("<Usage>");
        this.content.append(usage);
        this.content.append("</Usage>");
    }

    private void appendElement(String elementName, String value, int tabs) {
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("<" + elementName + ">");
        this.content.append(value);
        this.content.append("</" + elementName + ">");
    }

    private void appendDescription(String description, int tabs) {
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("<Description>");
        this.content.append(description);
        this.content.append("</Description>");
    }

    private void appendDataSourceImpersonationInfo() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<DataSourceImpersonationInfo>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<ImpersonationMode>Default</ImpersonationMode>");
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</DataSourceImpersonationInfo>");
    }

    private void appendDimensions() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<Dimensions>");
        Iterator it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)it.next();
            if (dimension.getAllAttributes().size() > 0) {
                this.appendDimension(dimension);
                this.appendedDimensions.add(dimension);
                continue;
            }
            this.exportLog.addWarning("DIMENSION '" + dimension.getName() + "' has no attributes and can not be exported", true);
            LOGGER.warn("XMLAExporter.appendDimensions(): Dimension '" + dimension.getName() + "' has no attributes!");
        }
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</Dimensions>");
    }

    private void appendDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Dimension>");
        this.appendID("DIM " + dimension.getName(), 5);
        this.appendName(dimension.getName(), 5);
        this.appendSource();
        this.appendAttributes(dimension);
        this.appendHierarchies(dimension);
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Dimension>");
    }

    private void appendSource() {
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Source xsi:type=\"DataSourceViewBinding\">");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<DataSourceViewID>");
        this.content.append(this.schema);
        this.content.append("</DataSourceViewID>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Source>");
    }

    private void appendAttributeRelationship(String name, int tabs) {
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("<AttributeRelationship>");
        this.content.append(NEW_LINE);
        this.appendTabs(tabs + 1);
        this.content.append("<AttributeID>");
        this.content.append(name);
        this.content.append("</AttributeID>");
        this.content.append(NEW_LINE);
        this.appendTabs(tabs + 1);
        this.content.append("<Name>");
        this.content.append(name);
        this.content.append("</Name>");
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("</AttributeRelationship>");
    }

    private void appendColumnSource(ContainedObject attribute, int tabs) {
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("<Source xsi:type=\"ColumnBinding\">");
        this.content.append(NEW_LINE);
        this.appendTabs(tabs + 1);
        this.content.append("<TableID>");
        this.content.append(attribute.getContainer().getName());
        this.content.append("</TableID>");
        this.content.append(NEW_LINE);
        this.appendTabs(tabs + 1);
        this.content.append("<ColumnID>");
        this.content.append(attribute.getName());
        this.content.append("</ColumnID>");
        this.content.append(NEW_LINE);
        this.appendTabs(tabs);
        this.content.append("</Source>");
    }

    private void appendAttributes(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        ArrayList relationShipAttributes = new ArrayList();
        ArrayList<String> createdAttributes = new ArrayList<String>();
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Attributes>");
        Iterator it = dimension.getAllLevels().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Level level = (Level)it.next();
            this.appendLevel(level, first, relationShipAttributes, createdAttributes);
            first = false;
        }
        for (ContainedObject attribute : relationShipAttributes) {
            if (createdAttributes.contains(attribute.getName().toUpperCase())) continue;
            this.appendAttribute(attribute);
            createdAttributes.add(attribute.getName().toUpperCase());
        }
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Attributes>");
    }

    private void appendLevel(Level level, boolean isKey, List relationShipAttributes, List createdAttributes) {
        if (!level.isValueBasedHierarchy()) {
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("<Attribute>");
            String name = level.getName();
            this.appendID(name, 6);
            this.appendName(name, 6);
            if (isKey) {
                this.appendUsage("Key", 6);
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<KeyColumns>");
            for (ContainedObject attribute : level.getLevelKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<KeyColumn>");
                String dataType = attribute instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute).getDataTypeString());
                this.appendElement("DataType", dataType, 8);
                this.appendColumnSource(attribute, 8);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</KeyColumns>");
            if (level.getDescriptiveAttributes().size() > 0) {
                ContainedObject attribute;
                attribute = (ContainedObject)level.getDescriptiveAttributes().get(0);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("<NameColumn>");
                this.appendElement("DataType", "WChar", 7);
                this.appendColumnSource(attribute, 7);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("</NameColumn>");
                if (level.getDescriptiveAttributes().size() > 1) {
                    this.content.append(NEW_LINE);
                    this.appendTabs(6);
                    this.content.append("<AttributeRelationships>");
                    Object[] attributes = level.getDescriptiveAttributes().toArray();
                    for (int i = 1; i < attributes.length; ++i) {
                        attribute = (ContainedObject)attributes[i];
                        if (!relationShipAttributes.contains(attribute)) {
                            relationShipAttributes.add(attribute);
                        }
                        this.appendAttributeRelationship(attribute.getName(), 7);
                    }
                    this.content.append(NEW_LINE);
                    this.appendTabs(6);
                    this.content.append("</AttributeRelationships>");
                }
            }
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("</Attribute>");
            createdAttributes.add(name.toUpperCase());
        } else {
            String dataType;
            ContainedObject attribute2;
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("<Attribute>");
            String name = level.getName();
            this.appendID(name, 6);
            this.appendName(name, 6);
            this.appendUsage("Parent", 6);
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<KeyColumns>");
            for (ContainedObject attribute2 : level.getParentKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<KeyColumn>");
                dataType = attribute2 instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute2).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute2).getDataTypeString());
                this.appendElement("DataType", dataType, 8);
                this.appendColumnSource(attribute2, 8);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</KeyColumns>");
            if (level.getDescriptiveAttributes().size() > 0) {
                attribute2 = (ContainedObject)level.getDescriptiveAttributes().get(0);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("<NameColumn>");
                this.appendElement("DataType", "WChar", 7);
                this.appendColumnSource(attribute2, 7);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("</NameColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("</Attribute>");
            createdAttributes.add(name.toUpperCase());
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("<Attribute>");
            name = level.getName() + " Attribute";
            this.appendID(name, 6);
            this.appendName(name, 6);
            if (isKey) {
                this.appendUsage("Key", 6);
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<KeyColumns>");
            for (ContainedObject attribute2 : level.getLevelKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<KeyColumn>");
                dataType = attribute2 instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute2).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute2).getDataTypeString());
                this.appendElement("DataType", dataType, 8);
                this.appendColumnSource(attribute2, 8);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</KeyColumns>");
            if (level.getDescriptiveAttributes().size() > 0) {
                attribute2 = (ContainedObject)level.getDescriptiveAttributes().get(0);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("<NameColumn>");
                this.appendElement("DataType", "WChar", 7);
                this.appendColumnSource(attribute2, 7);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("</NameColumn>");
                if (level.getDescriptiveAttributes().size() > 1) {
                    this.content.append(NEW_LINE);
                    this.appendTabs(6);
                    this.content.append("<AttributeRelationships>");
                    Object[] attributes = level.getDescriptiveAttributes().toArray();
                    for (int i = 1; i < attributes.length; ++i) {
                        attribute2 = (ContainedObject)attributes[i];
                        if (!relationShipAttributes.contains(attribute2)) {
                            relationShipAttributes.add(attribute2);
                        }
                        this.appendAttributeRelationship(attribute2.getName(), 7);
                    }
                    this.content.append(NEW_LINE);
                    this.appendTabs(6);
                    this.content.append("</AttributeRelationships>");
                }
            }
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("</Attribute>");
            createdAttributes.add(name.toUpperCase());
        }
    }

    private void appendAttribute(ContainedObject attribute) {
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<Attribute>");
        this.appendID(attribute.getName(), 6);
        this.appendName(attribute.getName(), 6);
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("<KeyColumns>");
        this.content.append(NEW_LINE);
        this.appendTabs(7);
        this.content.append("<KeyColumn>");
        String dataType = attribute instanceof Attribute ? (attribute.getSourceType().equalsIgnoreCase("Derived") ? "WChar" : XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute).getDatatypeString("SQL Server 2005"))) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute).getDataTypeString());
        this.appendElement("DataType", dataType, 8);
        this.appendColumnSource(attribute, 8);
        this.content.append(NEW_LINE);
        this.appendTabs(7);
        this.content.append("</KeyColumn>");
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("</KeyColumns>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</Attribute>");
    }

    private void appendHierarchies(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        Hierarchy hierarchy;
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Hierarchies>");
        Iterator it = dimension.getHierarchies().iterator();
        while (it.hasNext() && ((hierarchy = (Hierarchy)it.next()).getLevels().size() != 1 || !((Level)hierarchy.getLevels().get(0)).isValueBasedHierarchy())) {
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("<Hierarchy>");
            this.appendID("Hierarchy " + hierarchy.getName(), 6);
            this.appendName("Hierarchy " + hierarchy.getName(), 6);
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<Levels>");
            Object[] levels = hierarchy.getLevels().toArray();
            for (int i = levels.length - 1; i >= 0; --i) {
                Level level = (Level)levels[i];
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<Level>");
                this.appendID(level.getName(), 8);
                this.appendName(level.getName(), 8);
                this.appendElement("SourceAttributeID", level.getName(), 8);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</Level>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</Levels>");
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("</Hierarchy>");
        }
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Hierarchies>");
    }

    private boolean canExtractCube(Cube cube) {
        for (Measure measure : cube.getMeasures()) {
            if (measure.getMeasureFact() == null) continue;
            return true;
        }
        return false;
    }

    private void appendCubes() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<Cubes>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Cube>");
        this.appendID(this.schema, 5);
        this.appendName(this.schema, 5);
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<Dimensions>");
        Iterator mdit = this.mdmDesign.getDimensionSet().iterator();
        while (mdit.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)mdit.next();
            if (!this.appendedDimensions.contains(dim)) continue;
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<Dimension>");
            this.appendID("DIM " + dim.getName(), 7);
            this.appendName(dim.getName(), 7);
            this.appendElement("DimensionID", "DIM " + dim.getName(), 7);
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</Dimension>");
        }
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</Dimensions>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<MeasureGroups>");
        Iterator it = this.mdmDesign.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            if (!this.canExtractCube(cube)) continue;
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<MeasureGroup>");
            this.appendID(cube.getName(), 6);
            this.appendName(cube.getName(), 6);
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<Measures>");
            for (Measure measure : cube.getMeasures()) {
                if (measure.getMeasureFact() == null) continue;
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<Measure>");
                this.appendID(measure.getName(), 8);
                this.appendName(measure.getName(), 8);
                if (measure.getAggregateFunctions().size() > 0) {
                    Measure.AggregateFunction af = (Measure.AggregateFunction)measure.getAggregateFunctions().get(0);
                    this.appendElement("AggregateFunction", af.getName(), 8);
                    this.appendElement("DataType", "Integer", 9);
                }
                this.content.append(NEW_LINE);
                this.appendTabs(8);
                this.content.append("<Source>");
                String dataType = measure.getMeasureFact().getSourceType().equalsIgnoreCase("Derived") ? "Double" : (measure.getMeasureFact() instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((ContainedObjectWithDomain)measure.getMeasureFact()).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)measure.getMeasureFact()).getDataTypeString()));
                this.appendElement("DataType", dataType, 9);
                this.appendColumnSource(measure.getMeasureFact(), 9);
                this.content.append(NEW_LINE);
                this.appendTabs(8);
                this.content.append("</Source>");
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</Measure>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</Measures>");
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<Dimensions>");
            for (oracle.dbtools.crest.model.design.multidimensional.Dimension dim : cube.getDimensions()) {
                if (!this.appendedDimensions.contains(dim)) continue;
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<Dimension xsi:type=\"RegularMeasureGroupDimension\">");
                this.appendElement("CubeDimensionID", "DIM " + dim.getName(), 8);
                this.appendCubeDimAttributes(dim);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</Dimension>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</Dimensions>");
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</MeasureGroup>");
        }
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</MeasureGroups>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<Source>");
        this.appendElement("DataSourceViewID", this.schema, 6);
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</Source>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Cube>");
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</Cubes>");
    }

    private void appendDataSources() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<DataSources>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<DataSource xsi:type=\"RelationalDataSource\">");
        this.appendID(this.schema, 5);
        this.appendName(this.schema, 5);
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<ImpersonationInfo>");
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("<ImpersonationMode>ImpersonateServiceAccount</ImpersonationMode>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</ImpersonationInfo>");
        this.content.append("<ConnectionString>Provider=SQLNCLI.1;Data Source=Localhost;Persist Security Info=False;Integrated Security=SSPI;Initial Catalog=" + this.catalog + "</ConnectionString>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</DataSource>");
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</DataSources>");
    }

    private void appendDataSourceViews() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<DataSourceViews>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<DataSourceView>");
        this.appendID(this.schema, 5);
        this.appendName(this.schema, 5);
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<DataSourceID>" + this.schema + "</DataSourceID> ");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<Schema>");
        String schemaName = this.convertName(this.schema);
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("<xs:schema id=\"" + schemaName + "\" xmlns=\"\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:msdata=\"urn:schemas-microsoft-com:xml-msdata\" xmlns:msprop=\"urn:schemas-microsoft-com:xml-msprop\">");
        this.content.append(NEW_LINE);
        this.appendTabs(7);
        this.content.append("<xs:element name=\"" + schemaName + "\" msdata:IsDataSet=\"true\" msdata:UseCurrentLocale=\"true\">");
        this.content.append(NEW_LINE);
        this.appendTabs(8);
        this.content.append("<xs:complexType>");
        this.content.append(NEW_LINE);
        this.appendTabs(9);
        this.content.append("<xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
        this.appendTables();
        this.content.append(NEW_LINE);
        this.appendTabs(9);
        this.content.append("</xs:choice>");
        this.content.append(NEW_LINE);
        this.appendTabs(8);
        this.content.append("</xs:complexType>");
        this.content.append(NEW_LINE);
        this.appendTabs(7);
        this.content.append("</xs:element>");
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("</xs:schema>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</Schema>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</DataSourceView>");
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</DataSourceViews>");
    }

    private void appendTables() {
        String dataType;
        String size;
        String attrName;
        ContainedObject attribute;
        int i;
        ContainedObject[] elements;
        String entityName;
        Iterator it = this.design.getLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            entityName = entity.getName();
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("<xs:element name=\"" + entityName + "\" msprop:FriendlyName=\"" + entityName + "\" msprop:DbSchemaName=\"dbo\" msprop:DbTableName=\"" + entityName + "\" msprop:TableType=\"Table\">");
            this.content.append(NEW_LINE);
            this.appendTabs(11);
            this.content.append("<xs:complexType>");
            this.content.append(NEW_LINE);
            this.appendTabs(12);
            this.content.append("<xs:sequence>");
            elements = entity.getElements();
            for (i = 0; i < elements.length; ++i) {
                attribute = elements[i];
                attrName = attribute.getName();
                if (attribute.getSourceType().equalsIgnoreCase("Derived")) {
                    String expression = attribute.getFormulaDesc();
                    expression = expression.replaceAll("\"", "&quot;");
                    this.content.append(NEW_LINE);
                    this.appendTabs(13);
                    this.content.append("<xs:element name=\"" + attribute.getName() + "\" msdata:ReadOnly=\"true\" msprop:ComputedColumnExpression=\"" + expression + "\" msprop:IsLogical=\"True\" type=\"xs:string\" minOccurs=\"0\" />");
                    continue;
                }
                size = attribute.getSize();
                if ("".equalsIgnoreCase(size)) {
                    size = "-1";
                }
                dataType = attribute instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute).getDataTypeString());
                dataType = XMLADataTypesMapping.getAppropriateColumnDatatype(dataType.toUpperCase());
                this.content.append(NEW_LINE);
                this.appendTabs(13);
                this.content.append("<xs:element name=\"" + attrName + "\" msdata:ReadOnly=\"true\" msdata:AutoIncrement=\"true\" msprop:FriendlyName=\"" + attrName + "\" msprop:DbColumnName=\"" + attrName + "\" msprop:DataSize=\"" + size + "\" type=\"xs:" + dataType + "\" />");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(12);
            this.content.append("</xs:sequence>");
            this.content.append(NEW_LINE);
            this.appendTabs(11);
            this.content.append("</xs:complexType>");
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("</xs:element>");
        }
        it = this.design.getLogicalDesign().getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView entityView = (EntityView)it.next();
            entityName = entityView.getName();
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("<xs:element name=\"" + entityName + "\" msprop:FriendlyName=\"" + entityName + "\" msprop:DbSchemaName=\"dbo\" msprop:DbTableName=\"" + entityName + "\" msprop:TableType=\"View\">");
            this.content.append(NEW_LINE);
            this.appendTabs(11);
            this.content.append("<xs:complexType>");
            this.content.append(NEW_LINE);
            this.appendTabs(12);
            this.content.append("<xs:sequence>");
            elements = entityView.getElements();
            for (i = 0; i < elements.length; ++i) {
                attribute = elements[i];
                attrName = attribute.getName();
                size = attribute.getSize();
                if ("".equalsIgnoreCase(size)) {
                    size = "-1";
                }
                dataType = attribute instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute).getDataTypeString());
                dataType = XMLADataTypesMapping.getAppropriateColumnDatatype(dataType.toUpperCase());
                this.content.append(NEW_LINE);
                this.appendTabs(13);
                this.content.append("<xs:element name=\"" + attrName + "\" msprop:FriendlyName=\"" + attrName + "\" msprop:DbColumnName=\"" + attrName + "\" msprop:DataSize=\"" + size + "\" type=\"xs:" + dataType + "\" />");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(12);
            this.content.append("</xs:sequence>");
            this.content.append(NEW_LINE);
            this.appendTabs(11);
            this.content.append("</xs:complexType>");
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("</xs:element>");
        }
    }

    private String convertName(String name) {
        String result = "";
        String separator = "_x0020_";
        StringTokenizer st = new StringTokenizer(name, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            result = result + token + separator;
        }
        if (result.endsWith(separator)) {
            result = result.substring(0, result.length() - separator.length());
        }
        return result;
    }

    private void appendCubeDimAttributes(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        ArrayList relationShipAttributes = new ArrayList();
        ArrayList<String> createdAttributes = new ArrayList<String>();
        this.content.append(NEW_LINE);
        this.appendTabs(8);
        this.content.append("<Attributes>");
        Iterator it = dimension.getAllLevels().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Level level = (Level)it.next();
            this.appendCubeDimLevel(level, first, relationShipAttributes, createdAttributes);
            first = false;
        }
        for (ContainedObject attribute : relationShipAttributes) {
            if (createdAttributes.contains(attribute.getName().toUpperCase())) continue;
            this.appendCubeDimAttribute(attribute);
            createdAttributes.add(attribute.getName().toUpperCase());
        }
        this.content.append(NEW_LINE);
        this.appendTabs(8);
        this.content.append("</Attributes>");
    }

    private void appendCubeDimLevel(Level level, boolean isKey, List relationShipAttributes, List createdAttributes) {
        if (!level.isValueBasedHierarchy()) {
            this.content.append(NEW_LINE);
            this.appendTabs(9);
            this.content.append("<Attribute>");
            String name = level.getName();
            this.appendElement("AttributeID", name, 10);
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("<KeyColumns>");
            for (ContainedObject attribute : level.getLevelKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(11);
                this.content.append("<KeyColumn>");
                String dataType = attribute instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute).getDataTypeString());
                this.appendElement("DataType", dataType, 12);
                if (isKey) {
                    this.appendColumnSource(attribute, 12);
                } else {
                    this.content.append(NEW_LINE);
                    this.appendTabs(12);
                    this.content.append("<Source xsi:type=\"InheritedBinding\" />");
                }
                this.content.append(NEW_LINE);
                this.appendTabs(11);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("</KeyColumns>");
            if (isKey) {
                this.appendElement("Type", "Granularity", 10);
            }
            if (level.getDescriptiveAttributes().size() > 0) {
                Object[] attributes = level.getDescriptiveAttributes().toArray();
                for (int i = 1; i < attributes.length; ++i) {
                    ContainedObject attribute = (ContainedObject)attributes[i];
                    if (relationShipAttributes.contains(attribute)) continue;
                    relationShipAttributes.add(attribute);
                }
            }
            this.content.append(NEW_LINE);
            this.appendTabs(9);
            this.content.append("</Attribute>");
            createdAttributes.add(name.toUpperCase());
        } else {
            this.content.append(NEW_LINE);
            this.appendTabs(9);
            this.content.append("<Attribute>");
            String name = level.getName() + " Attribute";
            this.appendElement("AttributeID", name, 10);
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("<KeyColumns>");
            for (ContainedObject attribute : level.getLevelKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(11);
                this.content.append("<KeyColumn>");
                String dataType = attribute instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute).getDataTypeString());
                this.appendElement("DataType", dataType, 12);
                if (isKey) {
                    this.appendColumnSource(attribute, 12);
                } else {
                    this.content.append(NEW_LINE);
                    this.appendTabs(12);
                    this.content.append("<Source xsi:type=\"InheritedBinding\" />");
                }
                this.content.append(NEW_LINE);
                this.appendTabs(11);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("</KeyColumns>");
            if (isKey) {
                this.appendElement("Type", "Granularity", 10);
            }
            if (level.getDescriptiveAttributes().size() > 0) {
                Object[] attributes = level.getDescriptiveAttributes().toArray();
                for (int i = 1; i < attributes.length; ++i) {
                    ContainedObject attribute = (ContainedObject)attributes[i];
                    if (relationShipAttributes.contains(attribute)) continue;
                    relationShipAttributes.add(attribute);
                }
            }
            this.content.append(NEW_LINE);
            this.appendTabs(9);
            this.content.append("</Attribute>");
            createdAttributes.add(name.toUpperCase());
        }
    }

    private void appendCubeDimAttribute(ContainedObject attribute) {
        this.content.append(NEW_LINE);
        this.appendTabs(9);
        this.content.append("<Attribute>");
        this.appendElement("AttributeID", attribute.getName(), 10);
        this.content.append(NEW_LINE);
        this.appendTabs(10);
        this.content.append("<KeyColumns>");
        this.content.append(NEW_LINE);
        this.appendTabs(11);
        this.content.append("<KeyColumn>");
        String dataType = attribute instanceof Attribute ? (attribute.getSourceType().equalsIgnoreCase("Derived") ? "WChar" : XMLADataTypesMapping.getAppropriateDatatype(((Attribute)attribute).getDatatypeString("SQL Server 2005"))) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)attribute).getDataTypeString());
        this.appendElement("DataType", dataType, 12);
        this.content.append(NEW_LINE);
        this.appendTabs(12);
        this.content.append("<Source xsi:type=\"InheritedBinding\" />");
        this.content.append(NEW_LINE);
        this.appendTabs(11);
        this.content.append("</KeyColumn>");
        this.content.append(NEW_LINE);
        this.appendTabs(10);
        this.content.append("</KeyColumns>");
        this.content.append(NEW_LINE);
        this.appendTabs(9);
        this.content.append("</Attribute>");
    }

    public boolean saveOutput() {
        try {
            URLFilter fileFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".xmla") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("XMLAExporter.XMLAFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(fileFilter);
            fileChooser.setPathContext("dataModeler_Exports");
            String lastDir = this.appView.getSettings().getDefaultSavePath();
            if (lastDir != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
            } else {
                URL url = this.appView.getUserHomeDirectory();
                if (url != null) {
                    fileChooser.setSelectedURL(url);
                }
            }
            String fileName = this.design.getName() + ".xmla";
            fileChooser.setFileNameURL(fileName);
            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAExporter.SaveToXMLAFile"));
            if (status == 0) {
                File selectedFolder = new File(fileChooser.getSelectedURL().getPath());
                if (selectedFolder != null && this.saveFile(selectedFolder)) {
                    ApplicationView.log(Messages.getString("XMLAExporter.ExportedOk"));
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAExporter.ExportedOk"));
                    return true;
                }
                ApplicationView.log(Messages.getString("XMLAExporter.ExportCanceled"));
            } else {
                ApplicationView.log(Messages.getString("XMLAExporter.ExportCanceled"));
            }
        }
        catch (IOException ioe) {
            LOGGER.error("", ioe);
            MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), ioe.getMessage());
        }
        catch (Throwable t) {
            MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), t.getMessage());
        }
        return false;
    }

    protected boolean saveFile(File file) throws IOException {
        int result;
        if (file.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("XMLAExporter.FileExists"), file.getAbsolutePath()), Messages.getString("XMLAExporter.Warning"), 0, 3)) == 1) {
            return false;
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), IdeUtil.getIdeEncoding());
        out.write(this.content.toString());
        out.flush();
        out.close();
        return true;
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }
}

