/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.RSBusinessInfo;
import oracle.dbtools.crest.exports.reports.RSDataTypesModel;
import oracle.dbtools.crest.exports.reports.RSDesign;
import oracle.dbtools.crest.exports.reports.RSDiagrams;
import oracle.dbtools.crest.exports.reports.RSDomains;
import oracle.dbtools.crest.exports.reports.RSLogicalModel;
import oracle.dbtools.crest.exports.reports.RSLogicalTypes;
import oracle.dbtools.crest.exports.reports.RSMappings;
import oracle.dbtools.crest.exports.reports.RSMaskTemplates;
import oracle.dbtools.crest.exports.reports.RSMeasurements;
import oracle.dbtools.crest.exports.reports.RSMultidimensionalModel;
import oracle.dbtools.crest.exports.reports.RSProcessModel;
import oracle.dbtools.crest.exports.reports.RSRDBMSSites;
import oracle.dbtools.crest.exports.reports.RSRelationalModel;
import oracle.dbtools.crest.exports.reports.RSSensitiveTypes;
import oracle.dbtools.crest.exports.reports.RSTSDPPolicies;
import oracle.dbtools.crest.exports.reports.RSTSDPSubPolicies;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ReportsHandler {
    private ApplicationView appView;
    private ProgressDialog monitor;
    private Connection connection = null;
    private String comments;
    private Map map;
    private boolean exportDiagramsAsPDF = false;
    private Design design;
    private String reportsPath;
    private boolean clearDiagrams;
    private static final Logger LOGGER = new Logger(ReportsHandler.class);

    public ReportsHandler(ApplicationView view, Connection connection, String comments, boolean exportDiagramsAsPDF, boolean clearDiagrams) {
        this.appView = view;
        this.design = this.appView.getCurrentDesign();
        this.connection = connection;
        this.comments = comments;
        this.exportDiagramsAsPDF = exportDiagramsAsPDF;
        this.clearDiagrams = clearDiagrams;
        this.map = new TreeMap();
        this.reportsPath = this.appView.getSettings().getDefaultReportsPath();
        if (this.reportsPath.equals("") || this.reportsPath == null) {
            this.reportsPath = new File(ApplicationView.basePath, "reports").getAbsolutePath();
        }
        if (!this.hasPermissions(this.reportsPath)) {
            this.reportsPath = new File(this.appView.getUserHomeDirectory().getFile()).getAbsolutePath();
        }
    }

    public void export() {
        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean complete = false;
            this.monitor = new ProgressDialog(this.appView, "", 0, 100);
            try {
                this.monitor.setNote(Messages.getString("ReportsHandler.ConnectingDatabase"));
                this.monitor.setProgress(1);
                if (this.checkDB()) {
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingDesign"));
                    this.monitor.setProgress(5);
                    RSDesign.export(this.design, this.map, this.connection, this.comments);
                    RSRDBMSSites.export(this.design, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingLogicalTypes"));
                    this.monitor.setProgress(10);
                    RSLogicalTypes.export(this.design, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("RSBusinessInfo.ExportingSenssitiveTypes"));
                    RSSensitiveTypes.export(this.appView, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingDomains"));
                    this.monitor.setProgress(15);
                    RSDomains.export(this.design, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingDataTypesModel"));
                    this.monitor.setProgress(20);
                    RSDataTypesModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("RSBusinessInfo.ExportingTSDPPolicies"));
                    RSTSDPPolicies.export(this.appView, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("RSBusinessInfo.ExportingTSDPSubPolicies"));
                    RSTSDPSubPolicies.export(this.appView, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.MaskTemplates"));
                    RSMaskTemplates.export(this.appView, this.map, this.connection, this.design);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingLogicalModel"));
                    this.monitor.setProgress(25);
                    RSLogicalModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingRelationalModels"));
                    this.monitor.setProgress(35);
                    RSRelationalModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingMultidimensionalModel"));
                    this.monitor.setProgress(50);
                    RSMultidimensionalModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingProcessModel"));
                    this.monitor.setProgress(60);
                    RSProcessModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingDiagrams"));
                    this.monitor.setProgress(70);
                    RSDiagrams.export(this.design, this.map, this.connection, this.exportDiagramsAsPDF, this.reportsPath, this.clearDiagrams);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingMappings"));
                    this.monitor.setProgress(80);
                    RSMappings.export(this.design, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingBusinessInformation"));
                    this.monitor.setProgress(90);
                    RSBusinessInfo.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingMeasurements"));
                    this.monitor.setProgress(95);
                    RSMeasurements.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.CommitData"));
                    this.monitor.setProgress(99);
                    this.connection.setAutoCommit(false);
                    this.connection.commit();
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportComplete"));
                    this.monitor.setProgress(100);
                    complete = true;
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            finally {
                this.monitor.close();
            }
            if (complete) {
                this.appView.updateMainToolbar();
                MessageDialogs.showMessage(Messages.getString("ReportsHandler.DesignExportedSuccessfully"));
            }
        }
        catch (Exception e) {
            if (this.connection != null) {
                try {
                    this.connection.rollback();
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.appView.updateMainToolbar();
            if (e.toString().indexOf("ORA-01017") > -1) {
                LOGGER.error("Error Exporting to Reporting Schema: Error=" + e.getMessage());
                MessageDialogs.showErrorMessage(Messages.getString("ReportsHandler.ErrorUserPassword"), true);
            } else {
                LOGGER.error("Error Exporting to Reporting Schema: ", e);
                MessageDialogs.showErrorMessage(Messages.getString("ReportsHandler.ErrorSeeLogFile"), true);
            }
        }
        finally {
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDB() throws Exception {
        if (this.connection != null) {
            boolean autoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                float schemaVersion = SchemaFactory.schemaVersion(this.connection);
                if (schemaVersion == 0.0f) {
                    this.monitor.setNote(Messages.getString("ReportsHandler.SettingReportingSchema"));
                    this.monitor.setProgress(2);
                    boolean bl = SchemaFactory.createSchema(this.connection);
                    return bl;
                }
                if (schemaVersion != 1.6f) {
                    throw new DifferentVersionException();
                }
            }
            catch (DifferentVersionException dve) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ReportsHandler.SchemaVersionOutOfDate"), Messages.getString("ReportsHandler.Warning"), 2);
                boolean bl = false;
                return bl;
            }
            finally {
                this.connection.setAutoCommit(autoCommit);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPermissions(String path) {
        PrintWriter out = null;
        try {
            File f = new File(path + "/test.log");
            FileWriter outFile = new FileWriter(f);
            out = new PrintWriter(outFile);
            out.write("test");
            out.flush();
            out.close();
            out = null;
            f.delete();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("ReportsHandler.hasPermissions() " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
    }
}

