/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSTransformationTasks;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;

public class RSTransformationPackages
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<TransformationPackage> list = new ArrayList<TransformationPackage>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_TRANSFORMATION_PACKAGES (Transformation_Package_ID, Transformation_Package_OVID, Transformation_Package_Name, Model_ID, Model_OVID, Model_Name, System_Objective, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage transformPackage2 = (TransformationPackage)it.next();
            String transformPackageOVID = RSTransformationPackages.getOrCreateOVID(map, transformPackage2.getObjectID());
            stmt.setString(1, transformPackage2.getObjectID());
            stmt.setString(2, transformPackageOVID);
            stmt.setString(3, transformPackage2.getName());
            stmt.setString(4, processModel.getObjectID());
            stmt.setString(5, (String)map.get(processModel.getObjectID()));
            stmt.setString(6, processModel.getName());
            stmt.setString(7, transformPackage2.getSystemObjective());
            stmt.setString(8, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(transformPackage2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (TransformationPackage transformPackage2 : list) {
                RSComments.export(map, connection, transformPackage2);
                RSTransformationTasks.export(map, connection, transformPackage2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (TransformationPackage transformPackage : list) {
                RSComments.export(map, connection, transformPackage);
                RSTransformationTasks.export(map, connection, transformPackage);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

