/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSTaskParams
extends RSGeneral {
    public static void export(Map map, Connection connection, TransformationTask transformTask, InOutParams params2) throws Exception {
        ArrayList<InOutParams> list = new ArrayList<InOutParams>(1000);
        int count = 0;
        int count1 = 0;
        String query = "INSERT INTO DMRS_TASK_PARAMS (Task_Params_ID, Task_Params_OVID, Task_Params_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Task_Params_Type, Multiplicity, System_Objective, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String itemQuery = "INSERT INTO DMRS_TASK_PARAMS_ITEMS (Task_Params_Item_ID, Task_Params_Item_OVID, Task_Params_Item_Name, Task_Params_ID, Task_Params_OVID, Task_Params_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, Task_Params_Item_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        if (params2 != null) {
            String paramsOVID = RSTaskParams.getOrCreateOVID(map, params2.getObjectID());
            stmt.setString(1, params2.getObjectID());
            stmt.setString(2, paramsOVID);
            stmt.setString(3, params2.getName());
            stmt.setString(4, transformTask.getObjectID());
            stmt.setString(5, (String)map.get(transformTask.getObjectID()));
            stmt.setString(6, transformTask.getName());
            stmt.setString(7, params2.getInOutType());
            stmt.setString(8, params2.getParametersMultiplicity());
            stmt.setString(9, params2.getSystemObjective());
            stmt.setString(10, (String)map.get(transformTask.getDesign().getObjectID()));
            stmt.addBatch();
            list.add(params2);
            if (++count == 1000) {
                count = 0;
                stmt.executeBatch();
                for (InOutParams params2 : list) {
                    RSObjectNotes.export(map, connection, params2);
                    RSComments.export(map, connection, params2);
                }
                list.clear();
            }
            PreparedStatement itemStmt = connection.prepareStatement(itemQuery);
            for (ParameterObject item : params2.getParams()) {
                String itemOVID = RSTaskParams.getOrCreateOVID(map, item.getObjectID());
                itemStmt.setString(1, item.getObjectID());
                itemStmt.setString(2, itemOVID);
                itemStmt.setString(3, item.getName());
                itemStmt.setString(4, params2.getObjectID());
                itemStmt.setString(5, paramsOVID);
                itemStmt.setString(6, params2.getName());
                if (item.getLogicalDatatype() != null) {
                    itemStmt.setString(7, item.getLogicalDatatype().getObjectID());
                    itemStmt.setString(8, (String)map.get(item.getLogicalDatatype().getObjectID()));
                    itemStmt.setString(9, item.getLogicalDatatype().getName());
                } else {
                    itemStmt.setString(7, null);
                    itemStmt.setString(8, null);
                    itemStmt.setString(9, null);
                }
                itemStmt.setString(10, params2.getInOutType());
                itemStmt.setString(11, (String)map.get(transformTask.getDesign().getObjectID()));
                itemStmt.addBatch();
                if (++count1 != 1000) continue;
                count1 = 0;
                itemStmt.executeBatch();
            }
            if (count1 > 0) {
                count1 = 0;
                itemStmt.executeBatch();
            }
            itemStmt.close();
            itemStmt = null;
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (InOutParams params2 : list) {
                RSObjectNotes.export(map, connection, params2);
                RSComments.export(map, connection, params2);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

