/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class RSTableArcs
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<FKArc> list = new ArrayList<FKArc>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_TABLE_ARCS (Object_OVID, Object_ID, Arc_Name, Table_OVID, Table_ID, Mandatory, Discriminator_Column_ID, Model_Name, Model_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (RelationalDesign model : design.getRelationalDesigns()) {
            String modelOVID = (String)map.get(model.getObjectID());
            Iterator it = model.getArcSet().iterator();
            while (it.hasNext()) {
                FKArc fkArc2 = (FKArc)it.next();
                if (fkArc2.getTable() == null) continue;
                String ovid = RSTableArcs.getOrCreateOVID(map, fkArc2.getObjectID());
                stmt.setString(1, ovid);
                stmt.setString(2, fkArc2.getObjectID());
                stmt.setString(3, fkArc2.getName());
                stmt.setString(4, (String)map.get(fkArc2.getTable().getObjectID()));
                stmt.setString(5, fkArc2.getTable().getObjectID());
                stmt.setString(6, fkArc2.isMandatory() ? "Y" : "N");
                stmt.setString(7, fkArc2.getDiscriminatorColumn() != null ? fkArc2.getDiscriminatorColumn().getObjectID() : "");
                stmt.setString(8, model.getName());
                stmt.setString(9, modelOVID);
                stmt.setString(10, (String)map.get(design.getObjectID()));
                stmt.addBatch();
                list.add(fkArc2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (FKArc fkArc2 : list) {
                    RSObjectNotes.export(map, connection, fkArc2);
                    RSComments.export(map, connection, fkArc2);
                    RSCommentsInRDBMS.export(map, connection, fkArc2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (FKArc fkArc : list) {
                RSObjectNotes.export(map, connection, fkArc);
                RSComments.export(map, connection, fkArc);
                RSCommentsInRDBMS.export(map, connection, fkArc);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

