/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;

public class RSSpatialDimension
extends RSGeneral {
    public static void export(Map map, Connection connection, SpatialColumnDefObject sd) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_SPATIAL_DIMENSIONS (Definition_ID, Definition_OVID, Definition_Name, Dimension_Name, Low_Boundary, Upper_Boundary, Tolerance, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = sd.getTableDimensions().iterator();
        while (it.hasNext()) {
            String sdID = String.valueOf(sd.getId());
            SpatialColumnDefObject.TableDimension dimension = (SpatialColumnDefObject.TableDimension)it.next();
            stmt.setString(1, sdID);
            stmt.setString(2, (String)map.get(sdID));
            stmt.setString(3, sd.getName());
            stmt.setString(4, dimension.getName());
            stmt.setString(5, dimension.getLowBoundary());
            stmt.setString(6, dimension.getUpperBoundary());
            stmt.setString(7, dimension.getTolerance());
            stmt.setString(8, (String)map.get(sd.getParent().getDesign().getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

