/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;

public class RSSourceTargetMappings
extends RSGeneral {
    public static void export(Map map, Connection connection, ModelIDObject designObject) throws Exception {
        int count = 0;
        ArrayList<TargetElement> srcCollection = new ArrayList<TargetElement>();
        String tgtQuery = "INSERT INTO DMRS_MAPPING_TARGETS (Object_ID, Object_OVID, Object_Name, Target_ID, Target_OVID, Target_Name, Object_Type, Target_Type, Transformation_Type, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement tgtStmt = connection.prepareStatement(tgtQuery);
        if (designObject instanceof Process || designObject instanceof Transformation) {
            Iterator tgtIter;
            String designOVID = (String)map.get(designObject.getDesign().getObjectID());
            String desObjOVID = (String)map.get(designObject.getObjectID());
            if (designObject instanceof Process) {
                ((Process)designObject).updateTargetElements();
                tgtIter = ((Process)designObject).getTargetElements().iterator();
            } else {
                ((Transformation)designObject).updateTargetElements();
                tgtIter = ((Transformation)designObject).getTargetElements().iterator();
            }
            while (tgtIter.hasNext()) {
                TargetElement tgtElem = (TargetElement)tgtIter.next();
                DesignObject tgt = tgtElem.getTarget();
                String tgtOVID = RSSourceTargetMappings.getOrCreateOVID(map, tgt.getObjectID());
                srcCollection.add(tgtElem);
                tgtStmt.setString(1, designObject.getObjectID());
                tgtStmt.setString(2, desObjOVID);
                tgtStmt.setString(3, designObject.getName());
                tgtStmt.setString(4, tgt.getObjectID());
                tgtStmt.setString(5, tgtOVID);
                tgtStmt.setString(6, tgt.getName());
                tgtStmt.setString(7, designObject.getObjectTypeName());
                tgtStmt.setString(8, tgt.getObjectTypeName());
                tgtStmt.setString(9, tgtElem.getTransformationType());
                tgtStmt.setString(10, tgtElem.getDescription());
                tgtStmt.setString(11, designOVID);
                tgtStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                tgtStmt.executeBatch();
            }
            RSSourceTargetMappings.exportSources(map, connection, srcCollection, designOVID, desObjOVID, designObject);
        }
        if (count > 0) {
            count = 0;
            tgtStmt.executeBatch();
        }
        tgtStmt.close();
        tgtStmt = null;
    }

    private static void exportSources(Map map, Connection connection, List elements, String designOVID, String desObjOVID, ModelIDObject designObject) throws Exception {
        int count = 0;
        String srcQuery = "INSERT INTO DMRS_MAPPING_TARGET_SOURCES (Object_ID, Object_OVID, Object_Name, Target_ID, Target_OVID, Target_Name, Source_ID, Source_OVID, Source_Name, Object_Type, Target_Type, Source_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement srcStmt = connection.prepareStatement(srcQuery);
        for (TargetElement tgtElem : elements) {
            DesignObject tgt = tgtElem.getTarget();
            for (DesignObject src : tgtElem.getSources()) {
                String srcOVID = RSSourceTargetMappings.getOrCreateOVID(map, src.getObjectID());
                srcStmt.setString(1, designObject.getObjectID());
                srcStmt.setString(2, desObjOVID);
                srcStmt.setString(3, designObject.getName());
                srcStmt.setString(4, tgt.getObjectID());
                srcStmt.setString(5, (String)map.get(tgt.getObjectID()));
                srcStmt.setString(6, tgt.getName());
                srcStmt.setString(7, src.getObjectID());
                srcStmt.setString(8, srcOVID);
                srcStmt.setString(9, src.getName());
                srcStmt.setString(10, designObject.getObjectTypeName());
                srcStmt.setString(11, tgt.getObjectTypeName());
                srcStmt.setString(12, src.getObjectTypeName());
                srcStmt.setString(13, designOVID);
                srcStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                srcStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            srcStmt.executeBatch();
        }
        srcStmt.close();
        srcStmt = null;
    }
}

