/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;

public class RSResourceLocators
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<BIResourceLocator> list = new ArrayList<BIResourceLocator>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_RESOURCE_LOCATORS (Resource_Locator_ID, Resource_Locator_OVID, Resource_Locator_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Url, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        BusinessInfoDesign info = design.getBusinessInfoDesign();
        String designOVID = (String)map.get(design.getObjectID());
        String infoOVID = (String)map.get(design.getObjectID());
        Iterator it = info.getUrlSet().iterator();
        while (it.hasNext()) {
            BIResourceLocator url2 = (BIResourceLocator)it.next();
            String urlOVID = RSResourceLocators.getOrCreateOVID(map, url2.getObjectID());
            stmt.setString(1, url2.getObjectID());
            stmt.setString(2, urlOVID);
            stmt.setString(3, url2.getName());
            stmt.setString(4, info.getObjectID());
            stmt.setString(5, infoOVID);
            stmt.setString(6, info.getName());
            stmt.setString(7, url2.getUrl());
            stmt.setString(8, designOVID);
            stmt.addBatch();
            list.add(url2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (BIResourceLocator url2 : list) {
                RSComments.export(map, connection, url2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (BIResourceLocator url : list) {
                RSComments.export(map, connection, url);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

