/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.relational.Column;

public class RSLevels
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Level> list = new ArrayList<Level>(1000);
        int count = 0;
        ArrayList<Level> levelsCollection = new ArrayList<Level>();
        String query = "INSERT INTO DMRS_LEVELS (Level_ID, Level_Name, Level_OVID, Model_ID, Model_Name, Model_OVID, Entity_ID, Entity_Name, Entity_OVID, Name_Column_ID, Name_Column_Name, Name_Column_OVID, Value_Column_ID, Value_Column_Name, Value_Column_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Root_Identification, Identification_Value, Selection_Criteria, Selection_Criteria_Description, Is_Value_Based_Hierarchy, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (MultidimensionalDesign model : design.getMultidimensionalDesigns()) {
            String modelOVID = (String)map.get(model.getObjectID());
            String designOVID = (String)map.get(model.getDesign().getObjectID());
            levelsCollection.clear();
            Iterator it = model.getLevelSet().iterator();
            while (it.hasNext()) {
                Level level2 = (Level)it.next();
                String levelOVID = RSLevels.getOrCreateOVID(map, level2.getObjectID());
                levelsCollection.add(level2);
                ContainerObject obj = level2.getLevelEntity();
                ContainedObject nameCol = level2.getNameColumn();
                ContainedObject valueCol = level2.getValueColumn();
                stmt.setString(1, level2.getObjectID());
                stmt.setString(2, level2.getName());
                stmt.setString(3, levelOVID);
                stmt.setString(4, model.getObjectID());
                stmt.setString(5, model.getName());
                stmt.setString(6, modelOVID);
                if (obj != null && obj instanceof Entity) {
                    stmt.setString(7, obj.getObjectID());
                    stmt.setString(8, obj.getName());
                    stmt.setString(9, RSLevels.getOrCreateOVID(map, obj.getObjectID()));
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                if (nameCol != null && nameCol instanceof Column) {
                    stmt.setString(10, nameCol.getObjectID());
                    stmt.setString(11, nameCol.getName());
                    stmt.setString(12, RSLevels.getOrCreateOVID(map, nameCol.getObjectID()));
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                }
                if (valueCol != null && valueCol instanceof Column) {
                    stmt.setString(13, valueCol.getObjectID());
                    stmt.setString(14, valueCol.getName());
                    stmt.setString(15, RSLevels.getOrCreateOVID(map, valueCol.getObjectID()));
                } else {
                    stmt.setString(13, null);
                    stmt.setString(14, null);
                    stmt.setString(15, null);
                }
                stmt.setString(16, level2.getOracleLongName());
                stmt.setString(17, level2.getOraclePluralName());
                stmt.setString(18, level2.getOracleShortName());
                stmt.setString(19, level2.getRootIdentification());
                stmt.setString(20, level2.getIdentificationValue());
                stmt.setString(21, level2.getSelectionCriteria());
                stmt.setString(22, level2.getSelectionCriteriaDescription());
                stmt.setString(23, level2.isValueBasedHierarchy() ? "Y" : "N");
                stmt.setString(24, level2.getDescription());
                stmt.setString(25, designOVID);
                stmt.addBatch();
                list.add(level2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Level level2 : list) {
                    RSObjectNotes.export(map, connection, level2);
                    RSComments.export(map, connection, level2);
                    RSDynamicProperties.export(design, map, connection, level2);
                }
                list.clear();
            }
            RSLevels.exportAttributes(map, connection, levelsCollection, designOVID);
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Level level : list) {
                RSObjectNotes.export(map, connection, level);
                RSComments.export(map, connection, level);
                RSDynamicProperties.export(design, map, connection, level);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportAttributes(Map map, Connection connection, List levels, String designOVID) throws Exception {
        String attrQuery = "INSERT INTO DMRS_LEVEL_ATTRS (Level_ID, Level_Name, Level_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Is_Default_Attr, Is_Level_Key_Attr, Is_Parent_Key_Attr, Is_Descriptive_Key_Attr, Is_Calculated_Attr, Descriptive_Name, Descriptive_Is_Indexed, Descriptive_Slow_Changing, Calculated_Expr, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement attrStmt = connection.prepareStatement(attrQuery);
        String setLevelKeyQuery = "UPDATE DMRS_LEVEL_ATTRS SET Is_Level_Key_Attr = 'Y' WHERE Level_OVID = ? AND Attribute_OVID = ? ";
        PreparedStatement setLevelKeyStmt = connection.prepareStatement(setLevelKeyQuery);
        String setParKeyQuery = "UPDATE DMRS_LEVEL_ATTRS SET Is_Parent_Key_Attr = 'Y' WHERE Level_OVID = ? AND Attribute_OVID = ? ";
        PreparedStatement setParKeyStmt = connection.prepareStatement(setParKeyQuery);
        String setDescKeyQuery = "UPDATE DMRS_LEVEL_ATTRS SET Is_Descriptive_Key_Attr = 'Y', Descriptive_Name = ?, Descriptive_Is_Indexed = ?, Descriptive_Slow_Changing = ? WHERE Level_OVID = ? AND Attribute_OVID = ? ";
        PreparedStatement setDescKeyStmt = connection.prepareStatement(setDescKeyQuery);
        ArrayList<String> attrs = new ArrayList<String>();
        for (Level level : levels) {
            String levelOVID = (String)map.get(level.getObjectID());
            DesignObject defObj = level.getDefaultAttribute();
            if (defObj != null && defObj instanceof Attribute) {
                String defAttrOVID = (String)map.get(defObj.getObjectID());
                attrStmt.setString(1, level.getObjectID());
                attrStmt.setString(2, level.getName());
                attrStmt.setString(3, levelOVID);
                attrStmt.setString(4, defObj.getObjectID());
                attrStmt.setString(5, defObj.getName());
                attrStmt.setString(6, defAttrOVID);
                attrStmt.setString(7, "Y");
                attrStmt.setString(8, "N");
                attrStmt.setString(9, "N");
                attrStmt.setString(10, "N");
                attrStmt.setString(11, "N");
                attrStmt.setString(12, null);
                attrStmt.setString(13, null);
                attrStmt.setString(14, null);
                attrStmt.setString(15, null);
                attrStmt.setString(16, designOVID);
                attrStmt.executeUpdate();
            }
            for (ContainedObject levelKeyObj : level.getLevelKey()) {
                if (!(levelKeyObj instanceof Attribute)) continue;
                String levelKeyAttrOVID = (String)map.get(levelKeyObj.getObjectID());
                String levelKeyAttrTag = levelOVID + levelKeyAttrOVID;
                if (attrs.contains(levelKeyAttrTag)) {
                    setLevelKeyStmt.setString(1, levelOVID);
                    setLevelKeyStmt.setString(2, levelKeyAttrOVID);
                    setLevelKeyStmt.executeUpdate();
                    continue;
                }
                attrStmt.setString(1, level.getObjectID());
                attrStmt.setString(2, level.getName());
                attrStmt.setString(3, levelOVID);
                attrStmt.setString(4, levelKeyObj.getObjectID());
                attrStmt.setString(5, levelKeyObj.getName());
                attrStmt.setString(6, levelKeyAttrOVID);
                attrStmt.setString(7, "N");
                attrStmt.setString(8, "Y");
                attrStmt.setString(9, "N");
                attrStmt.setString(10, "N");
                attrStmt.setString(11, "N");
                attrStmt.setString(12, null);
                attrStmt.setString(13, null);
                attrStmt.setString(14, null);
                attrStmt.setString(15, null);
                attrStmt.setString(16, designOVID);
                attrStmt.executeUpdate();
                attrs.add(levelKeyAttrTag);
            }
            for (ContainedObject parKeyObj : level.getParentKey()) {
                if (!(parKeyObj instanceof Attribute)) continue;
                String parKeyAttrOVID = (String)map.get(parKeyObj.getObjectID());
                String parKeyAttrTag = levelOVID + parKeyAttrOVID;
                if (attrs.contains(parKeyAttrTag)) {
                    setParKeyStmt.setString(1, levelOVID);
                    setParKeyStmt.setString(2, parKeyAttrOVID);
                    setParKeyStmt.executeUpdate();
                    continue;
                }
                attrStmt.setString(1, level.getObjectID());
                attrStmt.setString(2, level.getName());
                attrStmt.setString(3, levelOVID);
                attrStmt.setString(4, parKeyObj.getObjectID());
                attrStmt.setString(5, parKeyObj.getName());
                attrStmt.setString(6, parKeyAttrOVID);
                attrStmt.setString(7, "N");
                attrStmt.setString(8, "N");
                attrStmt.setString(9, "Y");
                attrStmt.setString(10, "N");
                attrStmt.setString(11, "N");
                attrStmt.setString(12, null);
                attrStmt.setString(13, null);
                attrStmt.setString(14, null);
                attrStmt.setString(15, null);
                attrStmt.setString(16, designOVID);
                attrStmt.executeUpdate();
                attrs.add(parKeyAttrTag);
            }
            for (SlowChangingAttribute slowAttr : level.getSlowChangingAttributes()) {
                ContainedObject descKeyObj = slowAttr.getAttribute();
                if (descKeyObj != null) {
                    String descKeyAttrOVID = (String)map.get(descKeyObj.getObjectID());
                    String descKeyAttrTag = levelOVID + descKeyAttrOVID;
                    if (attrs.contains(descKeyAttrTag)) {
                        setDescKeyStmt.setString(1, slowAttr.getName());
                        setDescKeyStmt.setString(2, slowAttr.isIndexed() ? "Y" : "N");
                        setDescKeyStmt.setString(3, slowAttr.getType());
                        setDescKeyStmt.setString(4, levelOVID);
                        setDescKeyStmt.setString(5, descKeyAttrOVID);
                        setDescKeyStmt.executeUpdate();
                        continue;
                    }
                    attrStmt.setString(1, level.getObjectID());
                    attrStmt.setString(2, level.getName());
                    attrStmt.setString(3, levelOVID);
                    attrStmt.setString(4, descKeyObj.getObjectID());
                    attrStmt.setString(5, descKeyObj.getName());
                    attrStmt.setString(6, descKeyAttrOVID);
                    attrStmt.setString(7, "N");
                    attrStmt.setString(8, "N");
                    attrStmt.setString(9, "N");
                    attrStmt.setString(10, "Y");
                    attrStmt.setString(11, "N");
                    attrStmt.setString(12, slowAttr.getName());
                    attrStmt.setString(13, slowAttr.isIndexed() ? "Y" : "N");
                    attrStmt.setString(14, slowAttr.getType());
                    attrStmt.setString(15, null);
                    attrStmt.setString(16, designOVID);
                    attrStmt.executeUpdate();
                    attrs.add(descKeyAttrTag);
                    continue;
                }
                attrStmt.setString(1, level.getObjectID());
                attrStmt.setString(2, level.getName());
                attrStmt.setString(3, levelOVID);
                attrStmt.setString(4, null);
                attrStmt.setString(5, null);
                attrStmt.setString(6, null);
                attrStmt.setString(7, "N");
                attrStmt.setString(8, "N");
                attrStmt.setString(9, "N");
                attrStmt.setString(10, "Y");
                attrStmt.setString(11, "N");
                attrStmt.setString(12, slowAttr.getName());
                attrStmt.setString(13, slowAttr.isIndexed() ? "Y" : "N");
                attrStmt.setString(14, slowAttr.getType());
                attrStmt.setString(15, null);
                attrStmt.setString(16, designOVID);
                attrStmt.executeUpdate();
            }
            for (CalculatedAttribute calcAttr : level.getCalculatedAttributes()) {
                String calcAttrOVID = RSLevels.getOrCreateOVID(map, calcAttr.getObjectID());
                attrStmt.setString(1, level.getObjectID());
                attrStmt.setString(2, level.getName());
                attrStmt.setString(3, levelOVID);
                attrStmt.setString(4, calcAttr.getObjectID());
                attrStmt.setString(5, calcAttr.getName());
                attrStmt.setString(6, calcAttrOVID);
                attrStmt.setString(7, "N");
                attrStmt.setString(8, "N");
                attrStmt.setString(9, "N");
                attrStmt.setString(10, "N");
                attrStmt.setString(11, "Y");
                attrStmt.setString(12, null);
                attrStmt.setString(13, null);
                attrStmt.setString(14, null);
                attrStmt.setString(15, calcAttr.getFunction());
                attrStmt.setString(16, designOVID);
                attrStmt.executeUpdate();
            }
        }
        setDescKeyStmt.close();
        setDescKeyStmt = null;
        setParKeyStmt.close();
        setParKeyStmt = null;
        setLevelKeyStmt.close();
        setLevelKeyStmt = null;
        attrStmt.close();
        attrStmt = null;
    }
}

