/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.CandidateKey;

public class RSKeysAttributes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, CandidateKey key) throws Exception {
        ArrayList list = new ArrayList(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_KEY_ATTRIBUTES (Key_ID, Key_OVID, Attribute_ID, Attribute_OVID, Entity_ID, Entity_OVID, Key_Name, Entity_Name, Attribute_Name, Sequence, Relationship_ID, Relationship_OVID, Relationship_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = key.getElementsCollection().iterator();
        int seq = 0;
        while (it.hasNext()) {
            ++seq;
            ContainedObject attribute = (ContainedObject)it.next();
            String attrOVID = (String)map.get(attribute.getObjectID());
            stmt.setString(1, key.getObjectID());
            stmt.setString(2, (String)map.get(key.getObjectID()));
            stmt.setString(3, attribute.getObjectID());
            stmt.setString(4, attrOVID);
            stmt.setString(5, attribute.getContainer().getObjectID());
            stmt.setString(6, (String)map.get(attribute.getContainer().getObjectID()));
            stmt.setString(7, key.getName());
            stmt.setString(8, attribute.getContainer().getName());
            stmt.setString(9, attribute.getName());
            stmt.setInt(10, seq);
            stmt.setString(11, attribute.isFKElement() ? attribute.getGenerator().getObjectID() : null);
            stmt.setString(12, attribute.isFKElement() ? RSKeysAttributes.getOrCreateOVID(map, attribute.getGenerator().getObjectID()) : null);
            stmt.setString(13, attribute.isFKElement() ? attribute.getGenerator().getName() : null);
            stmt.setString(14, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

