/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSInfoStructureAttributes;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSInfoStructures
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        String query = "INSERT INTO DMRS_INFO_STRUCTURES (Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Model_ID, Model_OVID, Model_Name, Growth_Rate_Unit, Growth_Rate_Percent, Volume, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ArrayList<InfoStructure> list = new ArrayList<InfoStructure>(1000);
        int count = 0;
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getInfoStructureSet().iterator();
        while (it.hasNext()) {
            InfoStructure info2 = (InfoStructure)it.next();
            String infoOVID = RSInfoStructures.getOrCreateOVID(map, info2.getObjectID());
            stmt.setString(1, info2.getObjectID());
            stmt.setString(2, infoOVID);
            stmt.setString(3, info2.getName());
            stmt.setString(4, processModel.getObjectID());
            stmt.setString(5, (String)map.get(processModel.getObjectID()));
            stmt.setString(6, processModel.getName());
            stmt.setString(7, info2.getGrowthRateUnit());
            stmt.setInt(8, info2.getGrowthRatePercent());
            stmt.setInt(9, info2.getVolume());
            stmt.setString(10, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(info2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (InfoStructure info2 : list) {
                RSInfoStructureAttributes.export(design, map, connection, info2);
                RSObjectNotes.export(map, connection, info2);
                RSComments.export(map, connection, info2);
                RSDynamicProperties.export(design, map, connection, info2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (InfoStructure info : list) {
                RSInfoStructureAttributes.export(design, map, connection, info);
                RSObjectNotes.export(map, connection, info);
                RSComments.export(map, connection, info);
                RSDynamicProperties.export(design, map, connection, info);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

