/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSExternalAgents
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<ExternalAgent> list = new ArrayList<ExternalAgent>(1000);
        int count = 0;
        ArrayList<ExternalAgent> agentsCollection = new ArrayList<ExternalAgent>();
        String query = "INSERT INTO DMRS_EXTERNAL_AGENTS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, Diagram_ID, Diagram_OVID, Diagram_Name, External_Agent_Type, File_Location, File_Source, File_Name, File_Type, File_Owner, Data_Capture_Type, Field_Separator, Text_Delimiter, Skip_Records, Self_Describing, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        String designOVID = (String)map.get(design.getObjectID());
        ProcessModel processModel = design.getProcessModel();
        for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
            String dfdOVID = (String)map.get(dfd.getObjectID());
            Iterator ait = dfd.getExternalAgentSet().iterator();
            agentsCollection.clear();
            while (ait.hasNext()) {
                ExternalAgent agent2 = (ExternalAgent)ait.next();
                String agentOVID = RSExternalAgents.getOrCreateOVID(map, agent2.getObjectID());
                agentsCollection.add(agent2);
                stmt.setString(1, agent2.getObjectID());
                stmt.setString(2, agentOVID);
                stmt.setString(3, agent2.getName());
                stmt.setString(4, dfd.getObjectID());
                stmt.setString(5, dfdOVID);
                stmt.setString(6, !"".equals(dfd.getName()) ? dfd.getName() : dfd.getObjectTypeName());
                if (agent2.getType() == 0) {
                    stmt.setString(7, "Organizational Unit");
                } else if (agent2.getType() == 1) {
                    stmt.setString(7, "System");
                } else if (agent2.getType() == 2) {
                    stmt.setString(7, "Role");
                } else {
                    stmt.setString(7, "Other");
                }
                stmt.setString(8, agent2.getLocation());
                stmt.setString(9, agent2.getSource());
                stmt.setString(10, agent2.getFileName());
                stmt.setString(11, agent2.getFileType());
                stmt.setString(12, agent2.getOwner());
                stmt.setString(13, agent2.getTransferType());
                stmt.setString(14, agent2.getFieldSeparator());
                stmt.setString(15, agent2.getTextDelimiter());
                stmt.setInt(16, agent2.getSkipRecords());
                stmt.setString(17, agent2.isSelfDescribing() ? "Y" : "N");
                stmt.setString(18, designOVID);
                stmt.addBatch();
                list.add(agent2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (ExternalAgent agent2 : list) {
                    RSObjectNotes.export(map, connection, agent2);
                    RSComments.export(map, connection, agent2);
                }
                list.clear();
            }
            RSExternalAgents.exportFlows(map, connection, agentsCollection, designOVID);
            RSExternalAgents.exportRelationships(map, connection, agentsCollection, designOVID);
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (ExternalAgent agent : list) {
                RSObjectNotes.export(map, connection, agent);
                RSComments.export(map, connection, agent);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportFlows(Map map, Connection connection, List agents, String designOVID) throws Exception {
        int count1 = 0;
        String flowQuery = "INSERT INTO DMRS_EXT_AGENT_FLOWS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, Flow_ID, Flow_OVID, Flow_Name, Incoming_Outgoing_Flag, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement flowStmt = connection.prepareStatement(flowQuery);
        for (ExternalAgent agent : agents) {
            for (Flow inFlow : agent.getIncomingFlows()) {
                String inFlowOVID = (String)map.get(inFlow.getObjectID());
                flowStmt.setString(1, agent.getObjectID());
                flowStmt.setString(2, (String)map.get(agent.getObjectID()));
                flowStmt.setString(3, agent.getName());
                flowStmt.setString(4, inFlow.getObjectID());
                flowStmt.setString(5, inFlowOVID);
                flowStmt.setString(6, inFlow.getName());
                flowStmt.setString(7, "I");
                flowStmt.setString(8, designOVID);
                flowStmt.addBatch();
                if (++count1 != 1000) continue;
                count1 = 0;
                flowStmt.executeBatch();
            }
            if (count1 > 0) {
                count1 = 0;
                flowStmt.executeBatch();
            }
            for (Flow outFlow : agent.getOutgoingFlows()) {
                String outFlowOVID = (String)map.get(outFlow.getObjectID());
                flowStmt.setString(1, agent.getObjectID());
                flowStmt.setString(2, (String)map.get(agent.getObjectID()));
                flowStmt.setString(3, agent.getName());
                flowStmt.setString(4, outFlow.getObjectID());
                flowStmt.setString(5, outFlowOVID);
                flowStmt.setString(6, outFlow.getName());
                flowStmt.setString(7, "O");
                flowStmt.setString(8, designOVID);
                flowStmt.addBatch();
                if (++count1 != 1000) continue;
                count1 = 0;
                flowStmt.executeBatch();
            }
            if (count1 <= 0) continue;
            count1 = 0;
            flowStmt.executeBatch();
        }
        flowStmt.close();
        flowStmt = null;
    }

    private static void exportRelationships(Map map, Connection connection, List agents, String designOVID) throws Exception {
        int count1 = 0;
        String dataQuery = "INSERT INTO DMRS_EXT_AGENT_EXT_DATAS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, External_Data_ID, External_Data_OVID, External_Data_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement dataStmt = connection.prepareStatement(dataQuery);
        for (ExternalAgent agent : agents) {
            for (ExternalData data : agent.getExternalDatas()) {
                String dataOVID = (String)map.get(data.getObjectID());
                dataStmt.setString(1, agent.getObjectID());
                dataStmt.setString(2, (String)map.get(agent.getObjectID()));
                dataStmt.setString(3, agent.getName());
                dataStmt.setString(4, data.getObjectID());
                dataStmt.setString(5, dataOVID);
                dataStmt.setString(6, data.getName());
                dataStmt.setString(7, designOVID);
                dataStmt.addBatch();
                if (++count1 != 1000) continue;
                count1 = 0;
                dataStmt.executeBatch();
            }
        }
        if (count1 > 0) {
            count1 = 0;
            dataStmt.executeBatch();
        }
        dataStmt.close();
        dataStmt = null;
    }
}

