/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;

public class RSCubes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        String query = "INSERT INTO DMRS_CUBES (Cube_ID, Cube_Name, Cube_OVID, Model_ID, Model_Name, Model_OVID, Part_Dimension_ID, Part_Dimension_Name, Part_Dimension_OVID, Part_Hierarchy_ID, Part_Hierarchy_Name, Part_Hierarchy_OVID, Part_Level_ID, Part_Level_Name, Part_Level_OVID, Full_Cube_Slice_ID, Full_Cube_Slice_Name, Full_Cube_Slice_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Compressed_Composites, Is_Global_Composites, Is_Partitioned, Is_Virtual, Part_Description, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        String dimQuery = "INSERT INTO DMRS_CUBE_DIMENSIONS (Cube_ID, Cube_Name, Cube_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement dimStmt = connection.prepareStatement(dimQuery);
        String entQuery = "INSERT INTO DMRS_FACT_ENTITIES (Cube_ID, Cube_Name, Cube_OVID, Entity_ID, Entity_Name, Entity_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement entStmt = connection.prepareStatement(entQuery);
        String joinQuery = "INSERT INTO DMRS_FACT_ENTITIES_JOINS (Join_ID, Join_Name, Join_OVID, Cube_ID, Cube_Name, Cube_OVID, Left_Entity_ID, Left_Entity_Name, Left_Entity_OVID, Right_Entity_ID, Right_Entity_Name, Right_Entity_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement joinStmt = connection.prepareStatement(joinQuery);
        for (MultidimensionalDesign model : design.getMultidimensionalDesigns()) {
            String modelOVID = (String)map.get(model.getObjectID());
            String designOVID = (String)map.get(model.getDesign().getObjectID());
            Iterator it = model.getCubeSet().iterator();
            while (it.hasNext()) {
                Cube cube = (Cube)it.next();
                String cubeOVID = RSCubes.getOrCreateOVID(map, cube.getObjectID());
                Dimension partDim = cube.getPartDimension();
                Hierarchy partHier = cube.getPartHierarchy();
                Level partLev = cube.getPartLevel();
                Slice fullSlice = cube.getFullCubeMaterialization();
                stmt.setString(1, cube.getObjectID());
                stmt.setString(2, cube.getName());
                stmt.setString(3, cubeOVID);
                stmt.setString(4, model.getObjectID());
                stmt.setString(5, model.getName());
                stmt.setString(6, modelOVID);
                if (partDim != null) {
                    stmt.setString(7, partDim.getObjectID());
                    stmt.setString(8, partDim.getName());
                    stmt.setString(9, RSCubes.getOrCreateOVID(map, partDim.getObjectID()));
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                if (partHier != null) {
                    stmt.setString(10, partHier.getObjectID());
                    stmt.setString(11, partHier.getName());
                    stmt.setString(12, RSCubes.getOrCreateOVID(map, partHier.getObjectID()));
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                }
                if (partLev != null) {
                    stmt.setString(13, partLev.getObjectID());
                    stmt.setString(14, partLev.getName());
                    stmt.setString(15, RSCubes.getOrCreateOVID(map, partLev.getObjectID()));
                } else {
                    stmt.setString(13, null);
                    stmt.setString(14, null);
                    stmt.setString(15, null);
                }
                if (fullSlice != null) {
                    stmt.setString(16, fullSlice.getObjectID());
                    stmt.setString(17, fullSlice.getName());
                    stmt.setString(18, RSCubes.getOrCreateOVID(map, fullSlice.getObjectID()));
                } else {
                    stmt.setString(16, null);
                    stmt.setString(17, null);
                    stmt.setString(18, null);
                }
                stmt.setString(19, cube.getOracleLongName());
                stmt.setString(20, cube.getOraclePluralName());
                stmt.setString(21, cube.getOracleShortName());
                stmt.setString(22, cube.isCompressedComposites() ? "Y" : "N");
                stmt.setString(23, cube.isUseGlobalComposites() ? "Y" : "N");
                stmt.setString(24, cube.isPartitioned() ? "Y" : "N");
                stmt.setString(25, cube.isVirtual() ? "Y" : "N");
                stmt.setString(26, cube.getPartitioningDescription());
                stmt.setString(27, cube.getDescription());
                stmt.setString(28, designOVID);
                stmt.executeUpdate();
                RSObjectNotes.export(map, connection, cube);
                RSComments.export(map, connection, cube);
                RSDynamicProperties.export(design, map, connection, cube);
                for (Dimension dim : cube.getDimensions()) {
                    String dimOVID = RSCubes.getOrCreateOVID(map, dim.getObjectID());
                    dimStmt.setString(1, cube.getObjectID());
                    dimStmt.setString(2, cube.getName());
                    dimStmt.setString(3, cubeOVID);
                    dimStmt.setString(4, dim.getObjectID());
                    dimStmt.setString(5, dim.getName());
                    dimStmt.setString(6, dimOVID);
                    dimStmt.setString(7, designOVID);
                    dimStmt.executeUpdate();
                }
                for (ContainerObject obj : cube.getFactEntities()) {
                    if (!(obj instanceof Entity)) continue;
                    String entOVID = (String)map.get(obj.getObjectID());
                    entStmt.setString(1, cube.getObjectID());
                    entStmt.setString(2, cube.getName());
                    entStmt.setString(3, cubeOVID);
                    entStmt.setString(4, obj.getObjectID());
                    entStmt.setString(5, obj.getName());
                    entStmt.setString(6, entOVID);
                    entStmt.setString(7, designOVID);
                    entStmt.executeUpdate();
                }
                for (FactEntitiesJoin join : cube.getJoins()) {
                    String joinOVID = RSCubes.getOrCreateOVID(map, join.getObjectID());
                    Entity leftEnt = join.getLeftEntity();
                    Entity rightEnt = join.getRightEntity();
                    joinStmt.setString(1, join.getObjectID());
                    joinStmt.setString(2, join.getName());
                    joinStmt.setString(3, joinOVID);
                    joinStmt.setString(4, cube.getObjectID());
                    joinStmt.setString(5, cube.getName());
                    joinStmt.setString(6, cubeOVID);
                    if (leftEnt != null) {
                        joinStmt.setString(7, leftEnt.getObjectID());
                        joinStmt.setString(8, leftEnt.getName());
                        joinStmt.setString(9, (String)map.get(leftEnt.getObjectID()));
                    } else {
                        joinStmt.setString(7, null);
                        joinStmt.setString(8, null);
                        joinStmt.setString(9, null);
                    }
                    if (rightEnt != null) {
                        joinStmt.setString(10, rightEnt.getObjectID());
                        joinStmt.setString(11, rightEnt.getName());
                        joinStmt.setString(12, (String)map.get(rightEnt.getObjectID()));
                    } else {
                        joinStmt.setString(10, null);
                        joinStmt.setString(11, null);
                        joinStmt.setString(12, null);
                    }
                    joinStmt.setString(13, designOVID);
                    joinStmt.executeUpdate();
                }
            }
        }
        joinStmt.close();
        joinStmt = null;
        entStmt.close();
        entStmt = null;
        dimStmt.close();
        dimStmt = null;
        stmt.close();
        stmt = null;
    }
}

