/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class RSCheckConstraint
extends RSGeneral {
    public static void export(Connection connection, List elements, Map map, String type) throws Exception {
        ArrayList list = new ArrayList(1000);
        int count = 0;
        boolean count1 = false;
        String query = "INSERT INTO DMRS_CHECK_CONSTRAINTS (DataElement_ID, DataElement_OVID, Type, Sequence, Constraint_Name, Text, Database_Type, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (ContainedObject element : elements) {
            CheckConstraint check = element.getCheck();
            int seq = 0;
            if (check == null) continue;
            String generic = check.getGenericConstraint();
            if (generic != null && !"".equalsIgnoreCase(generic)) {
                stmt.setString(1, element.getObjectID());
                stmt.setString(2, (String)map.get(element.getObjectID()));
                stmt.setString(3, type);
                stmt.setInt(4, ++seq);
                stmt.setString(5, check.getName());
                stmt.setString(6, generic);
                stmt.setString(7, "GENERIC");
                stmt.setString(8, element.getContainer().getObjectID());
                stmt.setString(9, (String)map.get(element.getObjectID()));
                stmt.setString(10, element.getContainer().getName());
                stmt.setString(11, element.getName());
                stmt.setString(12, (String)map.get(element.getDesign().getObjectID()));
                stmt.addBatch();
                if (++count == 1000) {
                    count = 0;
                    stmt.executeBatch();
                }
            }
            Object[] types = check.getTypes();
            for (int i = 0; i < types.length; ++i) {
                RDBMSType rdbmsType = (RDBMSType)types[i];
                String text = check.getImplementationFor(rdbmsType);
                if (text == null || "".equalsIgnoreCase(text)) continue;
                stmt.setString(1, element.getObjectID());
                stmt.setString(2, (String)map.get(element.getObjectID()));
                stmt.setString(3, type);
                stmt.setInt(4, ++seq);
                stmt.setString(5, check.getName());
                stmt.setString(6, text);
                stmt.setString(7, rdbmsType.getName());
                stmt.setString(8, element.getContainer().getObjectID());
                stmt.setString(9, (String)map.get(element.getObjectID()));
                stmt.setString(10, element.getContainer().getName());
                stmt.setString(11, element.getName());
                stmt.setString(12, (String)map.get(element.getDesign().getObjectID()));
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

