/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStagingTableUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StagingTableUDBv81 staging = (StagingTableUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, staging);
        this.appendCreate(buffer, staging);
        this.appendStagingTableDefinition(buffer, staging, prettyPrint);
        SSBStagingTableUDBv81.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateTable();
        if (staging.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendComment(buffer, staging, prettyPrint);
        }
        this.appendIntegrity(buffer, staging, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, StagingTableUDBv81 staging) {
        this.appendCreate(buffer);
        SSBStagingTableUDBv81.appendStringWithSpace(buffer, "TABLE");
        SSBStagingTableUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(staging.getName()));
    }

    private void appendStagingTableDefinition(StringBuffer buffer, StagingTableUDBv81 staging, boolean prettyPrint) {
        SSBStagingTableUDBv81.appendNewLine(buffer, prettyPrint, 1);
        if (staging.getDefineColumnNames()) {
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, '(');
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, staging.getColumns());
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, ')');
        }
        SSBStagingTableUDBv81.appendStringWithSpace(buffer, "FOR");
        SSBStagingTableUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(staging.getTable().getName()));
        SSBStagingTableUDBv81.appendStringWithSpace(buffer, "PROPAGATE");
        SSBStagingTableUDBv81.appendStringWithSpace(buffer, "IMMEDIATE");
    }

    private void appendComment(StringBuffer buffer, StagingTableUDBv81 staging, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(staging.getCommentInRDBMS())) {
            SSBStagingTableUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(staging.getName()));
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, "IS");
            SSBStagingTableUDBv81.appendString(buffer, '\'');
            SSBStagingTableUDBv81.appendString(buffer, staging.getCommentInRDBMS());
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, '\'');
            SSBStagingTableUDBv81.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    private void appendIntegrity(StringBuffer buffer, StagingTableUDBv81 staging, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(staging.getGenerateSIC())) {
            SSBStagingTableUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, "SET");
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, "INTEGRITY");
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, "FOR");
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(staging.getName()));
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, "IMMEDIATE");
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, "CHECKED");
            SSBStagingTableUDBv81.appendStringWithSpace(buffer, "FULL ACCESS");
            SSBStagingTableUDBv81.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StagingTableUDBv81 && ((StagingTableUDBv81)object).isMarkedGenerate();
    }
}

