/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSchemaUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchemaUDBv71 && ((SchemaUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        SchemaUDBv71 schema = (SchemaUDBv71)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, schema);
        this.appendCreate(buffer, schema);
        this.appendAuthorizationObject(buffer, schema, prettyPrint);
        SSBSchemaUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateSchema();
        if (schema.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, schema, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, SchemaUDBv71 schema, boolean prettyPrint) {
        SSBSchemaUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBSchemaUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
        SSBSchemaUDBv71.appendStringWithSpace(buffer, "SCHEMA");
        SSBSchemaUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(schema.getLongName()));
        SSBSchemaUDBv71.appendStringWithSpace(buffer, "IS");
        SSBSchemaUDBv71.appendString(buffer, '\'');
        SSBSchemaUDBv71.appendString(buffer, schema.getCommentInRDBMS());
        SSBSchemaUDBv71.appendStringWithSpace(buffer, '\'');
        SSBSchemaUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, SchemaUDBv71 schema) {
        this.appendCreate(buffer);
        SSBSchemaUDBv71.appendStringWithSpace(buffer, "SCHEMA");
        SSBSchemaUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(schema.getName()));
    }

    protected void appendAuthorizationObject(StringBuffer buffer, SchemaUDBv71 schema, boolean prettyPrint) {
        if (schema.getOwner() != null && !schema.getOwner().isNullInstance()) {
            SSBSchemaUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBSchemaUDBv71.appendStringWithSpace(buffer, "AUTHORIZATION");
            SSBSchemaUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(schema.getOwner().getName()));
        }
    }
}

