/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.exports.ddl.udb.v71.SSBTableSpaceUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.DataBaseUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseUDBv71
extends AbstractSSBUDB {
    public static final String USING_CODESET = "USING CODESET";
    public static final String TERRITORY = "TERRITORY";
    public static final String COLLATE_USING = "COLLATE USING";
    public static final String NUMSEGS = "NUMSEGS";
    public static final String DEFAULT_EXTENT_SIZE = "DFT_EXTENT_SZ";
    public static final String CATALOG_TABLESPACE = "CATALOG TABLESPACE";
    public static final String USER_TABLESPACE = "USER TABLESPACE";
    public static final String TEMP_TABLESPACE = "TEMPORARY TABLESPACE";
    public static final String WITH = "WITH";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseUDBv71 && ((DataBaseUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DataBaseUDBv71 database = (DataBaseUDBv71)object;
        this.appendCreate(buffer, database);
        this.appendAutomaticStorage(buffer, database, prettyPrint);
        this.appendOnPath(buffer, database, prettyPrint);
        this.appendAlias(buffer, database, prettyPrint);
        this.appendUsingCodesetTerritory(buffer, database, prettyPrint);
        this.appendCollateUsing(buffer, database, prettyPrint);
        this.appendNumsegs(buffer, database, prettyPrint);
        this.appendDefaultExtentSize(buffer, database, prettyPrint);
        this.appendCatalogTableSpace(buffer, database, prettyPrint);
        this.appendUserTableSpace(buffer, database, prettyPrint);
        this.appendTemporaryTableSpace(buffer, database, prettyPrint);
        if (database.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendWith(buffer, database, prettyPrint);
        }
        SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateDatabase();
    }

    protected void appendCreate(StringBuffer buffer, DataBaseUDBv71 database) {
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(database);
        this.appendCreate(buffer);
        SSBDataBaseUDBv71.appendStringWithSpace(buffer, "DATABASE");
        SSBDataBaseUDBv71.appendStringWithSpace(buffer, storageDesign.getFormatedName(database.getName()));
    }

    protected void appendAutomaticStorage(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (!database.getAutomaticStorage().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, "AUTOMATIC");
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, "STORAGE");
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, database.getAutomaticStorage());
        }
    }

    protected void appendOnPath(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (!database.getOnPath().equals("")) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, "ON");
            StringTokenizer paths = new StringTokenizer(database.getOnPath(), ",");
            int num = paths.countTokens();
            for (int i = 0; i < num; ++i) {
                SSBDataBaseUDBv71.appendString(buffer, '\'');
                SSBDataBaseUDBv71.appendString(buffer, paths.nextToken().trim());
                SSBDataBaseUDBv71.appendString(buffer, '\'');
                if (i < num - 1) {
                    SSBDataBaseUDBv71.appendStringWithSpace(buffer, ",");
                    continue;
                }
                SSBDataBaseUDBv71.appendSpace(buffer);
            }
            if (!database.getDBPathOn().equals("")) {
                SSBDataBaseUDBv71.appendStringWithSpace(buffer, "DBPATH");
                SSBDataBaseUDBv71.appendStringWithSpace(buffer, "ON");
                SSBDataBaseUDBv71.appendString(buffer, '\'');
                SSBDataBaseUDBv71.appendString(buffer, database.getDBPathOn());
                SSBDataBaseUDBv71.appendStringWithSpace(buffer, '\'');
            }
        }
    }

    protected void appendAlias(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (!database.getAlias().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, "ALIAS");
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, database.getAlias());
        }
    }

    protected void appendUsingCodesetTerritory(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (!database.getCodeSet().equalsIgnoreCase("") && !database.getTerritory().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, USING_CODESET);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, database.getCodeSet());
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, TERRITORY);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, database.getTerritory());
        }
    }

    protected void appendCollateUsing(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (!database.getCollatingSequence().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, COLLATE_USING);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, database.getCollatingSequence());
        }
    }

    protected void appendNumsegs(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (database.getSegmentNumber() > 0 && database.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, NUMSEGS);
            this.appendStringWithSpace(buffer, database.getSegmentNumber());
        }
    }

    protected void appendDefaultExtentSize(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (database.getDefaultExtentSize() > 0 && database.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, DEFAULT_EXTENT_SIZE);
            this.appendStringWithSpace(buffer, database.getDefaultExtentSize());
        }
    }

    protected void appendCatalogTableSpace(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (database.getCatalogTableSpace() != null && !database.getCatalogTableSpace().isNullInstance() && database.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, CATALOG_TABLESPACE);
            this.appendTableSpaceDefinition(buffer, (TableSpaceUDBv71)database.getCatalogTableSpace(), prettyPrint);
        }
    }

    protected void appendUserTableSpace(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (database.getUserTableSpace() != null && !database.getUserTableSpace().isNullInstance() && database.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, USER_TABLESPACE);
            this.appendTableSpaceDefinition(buffer, (TableSpaceUDBv71)database.getUserTableSpace(), prettyPrint);
        }
    }

    protected void appendTemporaryTableSpace(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (database.getTemporaryTableSpace() != null && !database.getTemporaryTableSpace().isNullInstance() && database.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, TEMP_TABLESPACE);
            this.appendTableSpaceDefinition(buffer, (TableSpaceUDBv71)database.getTemporaryTableSpace(), prettyPrint);
        }
    }

    private void appendTableSpaceDefinition(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        SSBTableSpaceUDBv71 ssbTableSpace = new SSBTableSpaceUDBv71();
        ssbTableSpace.appendManagedBy(buffer, tablespace);
        ssbTableSpace.appendUsingContainer(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendExtentSize(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendPrefetchSize(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendOverhead(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendTransferRate(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendDroppedTableRecovery(buffer, tablespace, prettyPrint);
    }

    protected void appendWith(StringBuffer buffer, DataBaseUDBv71 database, boolean prettyPrint) {
        if (!database.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(buffer, WITH);
            SSBDataBaseUDBv71.appendString(buffer, '\"');
            SSBDataBaseUDBv71.appendString(buffer, database.getCommentInRDBMS());
            SSBDataBaseUDBv71.appendString(buffer, '\"');
        }
    }
}

