/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.AliasUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBAliasUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof AliasUDBv71 && ((AliasUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        AliasUDBv71 alias = (AliasUDBv71)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, alias);
        this.appendCreate(buffer, alias);
        this.appendReferencedObject(buffer, alias, prettyPrint);
        SSBAliasUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateAlias();
        if (alias.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, alias, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, AliasUDBv71 alias, boolean prettyPrint) {
        SSBAliasUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBAliasUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
        SSBAliasUDBv71.appendStringWithSpace(buffer, "ALIAS");
        SSBAliasUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getLongNameDDL()));
        SSBAliasUDBv71.appendStringWithSpace(buffer, "IS");
        SSBAliasUDBv71.appendString(buffer, '\'');
        SSBAliasUDBv71.appendString(buffer, alias.getCommentInRDBMS());
        SSBAliasUDBv71.appendStringWithSpace(buffer, '\'');
        SSBAliasUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, AliasUDBv71 alias) {
        this.appendCreate(buffer);
        SSBAliasUDBv71.appendStringWithSpace(buffer, "ALIAS");
        SSBAliasUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getLongNameDDL()));
    }

    protected void appendReferencedObject(StringBuffer buffer, AliasUDBv71 alias, boolean prettyPrint) {
        if (alias.getReferencedObject() != null) {
            SSBAliasUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBAliasUDBv71.appendStringWithSpace(buffer, "FOR");
            SSBAliasUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getReferencedObject().getLongNameDDL()));
        }
    }
}

