/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBPartitionSchemeSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PartitionSchemeSqlServerv2k5 partScheme = (PartitionSchemeSqlServerv2k5)object;
        this.storageDesign = partScheme.getStorageDesign();
        this.appendComment(buffer, partScheme);
        this.appendPartitionScheme(buffer, partScheme, prettyPrint);
        DDLFileMaker.incrementPartitionSheme();
    }

    private void appendPartitionScheme(StringBuffer buffer, PartitionSchemeSqlServerv2k5 partScheme, boolean prettyPrint) {
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        this.appendDataBase(buffer, partScheme.getPartitionFunction().getDatabase(), prettyPrint);
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "PARTITION");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "SCHEME");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partScheme.getName()));
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        this.appendPartitionMapping(buffer, partScheme, prettyPrint);
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        SSBPartitionSchemeSqlServerv2k5.appendString(buffer, "GO");
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
    }

    private void appendPartitionMapping(StringBuffer buffer, PartitionSchemeSqlServerv2k5 partScheme, boolean prettyPrint) {
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "AS");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "PARTITION");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partScheme.getPartitionFunction().getName()));
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        if (partScheme.isSingleFileGroupSelected()) {
            this.appendSingleFileGroup(buffer, partScheme, prettyPrint);
        } else {
            this.appendMultipleFileGroups(buffer, partScheme, prettyPrint);
        }
    }

    private void appendSingleFileGroup(StringBuffer buffer, PartitionSchemeSqlServerv2k5 partScheme, boolean prettyPrint) {
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "ALL");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "TO");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, '(');
        if (partScheme.getSingleFileGroup() != null && !partScheme.getSingleFileGroup().getName().equalsIgnoreCase("PRIMARY")) {
            SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partScheme.getSingleFileGroup().getName()));
        } else {
            SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "[PRIMARY]");
        }
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, ')');
    }

    private void appendMultipleFileGroups(StringBuffer buffer, PartitionSchemeSqlServerv2k5 partScheme, boolean prettyPrint) {
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "TO");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, '(');
        if (partScheme.getMappingTableSet().size() > 0) {
            this.appendFileGroups(buffer, partScheme, prettyPrint);
        } else {
            int size = partScheme.getPartitionFunction().getBValuesSet().size();
            for (int i = 0; i < size + 1; i += 2) {
                SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, "[PRIMARY]");
                if (i >= size) continue;
                SSBPartitionSchemeSqlServerv2k5.appendString(buffer, ',');
            }
        }
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, ')');
    }

    private void appendFileGroups(StringBuffer buffer, PartitionSchemeSqlServerv2k5 partScheme, boolean prettyPrint) {
        PartitionSchemeSqlServer.MappingTable filegroups = partScheme.getMappingTableSet();
        for (int i = 1; i < filegroups.size(); i += 2) {
            String fileGroupName = (String)filegroups.get(i);
            if (!this.isNotEmpty(fileGroupName) || fileGroupName.trim().equalsIgnoreCase("PRIMARY")) {
                fileGroupName = "[PRIMARY]";
            }
            SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(buffer, fileGroupName.trim());
            if (i >= filegroups.size() - 2) continue;
            SSBPartitionSchemeSqlServerv2k5.appendString(buffer, ',');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof PartitionSchemeSqlServerv2k5 && ((PartitionSchemeSqlServerv2k5)object).isMarkedGenerate() && !((PartitionSchemeSqlServerv2k5)object).getPartitionFunction().getInputType().equals("");
    }
}

