/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k.SSBIndexSqlServerv2k;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.ColumnProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.TableProxySqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesignSqlServerv2k storageDesign;
    private SSBIndexSqlServerv2k ssbIndex = new SSBIndexSqlServerv2k();
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Table table = null;
        TableProxySqlServerv2k tableProxy = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
            tableProxy = (TableProxySqlServerv2k)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxySqlServer) {
            tableProxy = (TableProxySqlServerv2k)object;
            table = (Table)tableProxy.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
        }
        if (tableProxy != null && !tableProxy.isMarkedGenerate()) {
            this.appendIndexes(buffer, tableProxy, prettyPrint);
            return;
        }
        if (table != null) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            this.appendBeforeCreateScript(buffer, prettyPrint, table);
            if (tableProxy != null && tableProxy.isCommentChanged()) {
                this.appendComment(buffer, tableProxy);
            } else {
                this.appendComment(buffer, table);
            }
            if (tableProxy != null) {
                this.appendCreateTable(buffer, tableProxy);
                this.appendColumns(buffer, table, tableProxy, prettyPrint);
                this.appendFilegroup(buffer, tableProxy, prettyPrint);
                this.appendTextImage(buffer, tableProxy, prettyPrint);
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "GO");
                DDLFileMaker.incrementCreateTable();
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                this.appendAfterCreateScript(buffer, prettyPrint, table);
                this.appendColumnCheckConstraints(buffer, tableProxy, prettyPrint);
                SSBTableSqlServerv2k.appendExistenceDependencyConstraints(buffer, tableProxy, prettyPrint, this, "GO", 128);
                SSBTableSqlServerv2k.appendOptionalFKCheckConstraints(buffer, tableProxy, prettyPrint, this, String.valueOf(';'), 30);
                if (this.getArcConstrHandler() != null) {
                    this.getArcConstrHandler().appendArcConstraints(buffer, tableProxy, prettyPrint);
                }
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(buffer, table, tableProxy, prettyPrint);
                }
                this.appendBindDefault(buffer, table, tableProxy, prettyPrint);
                this.appendExtProperties(buffer, tableProxy, prettyPrint);
                this.appendColumnExtProperties(buffer, table, tableProxy, prettyPrint);
                this.appendIndexes(buffer, tableProxy, prettyPrint);
            } else {
                this.appendTableCommentOn(buffer, table, tableProxy, prettyPrint);
            }
        }
    }

    private void appendIndexes(StringBuffer buffer, TableProxySqlServer tableProxy, boolean prettyPrint) {
        for (Object object : tableProxy.getIndexes()) {
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
        }
        this.appendIndexesForConstraints(buffer, (Table)tableProxy.getObject(), tableProxy);
    }

    private void appendCreateTable(StringBuffer buffer, TableProxySqlServerv2k tableProxy) {
        if (tableProxy.getName().length() > tableProxy.getMaxNameLength()) {
            SSBTableSqlServerv2k.appendNewLine(buffer, true, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
            SSBTableSqlServerv2k.appendNewLine(buffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CREATE");
        SSBTableSqlServerv2k.appendStringWithSpace(buffer, "TABLE");
        if (tableProxy.getUser() != null && tableProxy.getDatabase() != null && !tableProxy.getDatabase().isNullInstance() && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getDatabase().getName()));
            SSBTableSqlServerv2k.appendString(buffer, '.');
        }
        SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
    }

    private void appendBindDefault(StringBuffer buffer, Table table, TableProxySqlServerv2k tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k columnProxy = null;
        SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (tableProxy != null) {
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                columnProxy = (ColumnProxySqlServerv2k)tableProxy.getColumnProxy(column.getObjectID());
                if (!columnProxy.getDefineDefault() || columnProxy.getDefaultObject() == null) continue;
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_bindefault");
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, columnProxy.getDefaultObject().getName());
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                this.appendComma(buffer);
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, columnProxy.getTableProxy().getLongNameDDL());
                SSBTableSqlServerv2k.appendString(buffer, '.');
                SSBTableSqlServerv2k.appendString(buffer, columnProxy.getName());
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "GO");
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    protected void appendColumns(StringBuffer buffer, Table table, TableProxySqlServerv2k tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k columnProxy = null;
        Object[] instCols = null;
        if (tableProxy != null) {
            instCols = tableProxy.getInstanceDescriptorCols().toArray();
        }
        SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length == 0 && (instCols == null || instCols.length == 0)) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            buffer.append("-- No columns");
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        } else {
            for (int i = 0; i < columns.length; ++i) {
                if (i == 0) {
                    SSBTableSqlServerv2k.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                if (tableProxy == null) continue;
                column = columns[i];
                columnProxy = (ColumnProxySqlServerv2k)tableProxy.getColumnProxy(column.getObjectID());
                if (columnProxy.getComputed()) {
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "AS");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, columnProxy.getFormula());
                    continue;
                }
                this.appendColumnNameAndDataType(buffer, columnProxy, prettyPrint);
                this.appendColate(buffer, columnProxy);
                this.appendColumnNullsAllowed(buffer, columnProxy);
                this.appendDefault(buffer, columnProxy);
                this.appendIdentity(buffer, columnProxy);
                this.appendRowGuidCol(buffer, columnProxy);
                this.appendColumnConstraints(buffer, column, columnProxy);
            }
            InstanceDescriptorColumnSqlServer instCol = null;
            for (int i = 0; i < instCols.length; ++i) {
                instCol = (InstanceDescriptorColumnSqlServer)instCols[i];
                if (columns.length == 0 && i == 0) {
                    SSBTableSqlServerv2k.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(instCol.getName()));
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, instCol.getDataType());
            }
            this.appendTableConstraintsDefinition(buffer, table, prettyPrint);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendString(buffer, ')');
        }
    }

    private void appendFilegroup(StringBuffer buffer, TableProxySqlServerv2k tableProxy, boolean prettyPrint) {
        if (tableProxy.getFilegroup() != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, tableProxy.getFilegroup().getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "\"default\"");
        }
    }

    private void appendTextImage(StringBuffer buffer, TableProxySqlServerv2k tableProxy, boolean prettyPrint) {
        if (tableProxy.getTextImageFG() != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "TEXTIMAGE_ON");
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, tableProxy.getTextImageFG().getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
        }
    }

    private void appendColumnNameAndDataType(StringBuffer buffer, ColumnProxySqlServerv2k columnProxy, boolean prettyPrint) {
        String size;
        if (columnProxy.getName().length() > columnProxy.getMaxNameLength()) {
            SSBTableSqlServerv2k.appendNewLine(buffer, true, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
            SSBTableSqlServerv2k.appendNewLine(buffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBTableSqlServerv2k.appendString(buffer, ' ');
        SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
        String datatype = columnProxy.getDatatypeString();
        if (datatype.equalsIgnoreCase("DATETIME") && columnProxy.getColumn().getParameters().containsKey("size") && !"0".equals(size = (String)columnProxy.getColumn().getParameters().get("size"))) {
            datatype = datatype.concat(" (" + size + ")");
        }
        SSBTableSqlServerv2k.appendStringWithSpace(buffer, datatype);
        if (datatype.equalsIgnoreCase("unknown")) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 5);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendColumnNullsAllowed(StringBuffer buffer, ColumnProxySqlServerv2k columnProxy) {
        if (!columnProxy.getNullsAllowed()) {
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "NOT NULL");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "NULL");
        }
    }

    private void appendColate(StringBuffer buffer, ColumnProxySqlServerv2k columnProxy) {
        if (!columnProxy.getCollation().trim().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "COLLATE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, columnProxy.getCollation());
        }
    }

    private void appendDefault(StringBuffer buffer, ColumnProxySqlServer columnProxy) {
        if (!columnProxy.getDefineDefault() && !columnProxy.getDefaultValue().trim().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "DEFAULT");
            try {
                String defaultValue = columnProxy.getDefaultValue().trim();
                String dt = columnProxy.getColumn().getDatatypeString("SQL Server 2000");
                String df = this.addQuotesToDefault(dt, defaultValue);
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, df);
            }
            catch (Exception e) {
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, columnProxy.getDefaultValue().trim());
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            }
        }
    }

    private void appendIdentity(StringBuffer buffer, ColumnProxySqlServerv2k columnProxy) {
        if (!columnProxy.getDefineDefault() && columnProxy.getAsIdentity()) {
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "IDENTITY");
            if (!"1".equals(columnProxy.getIdentitySeed()) || columnProxy.getIdentityIncrement() != 1) {
                SSBTableSqlServerv2k.appendString(buffer, '(');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, columnProxy.getIdentitySeed());
                this.appendComma(buffer);
                this.appendString(buffer, columnProxy.getIdentityIncrement());
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ')');
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSqlServerv2k.appendString(buffer, '(');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "1");
                this.appendComma(buffer);
                SSBTableSqlServerv2k.appendString(buffer, "1");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ')');
            }
            if (columnProxy.getIdentityForReplication().equalsIgnoreCase("NO")) {
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "NOT FOR REPLICATION");
            }
        }
    }

    private void appendRowGuidCol(StringBuffer buffer, ColumnProxySqlServerv2k columnProxy) {
        if (columnProxy.getRowGuidCol().trim().equalsIgnoreCase("YES")) {
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ROWGUIDCOL");
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer buffer, Table table, boolean prettyPrint) {
        if (table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                this.appendComma(buffer);
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k.appendString(buffer, ' ');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(constraint.getName()));
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CHECK");
                SSBTableSqlServerv2k.appendString(buffer, '(');
                SSBTableSqlServerv2k.appendString(buffer, constraint.getRule());
                SSBTableSqlServerv2k.appendString(buffer, ')');
            }
        }
    }

    private void appendConstrants(StringBuffer buffer, TableProxySqlServerv2k tableProxy, boolean prettyPrint) {
        this.appendPKey(buffer, tableProxy, prettyPrint);
        this.appendUniqueKeys(buffer, tableProxy, prettyPrint);
    }

    private void appendPKey(StringBuffer buffer, TableProxySqlServerv2k tableProxy, boolean prettyPrint) {
        StorageObjectCollection pkeys = tableProxy.getPkeys();
        for (PKProxySqlServer pkey : pkeys) {
            ColumnProxy[] proxies = pkey.getColumnProxies();
            if (proxies.length <= 0 || !pkey.isMarkedGenerate()) continue;
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ALTER");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ADD");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkey.getName()));
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "PRIMARY KEY");
            if (pkey.isClustered()) {
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CLUSTERED");
            } else {
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "NONCLUSTERED");
            }
            for (int i = 0; i < proxies.length; ++i) {
                if (i == 0) {
                    SSBTableSqlServerv2k.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                ColumnProxy proxy = proxies[i];
                String sortorder = "";
                if (proxy.getObject() != null) {
                    sortorder = ((Index)pkey.getObject()).getColumnSortOrder(proxy.getObject());
                }
                if ("DESC".equalsIgnoreCase(sortorder)) {
                    SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()) + " " + sortorder);
                    continue;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()) + " ASC");
                    continue;
                }
                SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()));
            }
            SSBTableSqlServerv2k.appendString(buffer, ')');
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (pkey.getFillFactor() > 0 && pkey.getFillFactor() < 100) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "WITH");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "FILLFACTOR");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '=');
                    this.appendStringWithSpace(buffer, pkey.getFillFactor());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "WITH");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "FILLFACTOR");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "0");
                }
                if (pkey.getFilegroup() != null) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ON");
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, pkey.getFilegroup().getName());
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ON");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "\"default\"");
                }
            }
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendString(buffer, "GO");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendUniqueKeys(StringBuffer buffer, TableProxySqlServerv2k tableProxy, boolean prettyPrint) {
        StorageObjectCollection ukeys = tableProxy.getUkeys();
        for (UniqueProxySqlServer ukey : ukeys) {
            ColumnProxy[] proxies = ukey.getColumnProxies();
            if (proxies.length <= 0 || !ukey.isMarkedGenerate()) continue;
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ALTER");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ADD");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ukey.getName()));
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "UNIQUE");
            if (ukey.isClustered()) {
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CLUSTERED");
            } else {
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "NONCLUSTERED");
            }
            for (int i = 0; i < proxies.length; ++i) {
                if (i == 0) {
                    SSBTableSqlServerv2k.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                ColumnProxy proxy = proxies[i];
                String sortorder = "";
                if (proxy.getObject() != null) {
                    sortorder = ((Index)ukey.getObject()).getColumnSortOrder(proxy.getObject());
                }
                if ("DESC".equalsIgnoreCase(sortorder)) {
                    SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()) + " " + sortorder);
                    continue;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()) + " ASC");
                    continue;
                }
                SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()));
            }
            SSBTableSqlServerv2k.appendString(buffer, ')');
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (ukey.getFillFactor() > 0 && ukey.getFillFactor() < 100) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "WITH");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "FILLFACTOR");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '=');
                    this.appendStringWithSpace(buffer, ukey.getFillFactor());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "WITH");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "FILLFACTOR");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "0");
                }
                if (ukey.getFilegroup() != null) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ON");
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, ukey.getFilegroup().getName());
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ON");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "\"default\"");
                }
            }
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendString(buffer, "GO");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxySqlServer columnProxy) {
        String text;
        if (column.hasConstraintsDefinedForDDL() && !"".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName())))) {
            String cname = column.getConstraintName();
            if (column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                if (!cname.equals("") && cname.length() <= 128) {
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CHECK");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '(');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, text);
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendTableCommentOn(StringBuffer buffer, Table table, TableProxySqlServer tableProxy, boolean prettyPrint) {
        block14: {
            block13: {
                String comment = null;
                String tableName = null;
                if (tableProxy != null && tableProxy.isCommentInRDBMSChanged()) {
                    comment = tableProxy.getCommentInRDBMS();
                    tableName = tableProxy.getName();
                } else if (table != null) {
                    comment = table.getCommentInRDBMS();
                    tableName = table.getName();
                }
                if (comment != null && !comment.trim().equalsIgnoreCase("")) {
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, comment);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    if (tableProxy != null && tableProxy.getUser() != null) {
                        SSBTableSqlServerv2k.appendString(buffer, '\'');
                        SSBTableSqlServerv2k.appendString(buffer, "USER");
                        SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                        SSBTableSqlServerv2k.appendString(buffer, '\'');
                        SSBTableSqlServerv2k.appendString(buffer, tableProxy.getUser().getName());
                        SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    }
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, "TABLE");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, tableName);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k.appendString(buffer, "GO");
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                }
                if (tableProxy == null) break block13;
                ColumnProxy[] columns = tableProxy.getColumnProxies();
                for (int i = 0; i < columns.length; ++i) {
                    ColumnProxy col = columns[i];
                    if (col.getCommentInRDBMS() != null && col.isCommentInRDBMSChanged()) {
                        this.appendColumnComment(buffer, col, tableProxy, prettyPrint);
                        continue;
                    }
                    this.appendColumnComment(buffer, (Column)col.getObject(), table, prettyPrint);
                }
                Iterator it = tableProxy.getPkeys().iterator();
                PKProxySqlServer pkey = null;
                while (it.hasNext()) {
                    pkey = (PKProxySqlServer)it.next();
                    if (pkey.getCommentInRDBMS() != null && pkey.isCommentInRDBMSChanged()) {
                        this.appendPKeyComment(buffer, pkey, tableProxy, prettyPrint);
                        continue;
                    }
                    this.appendIndexComment(buffer, (Index)pkey.getObject(), table, prettyPrint);
                }
                it = tableProxy.getUkeys().iterator();
                UniqueProxySqlServer ukey = null;
                while (it.hasNext()) {
                    ukey = (UniqueProxySqlServer)it.next();
                    if (ukey.getCommentInRDBMS() != null && ukey.isCommentInRDBMSChanged()) {
                        this.appendUKeyComment(buffer, ukey, tableProxy, prettyPrint);
                        continue;
                    }
                    this.appendIndexComment(buffer, (Index)ukey.getObject(), table, prettyPrint);
                }
                break block14;
            }
            if (table == null) break block14;
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column col = (Column)columns[i];
                if (col.getCommentInRDBMS() == null) continue;
                this.appendColumnComment(buffer, col, table, prettyPrint);
            }
            Iterator it = table.getPKeys().iterator();
            Index pkey = null;
            while (it.hasNext()) {
                pkey = (Index)it.next();
                if (pkey.getCommentInRDBMS() == null) continue;
                this.appendIndexComment(buffer, pkey, table, prettyPrint);
            }
        }
    }

    protected void appendColumnComment(StringBuffer buffer, ColumnProxy col, TableProxySqlServer tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !col.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, col.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (tableProxy.getUser() != null) {
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, "USER");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, tableProxy.getUser().getName());
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, tableProxy.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "COLUMN");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, col.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendString(buffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendColumnComment(StringBuffer buffer, Column col, Table table, boolean prettyPrint) {
        if (!col.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, col.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, table.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "COLUMN");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, col.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendString(buffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendPKeyComment(StringBuffer buffer, PKProxySqlServer index, TableProxySqlServer tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !index.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, index.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (tableProxy.getUser() != null) {
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, "USER");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, tableProxy.getUser().getName());
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, tableProxy.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, index.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendString(buffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendUKeyComment(StringBuffer buffer, UniqueProxySqlServer index, TableProxySqlServer tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !index.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, index.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (tableProxy.getUser() != null) {
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, "USER");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k.appendString(buffer, '\'');
                SSBTableSqlServerv2k.appendString(buffer, tableProxy.getUser().getName());
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, tableProxy.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, index.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendString(buffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendIndexComment(StringBuffer buffer, Index index, Table table, boolean prettyPrint) {
        if (!index.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, index.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, table.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k.appendString(buffer, '\'');
            SSBTableSqlServerv2k.appendString(buffer, index.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendString(buffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy[] colProxies = tableProxy.getColumnProxies();
        for (int i = 0; i < colProxies.length; ++i) {
            String text;
            ColumnProxy columnProxy = colProxies[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefinedForDDL() || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC() || "".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName())))) continue;
            String cname = this.storageDesign.getFormatedName(column.getConstraintName());
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ALTER");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname) && cname.length() <= 128) {
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, cname);
            }
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CHECK");
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, '(');
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, text);
            SSBTableSqlServerv2k.appendStringWithSpace(buffer, ')');
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k.appendString(buffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        Table table = (Table)tableProxy.getObject();
        if (!table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                String text = constraint.getRule();
                if ("".equals(text)) continue;
                String cname = this.storageDesign.getFormatedName(constraint.getName());
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ALTER");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "TABLE");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "ADD");
                if (!"".equals(cname) && cname.length() <= 128) {
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, cname);
                }
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, "CHECK");
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, '(');
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, text);
                SSBTableSqlServerv2k.appendStringWithSpace(buffer, ')');
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k.appendString(buffer, "GO");
                SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxySqlServer && ((TableProxySqlServer)object).getDatabase() != null && !((TableProxySqlServer)object).getDatabase().isNullInstance();
    }

    private void appendExtProperties(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableProxySqlServerv2k tableProxy = (TableProxySqlServerv2k)object;
        if (!"".equalsIgnoreCase(tableProxy.getProps())) {
            if (tableProxy.getUser() != null) {
                for (int i = 0; i < tableProxy.getExtPropsSet().size() - 1; ++i) {
                    String name = '\'' + (String)tableProxy.getExtPropsSet().get(i) + '\'';
                    String value = '\'' + (String)tableProxy.getExtPropsSet().get(++i) + '\'';
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
                    String props = name + ", " + value;
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, props);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, "USER");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getUser().getName()));
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, "TABLE");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getName()));
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k.appendString(buffer, "GO");
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                }
            }
        }
    }

    private void appendColumnExtProperties(StringBuffer buffer, Table table, TableProxySqlServerv2k tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k columnProxy = null;
        SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        if (tableProxy != null) {
            for (int j = 0; j < columns.length; ++j) {
                column = columns[j];
                columnProxy = (ColumnProxySqlServerv2k)tableProxy.getColumnProxy(column.getObjectID());
                if ("".equalsIgnoreCase(columnProxy.getProps())) continue;
                int i = 0;
                while (i < columnProxy.getExtPropsSet().size() - 1) {
                    if (tableProxy.getUser() == null) continue;
                    String name = '\'' + (String)columnProxy.getExtPropsSet().get(i) + '\'';
                    String value = '\'' + (String)columnProxy.getExtPropsSet().get(++i) + '\'';
                    ++i;
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
                    String props = name + ", " + value;
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, props);
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, "USER");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    if (tableProxy.getUser() != null) {
                        SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getUser().getName()));
                        SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    }
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, "TABLE");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getName()));
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendString(buffer, '\'');
                    SSBTableSqlServerv2k.appendString(buffer, "COLUMN");
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k.appendString(buffer, "GO");
                    SSBTableSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                }
            }
        }
    }

    private void appendIndexesForConstraints(StringBuffer oldbuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keys = table.getKeys();
        boolean genPK = table.getDesign().getDesignLevelSettings().isAutomaticPKGeneration();
        boolean genUK = table.getDesign().getDesignLevelSettings().isAutomaticUKGeneration();
        boolean genFK = table.getDesign().getDesignLevelSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keys.length; ++i) {
            Index ind;
            ContainedObject[] cols;
            Index index = (Index)keys[i];
            if (!(genPK && "Primary Constraint".equals(index.getIndexState()) || genUK && "Unique Constraint".equals(index.getIndexState())) && (!index.isFK() || !genFK) || (cols = index.getElements()).length <= 0 || (ind = this.getIndexForColumns(table, index, cols, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(oldbuffer, index, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] cols, boolean ascending) {
        Object[] inds = table.getIndexes().toArray();
        for (int i = 0; i < inds.length; ++i) {
            DesignObjectPlaceHolder dph = (DesignObjectPlaceHolder)inds[i];
            Index ind = (Index)dph.getDesignObject();
            ContainedObject[] icols = ind.getElements();
            if (cols.length != icols.length) continue;
            boolean brflag = false;
            for (int j = 0; j < cols.length; ++j) {
                String so;
                if (cols[j] != icols[j]) {
                    brflag = true;
                    break;
                }
                if (!ascending || "ASC".equalsIgnoreCase(so = ind.getColumnSortOrder(icols[j]).trim()) || "".equalsIgnoreCase(so)) continue;
                brflag = true;
                break;
            }
            if (brflag || ind == index) continue;
            return ind;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }

    @Override
    public String appendConstraints(TableProxy tableProxy) {
        StringBuffer sb = new StringBuffer();
        if (tableProxy != null && tableProxy instanceof TableProxySqlServerv2k) {
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignSqlServerv2k)tableProxy.getStorageDesign();
            }
            this.appendConstrants(sb, (TableProxySqlServerv2k)tableProxy, true);
            this.appendTableCheckConstraints(sb, tableProxy, true);
        }
        return sb.toString();
    }
}

