/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexSqlServerv2k
extends AbstractSSBSqlServer {
    StorageDesignSqlServerv2k storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Index index = null;
        IndexProxySqlServerv2k indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
            indexProxy = (IndexProxySqlServerv2k)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxySqlServer) {
            indexProxy = (IndexProxySqlServerv2k)object;
            index = (Index)indexProxy.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
        }
        if (indexProxy != null && indexProxy.isCommentChanged()) {
            this.appendComment(buffer, indexProxy);
        } else {
            this.appendComment(buffer, index);
        }
        if (indexProxy != null) {
            if (indexProxy.isMarkedGenerate()) {
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "CREATE");
                this.appendUnique(buffer, indexProxy);
                this.appendClustered(buffer, indexProxy);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "INDEX");
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
                this.appendTable(buffer, indexProxy, prettyPrint);
                this.appendOptions(buffer, indexProxy);
                this.appendFilegroup(buffer, indexProxy, prettyPrint);
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "GO");
                DDLFileMaker.incrementCreateIndex();
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
                }
                this.appendExtProperties(buffer, indexProxy, prettyPrint);
            } else if (index.hasIndexExpression()) {
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, index.getIndexExpression());
            } else {
                buffer.append("-- Index ").append(index.getName()).append(" on Table ").append(indexProxy.getTableName()).append(" not created in ddl");
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            }
        } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
        }
    }

    protected void appendIndexComment(StringBuffer buffer, Index index, IndexProxySqlServer indexProxy, boolean prettyPrint) {
        String comment = null;
        String tableName = null;
        if (indexProxy != null && indexProxy.isCommentInRDBMSChanged()) {
            comment = indexProxy.getCommentInRDBMS();
            tableName = indexProxy.getTableProxy().getName();
        } else if (index != null) {
            comment = index.getCommentInRDBMS();
            tableName = index.getContainerObject().getName();
        }
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBIndexSqlServerv2k.appendString(buffer, '\'');
            SSBIndexSqlServerv2k.appendString(buffer, comment);
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (indexProxy != null && ((TableProxySqlServer)indexProxy.getTableProxy()).getUser() != null) {
                SSBIndexSqlServerv2k.appendString(buffer, "'user'");
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBIndexSqlServerv2k.appendString(buffer, '\'');
                SSBIndexSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(((TableProxySqlServer)indexProxy.getTableProxy()).getUser().getName()));
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBIndexSqlServerv2k.appendString(buffer, "'table'");
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBIndexSqlServerv2k.appendString(buffer, '\'');
            SSBIndexSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(tableName));
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBIndexSqlServerv2k.appendString(buffer, "'index'");
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBIndexSqlServerv2k.appendString(buffer, '\'');
            SSBIndexSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(index.getName()));
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexSqlServerv2k.appendString(buffer, "GO");
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendUnique(StringBuffer buffer, IndexProxySqlServerv2k index) {
        if (index.getUnique().equalsIgnoreCase("YES")) {
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "UNIQUE");
        }
    }

    private void appendClustered(StringBuffer buffer, IndexProxySqlServerv2k index) {
        if (index.isClustered()) {
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "CLUSTERED");
        } else {
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "NONCLUSTERED");
        }
    }

    private void appendTable(StringBuffer buffer, IndexProxySqlServerv2k index, boolean prettyPrint) {
        SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "ON");
        SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getTableProxy().getName()));
        SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexSqlServerv2k.appendStringWithSpace(buffer, '(');
        SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (index.getIndex().hasIndexExpression()) {
            SSBIndexSqlServerv2k.appendString(buffer, ' ');
            SSBIndexSqlServerv2k.appendString(buffer, index.getIndex().getIndexExpression());
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        ColumnProxy[] columns = index.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            String sortorder = "";
            if (columns[i].getObject() != null) {
                sortorder = ((Index)index.getObject()).getColumnSortOrder(columns[i].getObject());
            }
            SSBIndexSqlServerv2k.appendString(buffer, ' ');
            if ("DESC".equalsIgnoreCase(sortorder)) {
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()) + " " + sortorder);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()) + " ASC");
            } else {
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
            }
            if (i != columns.length - 1) {
                this.appendComma(buffer);
            }
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ')');
    }

    private void appendOptions(StringBuffer buffer, IndexProxySqlServerv2k index) {
        if ((index.getFillFactor() > 0 || index.getIgnoreDupKey().equalsIgnoreCase("YES") || index.getRecomputeStatistics().equalsIgnoreCase("NO") || index.getSortInTempDB().equalsIgnoreCase("YES")) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "WITH");
            boolean writeComma = false;
            if (index.getFillFactor() > 0) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "PAD_INDEX");
                    this.appendComma(buffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, '=');
                this.appendStringWithSpace(buffer, index.getFillFactor());
                writeComma = true;
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "PAD_INDEX");
                    this.appendComma(buffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, '=');
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "0");
                writeComma = true;
            }
            if (index.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "IGNORE_DUP_KEY");
                writeComma = true;
            }
            if (index.getRecomputeStatistics().equalsIgnoreCase("NO")) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "STATISTICS_NORECOMPUTE");
                writeComma = true;
            }
            if (index.getSortInTempDB().equalsIgnoreCase("YES")) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "SORT_IN_TEMPDB");
            }
        }
    }

    private void appendFilegroup(StringBuffer buffer, IndexProxySqlServerv2k index, boolean prettyPrint) {
        if (index.getFilegroup() != null) {
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getFilegroup().getName()));
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "\"default\"");
        }
    }

    private void appendExtProperties(StringBuffer buffer, IndexProxySqlServerv2k index, boolean prettyPrint) {
        if (!index.getProps().trim().equalsIgnoreCase("") && ((TableProxySqlServer)index.getTableProxy()).getUser() != null) {
            StringTokenizer st = new StringTokenizer(index.getProps().trim(), ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                String value = st.nextToken();
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, name);
                this.appendComma(buffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, value);
                String user = "";
                user = ((TableProxySqlServer)index.getTableProxy()).getUser().getName();
                this.appendComma(buffer);
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "'user'");
                this.appendComma(buffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
                this.appendComma(buffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "'table'");
                this.appendComma(buffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getTableProxy().getName()));
                this.appendComma(buffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "'index'");
                this.appendComma(buffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k.appendString(buffer, "GO");
                SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxy && ((TableProxySqlServer)((IndexProxy)object).getTableProxy()).getDatabase() != null && !((TableProxySqlServer)((IndexProxy)object).getTableProxy()).getDatabase().isNullInstance() && ((IndexProxy)object).isMarkedGenerate();
    }

    public void appendIndexForConstraint(StringBuffer oldbuffer, Index object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Index index = null;
        IndexProxy indexProxy = null;
        index = object;
        StorageDesignSqlServerv2k storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
        if ("Primary Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxy)storageDesign.getPKProxySet().getProxy(index.getObjectID());
        } else if ("Unique Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxy)storageDesign.getUniqueProxySet().getProxy(index.getObjectID());
        } else if (index.isFK()) {
            indexProxy = (IndexProxy)storageDesign.getFKProxySet().getProxy(index.getObjectID());
        }
        if (index != null && !index.isOidKey() && indexProxy != null) {
            this.storageDesign = (StorageDesignSqlServerv2k)indexProxy.getStorageDesign();
            if (indexProxy.isMarkedGenerate()) {
                if (index.getElements().length > 0) {
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, indexProxy);
                    } else {
                        this.appendComment(oldbuffer, index);
                    }
                    TableProxy tp = indexProxy.getTableProxy();
                    String indName = indexProxy.getName();
                    String lname = indName = ApplyNamingStandards.createIndexNameAuto(tp.getName(), indName, index, index.getDesign().getDesignLevelSettings().getNamingStandardRule(), index.getDesignPart().getName(), index.getTable().getAbbreviation());
                    if (indName.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexSqlServerv2k.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexSqlServerv2k.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexSqlServerv2k.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "CREATE");
                    if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                        SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "UNIQUE");
                    }
                    SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "INDEX");
                    SSBIndexSqlServerv2k.appendStringWithSpace(buffer, storageDesign.getFormatedName(lname));
                    advancedComment = buffer.toString();
                    SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "ON");
                    SSBIndexSqlServerv2k.appendStringWithSpace(buffer, storageDesign.getFormatedName(indexProxy.getTableProxy().getLongNameDDL()));
                    this.appendConstraintElementList(buffer, index, indexProxy, true);
                    SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexSqlServerv2k.appendNewLine(oldbuffer, prettyPrint, 0);
                    oldbuffer.append("-- Error - Index ");
                    oldbuffer.append(storageDesign.getFormatedName(index.getName()));
                    oldbuffer.append(" has no columns");
                    SSBIndexSqlServerv2k.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer buffer, Index index, IndexProxy indexProxy, boolean prettyPrint) {
        ColumnProxy column = null;
        ColumnProxy[] columns = indexProxy.getColumnProxies();
        SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, "-- No Columns");
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexSqlServerv2k.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            column = columns[i];
            SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k.appendString(buffer, ' ');
            String columnName = this.storageDesign.getFormatedName(column.getName());
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, columnName);
            SSBIndexSqlServerv2k.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
        }
        SSBIndexSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexSqlServerv2k.appendStringWithSpace(buffer, ')');
    }
}

