/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.FKProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.TableProxySqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKSqlServerv2k
extends AbstractSSBSqlServer {
    StorageDesignSqlServer storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        FKProxySqlServerv2k fkproxy;
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)object;
            RelationalDesign rd = (RelationalDesign)fk.getDesignPart();
            this.storageDesign = (StorageDesignSqlServer)rd.getStorageDesign(rd.getSelectedRDBMSSite());
            fkproxy = (FKProxySqlServerv2k)this.storageDesign.getFKProxySet().getProxy(fk.getObjectID());
            if (fkproxy == null && (fkproxy = (FKProxySqlServerv2k)this.storageDesign.getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fkproxy = (FKProxySqlServerv2k)object;
            this.storageDesign = (StorageDesignSqlServer)fkproxy.getStorageDesign();
        }
        if (fkproxy.getRemoteTable() instanceof Table) {
            this.appendBeforeAlterScript(buffer, prettyPrint, fkproxy.getTable());
            this.appendComment(buffer, fkproxy);
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "ALTER");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "TABLE");
            TableProxySqlServerv2k tp = (TableProxySqlServerv2k)fkproxy.getTableProxy();
            if (tp != null) {
                SSBFKSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tp.getLongNameDDL()));
            } else {
                String owner = fkproxy.getTableUser();
                if (!"".equalsIgnoreCase(owner)) {
                    SSBFKSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(owner) + '.' + this.storageDesign.getFormatedName(fkproxy.getTableName()));
                } else {
                    SSBFKSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy.getTableName()));
                }
            }
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "ADD");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy.getName()));
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "FOREIGN KEY");
            this.appendColumns(buffer, fkproxy, prettyPrint);
            this.appendReferences(buffer, fkproxy, prettyPrint);
            this.appendOnDelete(buffer, fkproxy, prettyPrint);
            this.appendOnUpdate(buffer, fkproxy, prettyPrint);
            this.appendForReplication(buffer, fkproxy, prettyPrint);
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(buffer, prettyPrint, fkproxy.getTable());
        }
    }

    private void appendColumns(StringBuffer buffer, FKProxySqlServerv2k fk, boolean prettyPrint) {
        ColumnProxy[] columns = fk.getColumnProxies();
        if (columns.length > 0) {
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, '(');
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            for (int i = 0; i < columns.length; ++i) {
                SSBFKSqlServerv2k.appendString(buffer, ' ');
                SSBFKSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
                if (i != columns.length - 1) {
                    this.appendComma(buffer);
                }
                SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxySqlServerv2k fk, boolean prettyPrint) {
        SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBFKSqlServerv2k.appendStringWithSpace(buffer, "REFERENCES");
        SSBFKSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk.getReferenceTableDDL()));
        Column[] columns = (Column[])fk.getRefColumns();
        SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBFKSqlServerv2k.appendStringWithSpace(buffer, '(');
        SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        for (int i = 0; i < columns.length; ++i) {
            SSBFKSqlServerv2k.appendString(buffer, ' ');
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
            if (i != columns.length - 1) {
                this.appendComma(buffer);
            }
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBFKSqlServerv2k.appendStringWithSpace(buffer, ')');
    }

    private void appendOnDelete(StringBuffer buffer, FKProxySqlServerv2k fk, boolean prettyPrint) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        if (!"".equals(fkass.getDeleteRule())) {
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "DELETE");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, fk.getStorageDesign().getValidFKRule(fkass.getDeleteRule()));
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "DELETE");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "NO ACTION");
        }
    }

    private void appendOnUpdate(StringBuffer buffer, FKProxySqlServerv2k fk, boolean prettyPrint) {
        if (!"".equals(fk.getOnUpdate())) {
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "UPDATE");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, fk.getOnUpdate());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "ON");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "UPDATE");
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "NO ACTION");
        }
    }

    private void appendForReplication(StringBuffer buffer, FKProxySqlServerv2k fk, boolean prettyPrint) {
        if (fk.getForReplication().equalsIgnoreCase("NO")) {
            SSBFKSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k.appendStringWithSpace(buffer, "NOT FOR REPLICATION");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof RelationalObjectProxy && !((RelationalObjectProxy)object).getStorageDesign().isOpen()) {
            if (object instanceof FKProxySqlServerv2k) {
                return ((RelationalObjectProxy)object).getObject().isMarkedGenerate();
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return object instanceof FKProxySqlServerv2k && ((TableProxySqlServerv2k)((FKProxySqlServerv2k)object).getTableProxy()).getDatabase() != null && !((TableProxySqlServerv2k)((FKProxySqlServerv2k)object).getTableProxy()).getDatabase().isNullInstance() && ((FKProxySqlServerv2k)object).isMarkedGenerate();
    }
}

