/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RoleOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBRoleOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        RoleOraclev9i role = (RoleOraclev9i)object;
        this.storageDesign = role.getStorageDesign();
        this.appendComment(oldbuffer, role);
        SSBRoleOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBRoleOraclev9i.appendStringWithSpace(buffer, "ROLE");
        SSBRoleOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
        advancedComment = buffer.toString();
        this.appendIdentification(buffer, role, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateRole();
        this.appendRolesAndPrivileges(oldbuffer, role, prettyPrint);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RoleOraclev9i && ((RoleOraclev9i)object).isMarkedGenerate();
    }

    private void appendIdentification(StringBuffer buffer, RoleOraclev9i role, boolean prettyPrint) {
        SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(role.getIdentified())) {
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "IDENTIFIED");
            if ("BY_PASSWORD".equalsIgnoreCase(role.getAuthType())) {
                SSBRoleOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBRoleOraclev9i.appendStringWithSpace(buffer, role.decodePassword());
            } else if ("USING PACKAGE".equalsIgnoreCase(role.getAuthType())) {
                if (role.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBRoleOraclev9i.appendStringWithSpace(buffer, "USING");
                    SSBRoleOraclev9i.appendString(buffer, role.getSchema());
                    SSBRoleOraclev9i.appendString(buffer, '.');
                    SSBRoleOraclev9i.appendStringWithSpace(buffer, role.getPack());
                } else {
                    SSBRoleOraclev9i.appendStringWithSpace(buffer, "USING");
                    SSBRoleOraclev9i.appendStringWithSpace(buffer, role.getPack());
                }
            } else {
                buffer.append(role.getAuthType());
            }
        } else {
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "NOT");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "IDENTIFIED");
        }
    }

    private void appendRolesAndPrivileges(StringBuffer oldbuffer, RoleOraclev9i role, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        String roles = role.getRolesNames();
        String rolesAdminOption = role.getRolesWithAdminOptionNames();
        String privileges = role.getPrivileges();
        String privilegesAdminOption = role.getPrivilegesWithAdminOption();
        if (!"".equalsIgnoreCase(roles)) {
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, roles);
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "TO");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(rolesAdminOption)) {
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, rolesAdminOption);
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "TO");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
            buffer.append(" WITH ADMIN OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(privileges)) {
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, privileges);
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "TO");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(privilegesAdminOption)) {
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, privilegesAdminOption);
            SSBRoleOraclev9i.appendStringWithSpace(buffer, "TO");
            SSBRoleOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
            buffer.append(" WITH ADMIN OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBRoleOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }
}

