/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataBaseOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseOraclev9i && ((DataBaseOraclev9i)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DataBaseOraclev9i database = (DataBaseOraclev9i)object;
        this.storageDesign = database.getStorageDesign();
        this.appendComment(buffer, database);
        buffer.append(" -- CREATE DATABASE ").append(this.storageDesign.getFormatedName(database)).append(' ');
        this.appendSysPass(buffer, database, prettyPrint);
        this.appendSystemPass(buffer, database, prettyPrint);
        this.appendControlFileReuse(buffer, database);
        this.appendLogFiles(buffer, database);
        this.appendMaxLogFiles(buffer, database);
        this.appendMaxLogMembers(buffer, database);
        this.appendMaxLogHistory(buffer, database);
        this.appendMaxDataFiles(buffer, database);
        this.appendMaxInstances(buffer, database);
        this.appendArchiveLog(buffer, database);
        this.appendForceLogging(buffer, database, prettyPrint);
        this.appendCharacterSet(buffer, database);
        this.appendNationalCharacterSet(buffer, database);
        this.appendDataFiles(buffer, database);
        this.appendExtentManagement(buffer, database, prettyPrint);
        this.appendTempTablespace(buffer, database, prettyPrint);
        this.appendUndoTablespace(buffer, database, prettyPrint);
        this.appendTimeZone(buffer, database, prettyPrint);
        SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateDatabase();
    }

    private void appendSysPass(StringBuffer buffer, DataBaseOraclev9i database, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(database.getPassForSYS())) {
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "USER");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "SYS");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "IDENTIFIED");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "BY");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, database.getPassForSYS());
        }
    }

    private void appendSystemPass(StringBuffer buffer, DataBaseOraclev9i database, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(database.getPassForSYSTEM())) {
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "USER");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "SYSTEM");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "IDENTIFIED");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "BY");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, database.getPassForSYSTEM());
        }
    }

    private void appendControlFileReuse(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        String controlFileReuse = dataBase.getControlFileReuse();
        if (controlFileReuse.equalsIgnoreCase("YES")) {
            buffer.append(NEWLINE);
            buffer.append(" --  ").append("    ").append("CONTROLFILE REUSE");
        }
    }

    private void appendLogFiles(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        RedoLogGroupSetOracle rlgsOracle = ((StorageDesignOracle)dataBase.getStorageDesign()).getRedoLogGroupSet();
        Iterator setIt = rlgsOracle.iterator();
        int count = 0;
        boolean b = false;
        while (setIt.hasNext()) {
            RedoLogGroupOracle logFile = (RedoLogGroupOracle)setIt.next();
            if (logFile.getDataBase() == null || !logFile.getDataBase().toString().equalsIgnoreCase(dataBase.toString())) continue;
            ++count;
            if (!b) {
                buffer.append(NEWLINE);
                buffer.append(" --  ").append("    ");
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "LOGFILE");
                b = true;
            } else {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, ',');
            }
            buffer.append(NEWLINE).append(" --  ").append("    ").append("    ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "GROUP");
            this.appendStringWithSpace(buffer, count);
            if (!"".equalsIgnoreCase(logFile.getFileName())) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, '(');
                SSBDataBaseOraclev9i.appendString(buffer, '\'');
                SSBDataBaseOraclev9i.appendString(buffer, logFile.getFileName());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, '\'');
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, ')');
            }
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "SIZE");
            this.appendStringWithSpace(buffer, logFile.getSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, logFile.getMeasureUnit());
            if (!logFile.getReuse().equalsIgnoreCase("YES")) continue;
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "REUSE");
        }
    }

    private void appendMaxLogFiles(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        int maxLogFiles = dataBase.getMaxLogFiles();
        buffer.append(NEWLINE);
        buffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MAXLOGFILES");
        this.appendStringWithSpace(buffer, maxLogFiles);
    }

    private void appendMaxLogMembers(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        int maxLogMembers = dataBase.getMaxLogMembers();
        buffer.append(NEWLINE);
        buffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MAXLOGMEMBERS");
        this.appendStringWithSpace(buffer, maxLogMembers);
    }

    private void appendMaxLogHistory(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        int maxLogHistory = dataBase.getMaxLogHistory();
        buffer.append(NEWLINE);
        buffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MAXLOGHISTORY");
        this.appendStringWithSpace(buffer, maxLogHistory);
    }

    private void appendMaxDataFiles(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        int maxDataFiles = dataBase.getMaxDataFiles();
        buffer.append(NEWLINE);
        buffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MAXDATAFILES");
        this.appendStringWithSpace(buffer, maxDataFiles);
    }

    private void appendMaxInstances(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        int maxInstances = dataBase.getMaxInstances();
        buffer.append(NEWLINE);
        buffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MAXINSTANCES");
        this.appendStringWithSpace(buffer, maxInstances);
    }

    private void appendArchiveLog(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        String archiveLog = dataBase.getArchiveLog();
        if (archiveLog != null && archiveLog.equalsIgnoreCase("YES")) {
            buffer.append(NEWLINE);
            buffer.append(" --  ").append("    ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "ARCHIVELOG");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE);
            buffer.append(" --  ").append("    ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "NOARCHIVELOG");
        }
    }

    private void appendForceLogging(StringBuffer buffer, DataBaseOraclev9i database, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(database.getForceLogging())) {
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "FORCE");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "LOGGING");
        }
    }

    private void appendCharacterSet(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        String characterSet = dataBase.getCharacterSet();
        if (!"".equalsIgnoreCase(characterSet)) {
            buffer.append(NEWLINE);
            buffer.append(" --  ").append("    ").append("CHARACTER SET ").append(characterSet);
        }
    }

    private void appendNationalCharacterSet(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        String nationalCharacterSet = dataBase.getNationalCharacterSet();
        if (!"".equalsIgnoreCase(nationalCharacterSet)) {
            buffer.append(NEWLINE);
            buffer.append(" --  ").append("    ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "NATIONAL CHARACTER SET");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, nationalCharacterSet);
        }
    }

    private void appendDataFiles(StringBuffer buffer, DataBaseOraclev9i dataBase) {
        DataFileSetOracle dataFileSet = ((StorageDesignOracle)dataBase.getStorageDesign()).getDataFileSet();
        Iterator setIt = dataFileSet.iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (dataFile.getDataBase() == null || !dataFile.getDataBase().toString().equalsIgnoreCase(dataBase.toString())) continue;
            if (!b) {
                buffer.append(NEWLINE);
                buffer.append(" --  ").append("    ").append("DATAFILE");
                b = true;
            } else {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, ',');
            }
            buffer.append(NEWLINE);
            buffer.append(" --  ").append("    ").append("    ");
            SSBDataBaseOraclev9i.appendString(buffer, '\'');
            SSBDataBaseOraclev9i.appendString(buffer, dataFile.getFileName());
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, '\'');
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "SIZE");
            this.appendStringWithSpace(buffer, dataFile.getSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            if (dataFile.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getNextBlockSizeUnit());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getMaxSizeUnit());
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendDataFiles(StringBuffer buffer, UndoTablespaceOraclev9i tableSpace, boolean prettyPrint) {
        Iterator setIt = tableSpace.getDfiles().iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (!b) {
                SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            buffer.append("    ").append(this.addQuotes(dataFile.getFileName(), true));
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "SIZE");
            this.appendStringWithSpace(buffer, dataFile.getSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            if (dataFile.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getNextBlockSizeUnit());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, dataFile.getMaxSizeUnit());
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendExtentManagement(StringBuffer buffer, DataBaseOraclev9i database, boolean prettyPrint) {
        if (database.getExtentManagement().equalsIgnoreCase("LOCAL")) {
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "EXTENT");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MANAGEMENT");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "LOCAL");
        }
    }

    private void appendTempTablespace(StringBuffer buffer, DataBaseOraclev9i database, boolean prettyPrint) {
        if (database.getTempTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            TemporaryTablespaceOraclev9i ts = database.getTempTablespace();
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "TEMPORARY");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            this.appendTempFile(buffer, ts, prettyPrint);
            this.appendExtent(buffer, ts, prettyPrint);
        }
    }

    private void appendTempFile(StringBuffer buffer, TemporaryTablespaceOraclev9i ts, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(ts.getFilename().trim())) {
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "TEMPFILE");
            SSBDataBaseOraclev9i.appendString(buffer, '\'');
            SSBDataBaseOraclev9i.appendString(buffer, ts.getFilename());
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, '\'');
            if (ts.getSize() != 0L) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "SIZE");
                this.appendStringWithSpace(buffer, ts.getSize());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, ts.getMeasureUnitSize());
            }
            if ("YES".equalsIgnoreCase(ts.getReuse())) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "REUSE");
            }
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, ts.getAutoextend());
            if (ts.getAutoextend().equalsIgnoreCase("ON")) {
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, ts.getNextBlockSize());
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "K");
                SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MAXSIZE");
                if (ts.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "UNLIMITED");
                } else {
                    SSBDataBaseOraclev9i.appendStringWithSpace(buffer, ts.getMaxSize());
                    SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "K");
                }
            }
        }
    }

    private void appendExtent(StringBuffer buffer, TemporaryTablespaceOraclev9i ts, boolean prettyPrint) {
        if (ts.getUniformSize() != 0L) {
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "EXTENT");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "MANAGEMENT");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "LOCAL");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "UNIFORM");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "SIZE");
            this.appendStringWithSpace(buffer, ts.getUniformSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, ts.getMeasureUnitUniformSize());
        }
    }

    private void appendUndoTablespace(StringBuffer buffer, DataBaseOraclev9i database, boolean prettyPrint) {
        if (database.getUndoTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            UndoTablespaceOraclev9i ts = database.getUndoTablespace();
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "UNDO");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            this.appendDataFiles(buffer, ts, prettyPrint);
        }
    }

    private void appendTimeZone(StringBuffer buffer, DataBaseOraclev9i database, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(database.getTimeZone())) {
            SSBDataBaseOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "SET");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, "TIME_ZONE");
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, '=');
            SSBDataBaseOraclev9i.appendString(buffer, '\'');
            SSBDataBaseOraclev9i.appendString(buffer, database.getTimeZone());
            SSBDataBaseOraclev9i.appendStringWithSpace(buffer, '\'');
        }
    }
}

