/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBUserOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        UserOraclev10g user = (UserOraclev10g)object;
        this.storageDesign = user.getStorageDesign();
        this.appendPrompt(buffer, user, "USER");
        this.appendComment(oldbuffer, user);
        SSBUserOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBUserOraclev10g.appendStringWithSpace(buffer, "USER");
        SSBUserOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
        advancedComment = buffer.toString();
        this.appendAuthenticationType(buffer, user, prettyPrint);
        this.appendDefaultTableSpace(buffer, user, prettyPrint);
        this.appendTempTableSpace(buffer, user, prettyPrint);
        this.appendQuotaItems(buffer, user, prettyPrint);
        this.appendProfile(buffer, user, prettyPrint);
        this.appendPasswordExpire(buffer, user, prettyPrint);
        this.appendAccountLock(buffer, user, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateUser();
        this.appendRolesAndPrivileges(oldbuffer, user, prettyPrint);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof UserOraclev10g && ((UserOraclev10g)object).isMarkedGenerate();
    }

    private void appendAuthenticationType(StringBuffer buffer, UserOraclev10g user, boolean prettyPrint) {
        String authType = user.getAuthType();
        SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBUserOraclev10g.appendStringWithSpace(buffer, "IDENTIFIED");
        if (authType.equalsIgnoreCase("BY_PASSWORD")) {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBUserOraclev10g.appendStringWithSpace(buffer, user.decodeIdentifier());
        } else if (authType.equalsIgnoreCase("EXTERNALLY")) {
            if (user.decodeIdentifier().trim().equals("")) {
                SSBUserOraclev10g.appendStringWithSpace(buffer, "EXTERNALLY");
            } else {
                SSBUserOraclev10g.appendStringWithSpace(buffer, "EXTERNALLY AS ");
                SSBUserOraclev10g.appendStringWithSpace(buffer, user.decodeIdentifier());
            }
        } else if (user.decodeIdentifier().trim().equals("")) {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "GLOBALLY");
        } else {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "GLOBALLY AS ");
            SSBUserOraclev10g.appendStringWithSpace(buffer, user.decodeIdentifier());
        }
    }

    private void appendDefaultTableSpace(StringBuffer buffer, UserOraclev10g user, boolean prettyPrint) {
        if (user.getDefTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            String tableSpace = this.storageDesign.getFormatedName(user.getDefTableSpace());
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBUserOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            SSBUserOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBUserOraclev10g.appendStringWithSpace(buffer, tableSpace);
        }
    }

    private void appendTempTableSpace(StringBuffer buffer, UserOraclev10g user, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if (user.getTempTableSpace() != null) {
                SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBUserOraclev10g.appendStringWithSpace(buffer, "TEMPORARY");
                SSBUserOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBUserOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user.getTempTableSpace()));
            } else if (!"".equalsIgnoreCase(user.getTempTSGroupName())) {
                SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBUserOraclev10g.appendStringWithSpace(buffer, "TEMPORARY");
                SSBUserOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBUserOraclev10g.appendStringWithSpace(buffer, user.getTempTSGroupName());
            }
        }
    }

    private void appendQuotaItems(StringBuffer buffer, UserOraclev10g user, boolean prettyPrint) {
        QuotaItemSetOracle qisOracle = ((StorageDesignOracle)this.storageDesign).getQuotaItemSet();
        List quotaItems = qisOracle.getElementsList();
        for (QuotaItemOracle quotaItem : quotaItems) {
            if (quotaItem.getUser() == null || quotaItem.getTableSpace() == null || !quotaItem.getUser().toString().equalsIgnoreCase(user.toString())) continue;
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBUserOraclev10g.appendStringWithSpace(buffer, "QUOTA");
            SSBUserOraclev10g.appendStringWithSpace(buffer, quotaItem.getSize());
            SSBUserOraclev10g.appendStringWithSpace(buffer, "ON");
            SSBUserOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(quotaItem.getTableSpace()));
        }
    }

    private void appendProfile(StringBuffer buffer, UserOraclev10g user, boolean prettyPrint) {
        String profile = user.getProfile();
        if (!"".equalsIgnoreCase(profile)) {
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBUserOraclev10g.appendStringWithSpace(buffer, "PROFILE");
            SSBUserOraclev10g.appendStringWithSpace(buffer, profile);
        }
    }

    private void appendPasswordExpire(StringBuffer buffer, UserOraclev10g user, boolean prettyPrint) {
        String passExpire = user.getPasswordExpire();
        if (passExpire.equalsIgnoreCase("YES")) {
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBUserOraclev10g.appendStringWithSpace(buffer, "PASSWORD EXPIRE");
        }
    }

    private void appendAccountLock(StringBuffer buffer, UserOraclev10g user, boolean prettyPrint) {
        String accountLock = user.getAccountLock();
        SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if (accountLock.equalsIgnoreCase("YES")) {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "ACCOUNT LOCK");
        } else {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "ACCOUNT UNLOCK");
        }
    }

    private void appendRolesAndPrivileges(StringBuffer oldbuffer, UserOracle user, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        String roles = user.getRolesNames().trim();
        String rolesAdminOption = user.getRolesWithAdminOptionNames().trim();
        String privileges = user.getPrivileges();
        String privilegesAdminOption = user.getPrivilegesWithAdminOption();
        if (!"".equalsIgnoreCase(roles)) {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBUserOraclev10g.appendStringWithSpace(buffer, roles);
            SSBUserOraclev10g.appendStringWithSpace(buffer, "TO");
            SSBUserOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(rolesAdminOption)) {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBUserOraclev10g.appendStringWithSpace(buffer, rolesAdminOption);
            SSBUserOraclev10g.appendStringWithSpace(buffer, "TO");
            SSBUserOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
            buffer.append(" WITH ADMIN OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(privileges)) {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBUserOraclev10g.appendStringWithSpace(buffer, privileges);
            SSBUserOraclev10g.appendStringWithSpace(buffer, "TO");
            SSBUserOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(privilegesAdminOption)) {
            SSBUserOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBUserOraclev10g.appendStringWithSpace(buffer, privilegesAdminOption);
            SSBUserOraclev10g.appendStringWithSpace(buffer, "TO");
            SSBUserOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(user));
            buffer.append(" WITH ADMIN OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUserOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }
}

