/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UndoTablespaceOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBUndoTablespaceOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        UndoTablespaceOraclev10g tableSpace = (UndoTablespaceOraclev10g)object;
        this.storageDesign = tableSpace.getStorageDesign();
        if (!tableSpace.isNullInstance() && tableSpace != null) {
            this.appendPrompt(buffer, tableSpace, "UNDO TABLESPACE");
            this.appendComment(oldbuffer, tableSpace);
            this.appendCreate(buffer, tableSpace);
            advancedComment = buffer.toString();
            this.appendDataFiles(buffer, tableSpace, prettyPrint);
            this.appendExtentManagement(buffer, prettyPrint);
            this.appendRetention(buffer, tableSpace, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUndoTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUndoTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateTablespace();
        }
    }

    private void appendCreate(StringBuffer buffer, UndoTablespaceOraclev10g tableSpace) {
        this.appendCreate(buffer);
        if (!"".equalsIgnoreCase(tableSpace.getFileType())) {
            SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, tableSpace.getFileType());
        }
        SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "UNDO");
        SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
        SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
    }

    private void appendDataFiles(StringBuffer buffer, UndoTablespaceOraclev10g tableSpace, boolean prettyPrint) {
        if (tableSpace.getDfiles().isEmpty() && tableSpace.getOracleManagesFiles().equalsIgnoreCase("NO")) {
            SSBUndoTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "--  WARNING: Tablespace has no data files defined");
            DDLFileMaker.incrementWarnings();
        }
        Iterator setIt = tableSpace.getDfiles().iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (!b) {
                SSBUndoTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBUndoTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            String filename = dataFile.getFileName().trim();
            if (!filename.isEmpty()) {
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, this.addQuotes(filename, true));
            }
            if (dataFile.getSize() > 0L) {
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "SIZE");
                this.appendStringWithSpace(buffer, dataFile.getSize());
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            }
            if (dataFile.getReuse().equalsIgnoreCase("YES") && !filename.isEmpty()) {
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, dataFile.getNextBlockSizeUnit());
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSizeUnit());
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendExtentManagement(StringBuffer buffer, boolean prettyPrint) {
        SSBUndoTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "EXTENT");
        SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "MANAGEMENT");
        SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "LOCAL");
    }

    private void appendRetention(StringBuffer buffer, UndoTablespaceOraclev10g tableSpace, boolean prettyPrint) {
        SSBUndoTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, "RETENTION");
        SSBUndoTablespaceOraclev10g.appendStringWithSpace(buffer, tableSpace.getRetention());
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof UndoTablespaceOraclev10g && ((UndoTablespaceOraclev10g)object).isMarkedGenerate();
    }
}

