/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBIndexOraclev10g;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLViewer;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;

public class SSBTableOraclev10g
extends AbstractSSBOracle {
    private SSBIndexOraclev10g ssbIndex = null;
    protected StorageDesignOraclev10g storageDesign;
    protected Table table;
    protected TableProxyOraclev10g tableProxy = null;
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxyOraclev10g && ((TableProxyOracle)object).getSnapshot() == null;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        Design design;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        this.table = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            this.table = (Table)object;
            design = this.table.getDesign();
            RDBMSSite site = this.table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, this.table);
            this.tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        } else if (object instanceof TableProxyOraclev10g) {
            this.tableProxy = (TableProxyOraclev10g)object;
            this.table = (Table)this.tableProxy.getObject();
            design = this.table.getDesign();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(this.table.getSelectedRDBMSSite(), this.table);
        } else {
            return;
        }
        if (this.table != null && DDLViewer.HIVE_DDL) {
            try {
                this.appendHiveDDL(buffer, this.table, prettyPrint);
                if (buffer.length() > 10) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, "");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        if (this.tableProxy != null && !this.tableProxy.isMarkedGenerate()) {
            this.appendIndexes(oldbuffer, this.tableProxy, prettyPrint);
            return;
        }
        if (this.table != null) {
            if (this.table.getTypeSubstitution() == null) {
                this.appendAutoIncrementSequences(oldbuffer, this.table, prettyPrint);
                if (this.tableProxy != null && this.tableProxy.isCommentChanged()) {
                    this.appendComment(oldbuffer, this.tableProxy);
                } else {
                    this.appendComment(oldbuffer, this.table);
                }
                if (this.tableProxy != null && this.tableProxy.getName().length() > this.tableProxy.getMaxNameLength()) {
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + this.tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                this.appendBeforeCreateScript(oldbuffer, prettyPrint, this.table);
                this.appendPrompt(buffer, this.table, "TABLE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CREATE");
                if (this.tableProxy == null) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.table));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, this.table, null, prettyPrint);
                    this.appendOid(buffer, this.table, null, prettyPrint);
                } else {
                    if ("YES".equalsIgnoreCase(this.tableProxy.getTemporary())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "TEMPORARY");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.tableProxy));
                        advancedComment = buffer.toString();
                        this.appendElementList(buffer, this.table, this.tableProxy, prettyPrint);
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "ON");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "COMMIT");
                        if ("YES".equalsIgnoreCase(this.tableProxy.getTempPreserveRows())) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "PRESERVE ROWS");
                        } else {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "DELETE ROWS");
                        }
                        this.appendOid(buffer, this.table, null, prettyPrint);
                        TemporaryTablespaceOracle tablespace = this.tableProxy.getTemporaryTablespace();
                        if (tablespace != null && this.storageDesign instanceof StorageDesignOraclev11g && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace));
                        }
                        if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "CACHE");
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
                        }
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.tableProxy));
                        advancedComment = buffer.toString();
                        this.appendElementList(buffer, this.table, this.tableProxy, prettyPrint);
                        this.appendOid(buffer, this.table, this.tableProxy, prettyPrint);
                        this.appendCluster(buffer, this.tableProxy, prettyPrint);
                        if (!"EXTERNAL".equalsIgnoreCase(this.tableProxy.getOrganization())) {
                            this.appendColumnProperties(buffer, this.tableProxy, prettyPrint);
                            this.appendPartitionList(buffer, this.tableProxy, prettyPrint);
                            if (this.tableProxy.getCluster() == null) {
                                if (!"INDEX".equals(this.tableProxy.getOrganization())) {
                                    if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                        SSBTableOraclev10g.appendStringWithSpace(buffer, "CACHE");
                                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
                                    }
                                }
                                if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                    SSBTableOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
                                    if (!"".equalsIgnoreCase(this.tableProxy.getDegree())) {
                                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.tableProxy.getDegree());
                                    }
                                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
                                }
                            }
                        } else if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
                            if (!"".equalsIgnoreCase(this.tableProxy.getDegree())) {
                                SSBTableOraclev10g.appendStringWithSpace(buffer, this.tableProxy.getDegree());
                            }
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
                        }
                    }
                    if (!"EXTERNAL".equalsIgnoreCase(this.tableProxy.getOrganization())) {
                        this.appendRowDependency(buffer, prettyPrint);
                        this.appendRowMovement(buffer, prettyPrint);
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementCreateTable();
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                if (!"EXTERNAL".equalsIgnoreCase(this.tableProxy.getOrganization())) {
                    if (this.tableProxy != null) {
                        this.appendAdditionalValidTimes(oldbuffer, this.table, this.tableProxy, prettyPrint);
                        this.appendColumnCheckConstraints(oldbuffer, this.tableProxy, prettyPrint);
                        SSBTableOraclev10g.appendExistenceDependencyConstraints(oldbuffer, this.tableProxy, prettyPrint, this, String.valueOf(';'), 30);
                        SSBTableOraclev10g.appendOptionalFKCheckConstraints(oldbuffer, this.tableProxy, prettyPrint, this, String.valueOf(';'), 30);
                        if (this.getArcConstrHandler() != null) {
                            this.getArcConstrHandler().appendArcConstraints(oldbuffer, this.tableProxy, prettyPrint);
                        }
                    }
                    if (this.table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                        this.appendTableCommentOn(oldbuffer, this.table, this.tableProxy, prettyPrint);
                    }
                    if (this.tableProxy != null) {
                        this.appendIndexes(oldbuffer, this.tableProxy, prettyPrint);
                        this.appendPermissions(oldbuffer, this.tableProxy, prettyPrint);
                        if (this.table.getDesign().getAppView().getSettings().isGenerateTypeSubstTriggers()) {
                            this.appendSubstitutionTrigger(oldbuffer, this.table, this.tableProxy, prettyPrint);
                            this.appendColumnSubstitutionTrigger(oldbuffer, this.table, this.tableProxy, prettyPrint);
                        }
                    }
                } else if (this.tableProxy != null) {
                    this.appendPermissions(oldbuffer, this.tableProxy, prettyPrint);
                }
                this.appendAfterCreateScript(oldbuffer, prettyPrint, this.table);
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            } else {
                SSBTableOraclev10g.appendStringWithSpace(oldbuffer, "-- Table " + this.table.getName() + ": is part of type substitution hierarchy");
            }
        }
        SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
    }

    private void appendRowDependency(StringBuffer buffer, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(this.tableProxy.getRowDependency())) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ROWDEPENDENCIES");
            ClusterOracle cluster = this.tableProxy.getCluster();
            if (cluster != null && !cluster.getRowDependency().equalsIgnoreCase("YES")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Cluster has different ROWDEPENDENCIES setting");
                DDLFileMaker.incrementErrors();
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOROWDEPENDENCIES");
        }
    }

    private void appendRowMovement(StringBuffer buffer, boolean prettyPrint) {
        if (!"INDEX".equalsIgnoreCase(this.tableProxy.getOrganization()) || "YES".equalsIgnoreCase(this.tableProxy.getPartitioned())) {
            if ("ENABLE".equalsIgnoreCase(this.tableProxy.getParttitionedRowMovement())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ROW MOVEMENT");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ROW MOVEMENT");
            }
        }
    }

    protected void appendAutoIncrementSequences(StringBuffer buffer, Table table, boolean prettyPrint) {
    }

    private void appendSubstitutionTrigger(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (table.isBST() && table.getSubTypeSubstitutions().size() > 0) {
            String types = "";
            Iterator it = table.getAllowedStrTypeInstances().iterator();
            boolean first = true;
            while (it.hasNext()) {
                StructuredType st = (StructuredType)it.next();
                StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                if (stp == null || !stp.getStructuredType().isInstantiable()) continue;
                String formattedLongName = this.storageDesign.getFormatedLongNameDDL(stp);
                if (first) {
                    types = st.getAllSubTypes().size() > 0 ? "ONLY " + formattedLongName : formattedLongName;
                    first = false;
                    continue;
                }
                types = types + ", " + (st.getAllSubTypes().size() > 0 ? "ONLY " + formattedLongName : formattedLongName);
            }
            if (!"".equals(types)) {
                ModelIDObject tableOwner;
                String tr_name = this.storageDesign.getFormatedName("OBJ_SUBS_TR_" + this.getStringWithMaxLength(tableProxy.getName(), 18));
                if (this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && (tableOwner = tableProxy.getSchemaImplementingObject()) != null) {
                    tr_name = this.storageDesign.getFormatedName(tableOwner) + '.' + tr_name;
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CREATE OR REPLACE TRIGGER " + tr_name);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BEFORE INSERT ON " + this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "FOR EACH ROW");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BEGIN");
                this.appendCWDTableMeta(buffer, table, tableProxy, prettyPrint);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, " IF :new.object_value IS NOT OF ( " + types + " ) THEN");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "  raise_application_error(-20222,' Only instances of " + types.replaceAll("ONLY ", "") + " are permitted');");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, " END IF;");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "END;");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "/");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    private void appendCWDTableMeta(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        List list = table.getAllSubstitutionTables();
        if (list.size() > 0) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < list.size(); ++i) {
            Table tab = (Table)list.get(i);
            StructuredType st = tab.getBasedOnStructuredType();
            StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
            String name = st.getName();
            if (stp != null) {
                name = this.storageDesign.getFormatedLongNameDDL(stp);
            }
            st = tab.getBasedOnStructuredType().getParentType();
            stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
            String parentName = st.getName();
            if (stp != null) {
                parentName = this.storageDesign.getFormatedLongNameDDL(stp);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "-- <cwd_ts_tab table=\"" + tab.getName() + "\" type=\"" + name + "\" parent_type=\"" + parentName + "\" />");
        }
    }

    private void appendColumnSubstitutionTrigger(StringBuffer buffer, Table table, TableProxy tableProxy, boolean prettyPrint) {
        List columns = this.getColumnsWithManyRestrictedSubType(table);
        if (columns.size() > 0) {
            boolean hasref = false;
            boolean first = true;
            String colnames = "";
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                ModelIDObject columnOrProxy = column;
                ColumnProxy cp = tableProxy.getColumnProxy(column.getObjectID());
                if (cp != null) {
                    columnOrProxy = cp;
                }
                names.add(columnOrProxy.getName());
                String formattedColName = this.storageDesign.getFormatedName(columnOrProxy);
                if (first) {
                    colnames = formattedColName;
                    first = false;
                } else {
                    colnames = colnames + ", " + formattedColName;
                }
                if (!column.isReference()) continue;
                hasref = true;
            }
            if (!"".equals(colnames)) {
                Column column;
                ModelIDObject tableOwner;
                String tr_name = this.storageDesign.getFormatedName(COLUMN_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 30 - COLUMN_SUBST_TR_PREFIX.length()));
                if (this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && (tableOwner = tableProxy.getSchemaImplementingObject()) != null) {
                    tr_name = this.storageDesign.getFormatedName(tableOwner) + '.' + tr_name;
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CREATE OR REPLACE TRIGGER " + tr_name);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BEFORE INSERT OR UPDATE OF " + colnames + " ON " + this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "FOR EACH ROW");
                if (hasref) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DECLARE ");
                    for (int i = 0; i < columns.size(); ++i) {
                        column = (Column)columns.get(i);
                        if (!column.isReference()) continue;
                        StructuredType st = (StructuredType)column.getDataType();
                        StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                        String st_name = stp != null ? this.storageDesign.getFormatedLongNameDDL(stp) : this.storageDesign.getFormatedLongNameDDL(st);
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        String colname = this.storageDesign.getFormatedName((String)names.get(i) + "$inst");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, " " + colname);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, st_name + ";");
                    }
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BEGIN");
                this.appendCWDColumnMeta(buffer, columns, prettyPrint);
                for (int i = 0; i < columns.size(); ++i) {
                    column = (Column)columns.get(i);
                    String colname = (String)names.get(i);
                    String types = "";
                    Iterator it = column.getPermittedSubTypes().iterator();
                    first = true;
                    while (it.hasNext()) {
                        StructuredType st = (StructuredType)it.next();
                        StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                        if (stp == null || !stp.getStructuredType().isInstantiable()) continue;
                        String formattedLongName = this.storageDesign.getFormatedLongNameDDL(stp);
                        if (first) {
                            types = st.getAllSubTypes().size() > 0 ? "ONLY " + formattedLongName : formattedLongName;
                            first = false;
                            continue;
                        }
                        types = types + ", " + (st.getAllSubTypes().size() > 0 ? "ONLY " + formattedLongName : formattedLongName);
                    }
                    if (column.isReference()) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, " SELECT deref(:new." + colname + ") INTO " + colname + "$inst FROM DUAL;");
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, " IF " + colname + "$inst IS NOT OF ( " + types + " ) THEN");
                    } else {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, " IF :new." + colname + " IS NOT OF ( " + types + " ) THEN");
                    }
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "  raise_application_error(-20222,'Column " + colname + " - Only instances of " + types.replaceAll("ONLY ", "") + " are permitted');");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, " END IF;");
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "END;");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "/");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    private void appendCWDColumnMeta(StringBuffer buffer, List columns, boolean prettyPrint) {
        if (columns.size() > 0) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            for (StructuredType st : column.getPermittedSubTypes()) {
                StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                String name = st.getName();
                if (stp != null) {
                    name = stp.getLongNameDDL();
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "-- <cwd_ts_column column=\"" + column.getName() + "\" type=\"" + name + "\" />");
            }
        }
    }

    private void appendColumnProperties(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        ColumnProxy[] columnProxies = tableProxy.getColumnAndNestedColumnProxies();
        for (int i = 0; i < columnProxies.length; ++i) {
            ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)columnProxies[i];
            Datatype datatype = columnProxy.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                    continue;
                }
                this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
        }
    }

    private void appendXMLTypeColumnProps(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        Column column = columnProxy.getColumn();
        if (column.isReference() && column.getUse() == 3) {
            return;
        }
        boolean storeAsBinaryXml = false;
        String allowAnySchema = "";
        String allowNonSchema = "";
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev10g.appendStringWithSpace(buffer, "XMLTYPE");
        SSBTableOraclev10g.appendStringWithSpace(buffer, "COLUMN");
        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        if (columnProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
        } else {
            if (columnProxy instanceof ColumnProxyOraclev11g) {
                if (((ColumnProxyOraclev11g)columnProxy).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                } else if (((ColumnProxyOraclev11g)columnProxy).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                }
                allowAnySchema = ((ColumnProxyOraclev11g)columnProxy).getAllowAnySchema();
                allowNonSchema = ((ColumnProxyOraclev11g)columnProxy).getAllowNonSchema();
                storeAsBinaryXml = columnProxy.getStoreAs().equalsIgnoreCase("BINARY XML");
            }
            if (storeAsBinaryXml) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BINARY XML");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CLOB");
            }
            String lobSegmentName = columnProxy.getLobSegmentName();
            if (lobSegmentName != null && lobSegmentName.length() > 0) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (columnProxy.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getTablespace()));
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (columnProxy.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, columnProxy.getSCInitialExtent());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (columnProxy.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, columnProxy.getSCNextExtent());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, columnProxy.getSCPctIncrease());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, columnProxy.getSCMinExtents());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCMaxExtents());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, columnProxy.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && columnProxy.getSCFreelistGroups() > 1) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, columnProxy.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
            if (columnProxy.getChunk() > 0) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                this.appendStringWithSpace(buffer, columnProxy.getChunk());
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (columnProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "RETENTION");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                this.appendStringWithSpace(buffer, columnProxy.getPCTVersion());
            }
            if (columnProxy.getFreepools() > 0 && columnProxy.getSCFreelistGroups() <= 1) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                this.appendStringWithSpace(buffer, columnProxy.getFreepools());
            }
            this.appendStorageInRow(buffer, columnProxy.getStorageInRow(), prettyPrint);
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getCache());
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(columnProxy.getCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                String logging = columnProxy.getLogging();
                if (logging.equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if (logging.equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && this.isSecureFile(((ColumnProxyOraclev11g)columnProxy).getLobStorageType())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                }
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        this.appendXMLSchemaSpec(buffer, columnProxy.getXmlSchemaUrl(), columnProxy.getXmlSchemaElement(), storeAsBinaryXml, allowAnySchema, allowNonSchema, prettyPrint);
    }

    private void appendXMLSchemaSpec(StringBuffer buffer, String xmlSchemaUrl, String xmlSchemaElement, boolean storeAsBinaryXml, String allowAnySchema, String allowNonSchema, boolean prettyPrint) {
        if (xmlSchemaElement != null && xmlSchemaElement.length() > 0) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (xmlSchemaUrl != null && xmlSchemaUrl.length() > 0) {
                buffer.append("XMLSCHEMA").append(' ').append('\"').append(xmlSchemaUrl).append('\"');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            buffer.append("ELEMENT").append(' ').append('\"').append(xmlSchemaElement).append('\"').append(' ');
        }
        if (storeAsBinaryXml) {
            if (allowAnySchema.equals("YES")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ALLOW");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ANYSCHEMA");
            }
            if (allowNonSchema.equals("YES")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ALLOW");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NONSCHEMA");
            } else if (allowNonSchema.equals("NO")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DISALLOW");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NONSCHEMA");
            }
        }
    }

    private void appendVarrayColumnProp(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (this.hasVarrayClause(columnProxy)) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "VARRAY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, false);
            if (!columnProxy.getLobSegname().equals("")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
                if (columnProxy instanceof ColumnProxyOraclev11g) {
                    if (((ColumnProxyOraclev11g)columnProxy).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                    } else if (((ColumnProxyOraclev11g)columnProxy).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                    }
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, "LOB");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getLobSegname()));
            }
        }
    }

    private void appendOid(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "OBJECT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "IDENTIFIER");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "IS");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            }
            if (!(tableProxy == null || tableProxy.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxy.getOidIndexName()))) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxy.getOidIndexName())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getOidIndexName()));
                }
                if (tableProxy.getOidIndexSegment() != null) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    this.appendSegment(buffer, (SegmentOraclev10g)tableProxy.getOidIndexSegment(), false, prettyPrint, null, "");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
        }
    }

    private void appendObjectTypeColProperties(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (table.isBST() && tableProxy != null) {
            boolean first = true;
            Column[] cols = (Column[])table.getElements();
            for (int i = 0; i < cols.length; ++i) {
                Column column = cols[i];
                ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
                if (!this.shouldGenerateObjectPropDefinition(column, columnProxy)) continue;
                if (first) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendString(buffer, ' ');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                this.appendColumnOptions(buffer, tableProxy, column, columnProxy, prettyPrint);
                this.appendColumnRefConstraint(buffer, column, columnProxy, prettyPrint);
                this.appendColumnConstraints(buffer, column, columnProxy, prettyPrint);
            }
            boolean nestedColNotNullChecksRequired = false;
            for (Column nestedColumn : table.getNestedElements()) {
                if (!nestedColumn.isMandatory()) continue;
                nestedColNotNullChecksRequired = true;
            }
            if (nestedColNotNullChecksRequired) {
                if (first) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                }
                first = this.appendNestedColumnNotNullChecks(buffer, tableProxy, prettyPrint, first);
            }
            boolean TableChecksRequired = false;
            for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
                if (!constraint.getTableConstraint().isGenerateInDDL()) continue;
                String rule = constraint.getTableConstraint().getRule();
                String cname = constraint.getName().toUpperCase();
                if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                    cname = "";
                }
                if (!"".equals(cname) || "".equals(rule)) continue;
                TableChecksRequired = true;
            }
            if (TableChecksRequired) {
                if (first) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                }
                first = this.appendTableConstraintsDefinition(buffer, tableProxy, prettyPrint, first);
            }
            if (table.getOidPKColumns().size() > 0) {
                if (first) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                this.appendPK_ObjectType(buffer, table, tableProxy, prettyPrint);
            }
            if (!first) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyOraclev10g columnProxy) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String defaultValue = columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            return true;
        }
        if (column.isAutoIncrementColumn() && columnProxy.getDDLTypeForAutoIncCol().equals("DEFAULT_CLAUSE")) {
            return true;
        }
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxy.getWithRowId())) {
            return true;
        }
        return SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy);
    }

    private void appendPK_ObjectType(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        PKProxyOraclev10g pkProxy = this.getPKProxy(tableProxy);
        if (pkProxy != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if (!pkProxy.getName().startsWith("SYS_")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy));
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            boolean first = true;
            for (Column column : table.getOidPKColumns()) {
                ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
                String formatedName = this.storageDesign.getFormatedName(columnProxy);
                if (first) {
                    first = false;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, formatedName);
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendElementList(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxyOraclev10g columnProxy = null;
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        boolean ext_table = "EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization());
        if (table.getBasedOnStructuredType() != null) {
            StructuredTypeProxyOracle typeProxy;
            StructuredType type;
            ModelIDObject typeOrProxy = type = table.getBasedOnStructuredType();
            SSBTableOraclev10g.appendStringWithSpace(buffer, "OF");
            if (tableProxy != null && (typeProxy = (StructuredTypeProxyOracle)tableProxy.getStorageDesign().getProxy(type)) != null) {
                if (typeProxy.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBTableOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
                    SSBTableOraclev10g.appendString(buffer, '.');
                }
                typeOrProxy = typeProxy;
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeOrProxy));
            String typeName = ((ModelObject)typeOrProxy).getName();
            if (typeName.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
                if (tableProxy != null) {
                    boolean storeAsBinaryXml = false;
                    String allowAnySchema = "";
                    String allowNonSchema = "";
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "XMLTYPE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
                    if (tableProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
                    } else {
                        if (tableProxy instanceof TableProxyOraclev11g) {
                            if (((TableProxyOraclev11g)tableProxy).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                                SSBTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                            } else if (((TableProxyOraclev11g)tableProxy).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                                SSBTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                            }
                            allowAnySchema = ((TableProxyOraclev11g)tableProxy).getAllowAnySchema();
                            allowNonSchema = ((TableProxyOraclev11g)tableProxy).getAllowNonSchema();
                            storeAsBinaryXml = tableProxy.getStoreAs().equalsIgnoreCase("BINARY XML");
                        }
                        if (storeAsBinaryXml) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "BINARY XML");
                        } else {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "CLOB");
                        }
                        String lobSegmentName = tableProxy.getLobSegmentName();
                        if (lobSegmentName != null && lobSegmentName.length() > 0) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
                        }
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        if (tableProxy.getXmlTypeTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getXmlTypeTableSpace()));
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (tableProxy.getChunk() > 0) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                            this.appendStringWithSpace(buffer, tableProxy.getChunk());
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (tableProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "RETENTION");
                        } else {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                            this.appendStringWithSpace(buffer, tableProxy.getPCTVersion());
                        }
                        if (tableProxy.getFreepools() > 0) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                            this.appendStringWithSpace(buffer, tableProxy.getFreepools());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "1");
                        }
                        this.appendStorageInRow(buffer, tableProxy.getStorageInRow(), prettyPrint);
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, tableProxy.getXmlTypeCache());
                        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(tableProxy.getXmlTypeCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                            String logging = tableProxy.getXmlTypeLogging();
                            if (logging.equalsIgnoreCase("YES")) {
                                SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            } else if (logging.equalsIgnoreCase("NO")) {
                                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && this.isSecureFile(((TableProxyOraclev11g)tableProxy).getLobStorageType())) {
                                SSBTableOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                            }
                        }
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                    }
                    this.appendXMLSchemaSpec(buffer, tableProxy.getXmlSchemaUrl(), tableProxy.getXmlSchemaElement(), storeAsBinaryXml, allowAnySchema, allowNonSchema, prettyPrint);
                }
            } else {
                if (!table.isSubstitutable()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "AT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "AT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
            }
        } else if (columns.length == 0 && table.getValidTimeDimensions().size() == 0) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "-- No Columns");
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        } else {
            HashMap<Column, ColumnProxyOraclev10g> map = new HashMap<Column, ColumnProxyOraclev10g>();
            int max = 0;
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                if (tableProxy == null) continue;
                columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
                String fname = this.storageDesign.getFormatedName(columnProxy);
                int l = fname.length();
                if (max < l) {
                    max = l;
                }
                map.put(column, columnProxy);
            }
            boolean first = true;
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                if (column.isOid()) continue;
                if (first) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                if (tableProxy != null && (columnProxy = (ColumnProxyOraclev10g)map.get(column)) == null) {
                    columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
                }
                if (columnProxy.getName().length() > columnProxy.getMaxNameLength()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                    this.appendComment(buffer, columnProxy);
                } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                    this.appendComment(buffer, columnProxy.getObject());
                }
                if (this.endsWithNewline(buffer)) {
                    this.appendTab(buffer, prettyPrint, 1);
                } else {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                SSBTableOraclev10g.appendString(buffer, ' ');
                String fname = this.storageDesign.getFormatedName(columnProxy);
                SSBTableOraclev10g.appendStringWithSpace(buffer, fname, max - fname.length() + 1);
                String datatypeString = "";
                Datatype type = column.getDataType();
                if (type instanceof StructuredType || type instanceof CollectionType) {
                    if (!ext_table) {
                        RelationalObjectProxy proxy = this.storageDesign.getProxy(type);
                        if (proxy != null) {
                            datatypeString = this.storageDesign.getFormatedLongNameDDL(proxy);
                            if (column.isReference() && type instanceof StructuredType) {
                                datatypeString = "REF " + datatypeString;
                            }
                        }
                    } else {
                        int ml = columnProxy.getMaxLengthAsString();
                        datatypeString = ml > 0 ? (ml > 4000 ? "CLOB" : "VARCHAR2(" + String.valueOf(ml) + ")") : "VARCHAR2(4000)";
                    }
                }
                if (datatypeString.equals("") && (datatypeString = column.getDatatypeString(this.storageDesign.getRDBMSType().getName())).equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    datatypeString = datatypeString + " (4000)";
                }
                if (ext_table && datatypeString.toUpperCase().startsWith("RAW")) {
                    String s = column.getDataTypeSize();
                    int size = 0;
                    try {
                        size = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (size > 2000) {
                        datatypeString = "BLOB";
                    }
                }
                this.appendDatatype(buffer, datatypeString, columnProxy, prettyPrint);
                if (tableProxy == null || ext_table) continue;
                this.appendColumnOptions(buffer, tableProxy, column, columnProxy, prettyPrint);
                this.appendColumnRefConstraint(buffer, column, columnProxy, prettyPrint);
                this.appendColumnConstraints(buffer, column, columnProxy, prettyPrint);
            }
            if (tableProxy != null && !ext_table) {
                first = this.appendFirstValidTime(buffer, table, tableProxy, prettyPrint, first);
                this.appendNestedColumnNotNullChecks(buffer, tableProxy, prettyPrint, false);
                if ("INDEX".equalsIgnoreCase(tableProxy.getOrganization())) {
                    this.appendPKDefinitionConstraint(buffer, tableProxy, prettyPrint);
                }
                this.appendTableConstraintsDefinition(buffer, tableProxy, prettyPrint, false);
                this.appendRefPartitionFK(buffer, tableProxy, prettyPrint);
                this.appendSupplementalLoggings(buffer, tableProxy, prettyPrint);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected boolean appendFirstValidTime(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint, boolean first) {
        return first;
    }

    protected void appendRefPartitionFK(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
    }

    protected void appendDatatype(StringBuffer buffer, String datatype, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        SSBTableOraclev10g.appendStringWithSpace(buffer, datatype);
        if (datatype.equalsIgnoreCase("unknown")) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            DDLFileMaker.incrementErrors();
        } else if (datatype.equals("VARCHAR2") || datatype.equals("NVARCHAR2") || datatype.equals("RAW")) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: " + datatype + " size not specified");
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            DDLFileMaker.incrementErrors();
        } else if (datatype.equals("CHAR") || datatype.equals("NCHAR")) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "--  WARNING: CHAR size not specified");
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            DDLFileMaker.incrementWarnings();
        }
    }

    private void appendColumnRefConstraint(StringBuffer buffer, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        this.appendWithRowid(buffer, column, columnProxy, prettyPrint);
    }

    private void appendWithRowid(StringBuffer buffer, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxy.getWithRowId())) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "WITH");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ROWID");
        }
    }

    protected void appendColumnOptions(StringBuffer buffer, TableProxyOraclev10g tableProxy, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        this.appendWithDefaultDefinition(buffer, columnProxy);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(buffer, tableProxy, columnProxy, prettyPrint);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev10g.appendString(buffer, ' ');
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NULL");
        }
    }

    protected void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        String defaultValue = columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            Column column = columnProxy.getColumn();
            String dt = column.getDatatypeString(this.storageDesign.getRDBMSType().getName());
            String df = this.addQuotesToDefault(dt, defaultValue);
            SSBTableOraclev10g.appendStringWithSpace(buffer, df);
        }
    }

    private void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        if (SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy) && column.isGenerateConstraintInDDL()) {
            String text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy));
            String cname = column.getConstraintName();
            if (!cname.equals("") && !cname.toUpperCase().startsWith("SYS_") && cname.length() <= 30) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendString(buffer, text);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            SSBTableOraclev10g.appendConstraintState(buffer, columnProxy, true, prettyPrint);
        }
    }

    public static void appendConstraintState(StringBuffer buffer, ColumnProxyOracle columnProxy, boolean inline, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(columnProxy.getDeferrable())) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxy.getInitially())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if ("YES".equalsIgnoreCase(columnProxy.getEnable())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(columnProxy.getValidate())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if ("NO".equalsIgnoreCase(columnProxy.getEnable())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxy.getValidate())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if ("NO".equalsIgnoreCase(columnProxy.getValidate())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (columnProxy.getExceptionsTable() != null && !inline) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "EXCEPTIONS");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "INTO");
            SSBTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getStorageDesign().getFormatedLongNameDDL(columnProxy.getExceptionsTable()));
        }
    }

    private PKProxyOraclev10g getPKProxy(TableProxyOracle tableProxy) {
        KeyObject pk = ((Table)tableProxy.getObject()).getPK();
        if (pk != null) {
            return (PKProxyOraclev10g)((StorageDesignOraclev10g)tableProxy.getStorageDesign()).getPKProxySet().getProxy(pk.getObjectID());
        }
        return null;
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        PKProxyOraclev10g pk;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null && pk.isMarkedGenerate()) {
            Index ind = (Index)pk.getObject();
            if (!"".equalsIgnoreCase(pk.getColumns()) || !"".equals(ind.getIndexExpression())) {
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                if (pk.isCommentChanged() && !"".equalsIgnoreCase(pk.getComment())) {
                    this.appendComment(oldbuffer, pk);
                } else if (!"".equalsIgnoreCase(ind.getComment())) {
                    this.appendComment(oldbuffer, ind);
                }
                String pkName = pk.getName();
                if (pkName.length() > tableProxy.getMaxNameLength()) {
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                this.appendPrompt(buffer, tableProxy, "PRIMARY KEY ON");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ADD");
                if (!pkName.startsWith("SYS_")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                }
                advancedComment = buffer.toString();
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                if (!"".equals(ind.getIndexExpression())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ind.getIndexExpression());
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, pk.getColumns(this.storageDesign));
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                if (!"NO".equalsIgnoreCase(pk.getDeferrable())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(pk.getInitially())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                }
                if (!"NO".equalsIgnoreCase(pk.getUsingIndex())) {
                    this.appendUsingIndex(buffer, pk, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if ("YES".equalsIgnoreCase(pk.getEnable())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    }
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                } else {
                    if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                        if ("YES".equalsIgnoreCase(pk.getValidate())) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
                if (pk.getRely().equals("YES")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pk.getTableProxy()));
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                    advancedComment = buffer.toString();
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "RELY");
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementAlterTable();
                }
            }
        }
    }

    private void appendPKDefinitionConstraint(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        PKProxyOraclev10g pk;
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendString(buffer, ' ');
            if (!pk.getName().startsWith("SYS_")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, pk.getColumns(this.storageDesign));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (!("NO".equalsIgnoreCase(pk.getUsingIndex()) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "BY INDEX NAME".equalsIgnoreCase(pk.getUsingIndex()) && pk.getExistingIndex() != null)) {
                this.appendUsingIndex(buffer, pk, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(tableProxy.getSuplementalLogGroupName())) {
            this.appendComma(buffer);
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "SUPPLEMENTAL");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "LOG");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "GROUP");
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getSuplementalLogGroupName()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getSuplementalLogColumns()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (tableProxy.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ALWAYS");
            }
        }
    }

    private boolean appendTableConstraintsDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint, boolean first) {
        for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
            if (!constraint.getTableConstraint().isGenerateInDDL()) continue;
            String rule = constraint.getTableConstraint().getRule();
            String cname = constraint.getName().toUpperCase();
            if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                cname = "";
            }
            if (!"".equals(cname) || "".equals(rule)) continue;
            if (first) {
                first = false;
            } else {
                this.appendComma(buffer);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendString(buffer, ' ');
            SSBTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev10g.appendString(buffer, '(');
            SSBTableOraclev10g.appendString(buffer, rule);
            SSBTableOraclev10g.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, constraint, prettyPrint);
        }
        return first;
    }

    private void appendTableConstraintState(StringBuffer buffer, TableCheckConstraintOracle constraint, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(constraint.getDeferrable())) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(constraint.getInitially())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if ("YES".equalsIgnoreCase(constraint.getEnable())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if ("NO".equalsIgnoreCase(constraint.getEnable())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if ("NO".equalsIgnoreCase(constraint.getValidate())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (constraint.getExceptionsTable() != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "EXCEPTIONS");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "INTO");
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(constraint.getExceptionsTable()));
        }
    }

    private void appendUsingIndex(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev10g.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = pkProxy.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(pkProxy.getUsingIndex()) && pkProxy.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(pkProxy.getIndex(), true)) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pkProxy.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pkProxy.getUsingIndex())) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, pkProxy.getCreateIndexStatement());
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = this.tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                    this.getSSBIndex().appendPartitionList(buffer, pkProxy, this.tableProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                    this.appendGlobalIndex(buffer, pkProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                    this.appendGlobalIndexByHashQuantity(buffer, pkProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                    this.appendGlobalIndexByHashList(buffer, pkProxy, prettyPrint);
                }
                if (pkProxy.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)pkProxy.getIndexSegment(), false, prettyPrint, pkProxy.getTableSpace(), pkProxy.getLogging());
                } else {
                    if (pkProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy.getTableSpace()));
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(pkProxy.getLogging())) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(pkProxy.getLogging())) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (pkProxy.getIndexSort().equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (pkProxy.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "REVERSE");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (pkProxy.getComputeStatistics().equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (this.storageDesign instanceof StorageDesignOraclev11g) {
                    if (pkProxy.getCompress() > 0) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        this.appendStringWithSpace(buffer, pkProxy.getCompress());
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                }
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev10g.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = unique.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(unique.getUsingIndex()) && unique.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(unique.getIndex(), true)) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(unique.getUsingIndex())) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, unique.getCreateIndexStatement());
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = this.tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL".equalsIgnoreCase(unique.getUsingIndex())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                    this.getSSBIndex().appendPartitionList(buffer, unique, this.tableProxy, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                    this.appendGlobalIndex(buffer, unique, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                    this.appendGlobalIndexByHashQuantity(buffer, unique, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                    this.appendGlobalIndexByHashList(buffer, unique, prettyPrint);
                }
                if (unique.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)unique.getIndexSegment(), false, prettyPrint, unique.getTableSpace(), unique.getLogging());
                } else {
                    if (unique.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique.getTableSpace()));
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(unique.getLogging())) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(unique.getLogging())) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (unique.getIndexSort().equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (unique.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "REVERSE");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (unique.getComputeStatistics().equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (this.storageDesign instanceof StorageDesignOraclev11g) {
                    if (unique.getCompress() > 0) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        this.appendStringWithSpace(buffer, unique.getCompress());
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                }
            }
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, pkProxy, prettyPrint);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)pkProxy.getIndexGlobalPL();
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partList.getGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
            this.appendStringWithSpace(buffer, partList.getHashPQuantity());
            if (!"".equals(partList.getHashPTableSpaces())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getHashPTableSpaces()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if (!"".equals(partList.getIOTOverflowHashPTS())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getIOTOverflowHashPTS()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendHashPartitions(buffer, pkProxy, prettyPrint);
        }
    }

    private boolean appendHashPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        boolean result = false;
        Iterator it = indexProxy.getGlobalPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Object partition = it.next();
            if (!(partition instanceof IndexHashPartitionOraclev10g)) continue;
            IndexHashPartitionOraclev10g hashPartition = (IndexHashPartitionOraclev10g)partition;
            if (first) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (hashPartition.getTableSpace() != null) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
                }
                if (hashPartition.getOverflowTableSpace() != null) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getOverflowTableSpace()));
                }
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, IndexHashPartitionOraclev10g hashPartition, boolean prettyPrint) {
        IndexHashPartitionLobItemSetOraclev10g hashPLobItemSet = (IndexHashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartition.getStorageDesign()).getIndexHashPartitionLobItemSet();
        for (IndexHashPartitionLobItemOraclev10g hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getIndexHashPartition() == null || !hashPLobItem.getIndexHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, unique, prettyPrint);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)unique.getUsingIndexGlobalPL();
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partList.getGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
            this.appendStringWithSpace(buffer, partList.getHashPQuantity());
            if (!"".equals(partList.getHashPTableSpaces())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getHashPTableSpaces()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if (!"".equals(partList.getIOTOverflowHashPTS())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getIOTOverflowHashPTS()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendHashPartitions(buffer, unique, prettyPrint);
        }
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        StorageObjectCollection globalPartitions = indexProxy.getGlobalPartitions();
        Object[] partitionsArray = globalPartitions.toArray();
        for (int i = 0; i < partitionsArray.length; ++i) {
            if (partitionsArray[i] instanceof IndexGlobalPartitionOraclev10g) continue;
            return;
        }
        Arrays.sort(partitionsArray, new GlobalPossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>(partitionsArray.length);
        for (int i = 0; i < partitionsArray.length; ++i) {
            sortedList.add(partitionsArray[i]);
        }
        Iterator it = sortedList.iterator();
        boolean first = true;
        while (it.hasNext()) {
            IndexGlobalPartitionOraclev10g globalPartition = (IndexGlobalPartitionOraclev10g)it.next();
            if (first) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, globalPartition.getValueList());
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (globalPartition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev10g)globalPartition.getSegment(), false, prettyPrint, globalPartition.getTableSpace(), globalPartition.getLogging());
                continue;
            }
            if (globalPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            if (!this.storageDesign.isOpen() || !this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendTableCommentOn(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        block4: {
            block3: {
                if (tableProxy == null) break block3;
                this.appendCommentOn(buffer, tableProxy, prettyPrint);
                ColumnProxy[] columnProxies = tableProxy.getColumnProxies();
                ColumnProxy col = null;
                for (int i = 0; i < columnProxies.length; ++i) {
                    col = columnProxies[i];
                    String comment = col.getCommentInRDBMS() != null && col.isCommentInRDBMSChanged() ? col.getCommentInRDBMS() : col.getColumn().getCommentInRDBMS();
                    if (comment.equalsIgnoreCase("")) continue;
                    String name = this.storageDesign.getFormatedLongNameDDL(tableProxy) + '.' + this.storageDesign.getFormatedName(col);
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    StringBuffer tempBuffer = new StringBuffer();
                    SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "COMMENT ON");
                    SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "COLUMN");
                    SSBTableOraclev10g.appendStringWithSpace(tempBuffer, name);
                    String advancedComment = tempBuffer.toString();
                    SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "IS");
                    SSBTableOraclev10g.appendString(tempBuffer, '\'');
                    SSBTableOraclev10g.appendString(tempBuffer, this.replaceSingleQuote(comment));
                    SSBTableOraclev10g.appendStringWithSpace(tempBuffer, '\'');
                    this.appendToBuffer(buffer, tempBuffer, advancedComment);
                    SSBTableOraclev10g.appendNewLine(tempBuffer, prettyPrint, 0);
                    this.appendLineFinisher(tempBuffer, prettyPrint);
                    this.appendToBuffer(buffer, tempBuffer, advancedComment);
                }
                break block4;
            }
            if (table == null) break block4;
            String tableComment = table.getCommentInRDBMS();
            if (tableComment != null && !"".equalsIgnoreCase(tableComment)) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                StringBuffer tempBuffer = new StringBuffer();
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "COMMENT ON");
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "TABLE");
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, this.storageDesign.getFormatedLongNameDDL(table));
                String advancedComment = tempBuffer.toString();
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "IS");
                SSBTableOraclev10g.appendString(tempBuffer, '\'');
                SSBTableOraclev10g.appendString(tempBuffer, this.replaceSingleQuote(tableComment));
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, '\'');
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
                SSBTableOraclev10g.appendNewLine(tempBuffer, prettyPrint, 0);
                this.appendLineFinisher(tempBuffer, prettyPrint);
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
            }
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column col = (Column)columns[i];
                String columnComment = col.getCommentInRDBMS();
                if (columnComment == null || "".equalsIgnoreCase(columnComment)) continue;
                String name = this.storageDesign.getFormatedLongNameDDL(table) + '.' + this.storageDesign.getFormatedName(col);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                StringBuffer tempBuffer = new StringBuffer();
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "COMMENT ON");
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "COLUMN");
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, name);
                String advancedComment = tempBuffer.toString();
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, "IS");
                SSBTableOraclev10g.appendString(tempBuffer, '\'');
                SSBTableOraclev10g.appendString(tempBuffer, this.replaceSingleQuote(columnComment));
                SSBTableOraclev10g.appendStringWithSpace(tempBuffer, '\'');
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
                SSBTableOraclev10g.appendNewLine(tempBuffer, prettyPrint, 0);
                this.appendLineFinisher(tempBuffer, prettyPrint);
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
            }
        }
    }

    public void appendPartitionList(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PartitionListOraclev10g partitionList = (PartitionListOraclev10g)tableProxy.getPartitionList();
        if (partitionList != null) {
            this.tableProxy = tableProxy;
            this.table = (Table)tableProxy.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev10g)tableProxy.getStorageDesign();
            }
            String partitionType = partitionList.getPartitionType();
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, true, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                    if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        this.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                        if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                        }
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "1");
                    }
                } else {
                    this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                }
                this.appendPartitions(buffer, partitionList, true, true, prettyPrint);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "LIST");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                this.appendPartitions(buffer, partitionList, true, true, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
                this.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, partitionList, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "LIST");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, partitionList, prettyPrint);
            }
        }
    }

    protected void appendListSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "TEMPLATE");
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                ListStorageTemplatePartitionOraclev10g temp = (ListStorageTemplatePartitionOraclev10g)templates.getElement(i);
                if (i > 0) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                if (!"".equalsIgnoreCase(temp.getValueList())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, temp.getValueList());
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendHashSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (tableProxy.getListStorageTemplates().size() > 0) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "TEMPLATE");
            Iterator setIt = tableProxy.getListStorageTemplates().iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev10g partition = (HashPartitionOraclev10g)setIt.next();
                if (first) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                this.appendPartStorage(buffer, partition, prettyPrint);
            }
            if (!first) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendPartStorage(StringBuffer buffer, AbstractStorageObjectOracle template, boolean prettyPrint) {
        TableSpaceOracle tableSpace = null;
        TableSpaceOracle overflowTableSpace = null;
        String dataSegmentCompression = "";
        StorageObjectCollection lobs = null;
        AbstractStorageObjectOracle owningPartition = null;
        if (template instanceof PartitionOraclev11g) {
            tableSpace = ((PartitionOraclev11g)template).getTableSpace();
            dataSegmentCompression = ((PartitionOraclev11g)template).getDataSegmentCompression();
            lobs = ((PartitionOraclev11g)template).getLobs();
            owningPartition = ((PartitionOraclev11g)template).getSubPartitionOf();
        } else if (template instanceof HashPartitionOraclev10g) {
            tableSpace = ((HashPartitionOraclev10g)template).getTableSpace();
            overflowTableSpace = ((HashPartitionOraclev10g)template).getIotOverflowTablespace();
            lobs = ((HashPartitionOraclev10g)template).getLobs();
            owningPartition = ((HashPartitionOraclev10g)template).getSubPartitionOf();
        } else if (template instanceof ListStorageTemplatePartitionOraclev10g) {
            tableSpace = ((ListStorageTemplatePartitionOraclev10g)template).getTablespace();
            dataSegmentCompression = ((ListStorageTemplatePartitionOraclev10g)template).getDataSegmentCompression();
            lobs = ((ListStorageTemplatePartitionOraclev10g)template).getLobs();
            owningPartition = ((ListStorageTemplatePartitionOraclev10g)template).getSubPartitionOf();
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if (tableSpace != null) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (overflowTableSpace != null) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
            }
        }
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            if (dataSegmentCompression.equalsIgnoreCase("NO")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (dataSegmentCompression.equalsIgnoreCase("YES")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
        }
        if (lobs != null) {
            for (Object storageObject : lobs) {
                HashPartitionLobItemOraclev10g lobItem;
                if (storageObject instanceof LobStorageOraclev10g) {
                    LobStorageOraclev10g lobStorage = (LobStorageOraclev10g)storageObject;
                    if (lobStorage.getTableSpace() == null && lobStorage.getLobSegmentName().trim().equals("")) continue;
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    this.appendLobPartitioningStorage(buffer, lobStorage, lobStorage.getColumn(), lobStorage.getLobSegmentName(), lobStorage.getTableSpace(), prettyPrint);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOraclev10g) || (lobItem = (HashPartitionLobItemOraclev10g)storageObject).getTableSpace() == null) continue;
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                String lobSegName = lobItem.getName();
                if (owningPartition != null && (lobSegName.startsWith("SYS_LOB") || lobSegName.startsWith(lobItem.getIDPrefix()))) {
                    lobSegName = "";
                }
                this.appendLobPartitioningStorage(buffer, lobItem, lobItem.getLobColumn(), lobSegName, lobItem.getTableSpace(), prettyPrint);
            }
        }
    }

    protected void appendListPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        Iterator it = this.tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            ListPartitionOraclev10g partition = (ListPartitionOraclev10g)it.next();
            if (first) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (partition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev10g)partition.getSegment(), true, prettyPrint, partition.getTablespace(), partition.getLogging());
            } else {
                if (partition.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen()) {
                    String logging = partition.getLogging();
                    if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && logging.length() > 0) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        if (logging.equalsIgnoreCase("YES")) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                        } else if (logging.equalsIgnoreCase("NO")) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                        }
                    }
                }
            }
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (!this.table.isSpatialTable()) {
                for (LobStorageOracle lob : partition.getLobStorages()) {
                    this.appendLobStorage(buffer, (LobStorageOraclev10g)lob, prettyPrint);
                }
            }
            if (partitionList.getSubpartitionType().length() <= 0) continue;
            this.appendSubPartitions(buffer, partition, partitionList, prettyPrint);
        }
        if (!first) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, boolean appendValueList, boolean composite, boolean prettyPrint) {
        StorageObjectCollection partitions = this.tableProxy.getPartitions();
        if (partitions.size() > 0) {
            Object[] partitionsList = partitions.toArray();
            Arrays.sort(partitionsList, new PossitionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>(partitionsList.length);
            for (int i = 0; i < partitionsList.length; ++i) {
                sortedList.add(partitionsList[i]);
            }
            Iterator setIt = sortedList.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                Object partitionObj = setIt.next();
                if (!(partitionObj instanceof PartitionOracle)) continue;
                PartitionOracle partition = (PartitionOracle)partitionObj;
                if (first) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                if (appendValueList) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(buffer, partition.getValueList());
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (partition.getSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)partition.getSegment(), true, prettyPrint, partition.getTableSpace(), partition.getLogging());
                } else {
                    if (partition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTableSpace()));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if (partition.getLogging().equalsIgnoreCase("NO")) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if (partition.getLogging().equalsIgnoreCase("YES")) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
                if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                }
                SegmentOracle overflowSegment = partition.getIOTOverflowSegment();
                if (overflowSegment != null) {
                    TableSpaceOracle overflowTableSpace = overflowSegment.getTableSpace();
                    if (overflowTableSpace == null) {
                        overflowTableSpace = partition.getTableSpace();
                    }
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    this.appendSegment(buffer, (SegmentOraclev10g)overflowSegment, true, prettyPrint, overflowTableSpace, partition.getLogging());
                }
                if (!this.table.isSpatialTable()) {
                    for (LobStorageOracle lob : partition.getLobs()) {
                        this.appendLobStorage(buffer, (LobStorageOraclev10g)lob, prettyPrint);
                    }
                }
                if (!composite) continue;
                this.appendSubPartitions(buffer, partition, partitionList, prettyPrint);
            }
            if (!first) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            PartitionOraclev10g rangePartition;
            if (partition instanceof PartitionOraclev10g && !this.appendHashSubPartitions(buffer, (rangePartition = (PartitionOraclev10g)partition).getPartitions(), partitionList, prettyPrint) && rangePartition.getSubPartitionsQuantity() > 0) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                this.appendStringWithSpace(buffer, rangePartition.getSubPartitionsQuantity());
                if (!"".equalsIgnoreCase(rangePartition.getSubPartitionsTableSpaces())) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(rangePartition.getSubPartitionsTableSpaces()));
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST") && partition instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(buffer, ((PartitionOraclev10g)partition).getListPartitions(), prettyPrint);
        }
    }

    protected void appendListSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            boolean firstListPart = true;
            Iterator listSubpartitions = subpartitions.iterator();
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            while (listSubpartitions.hasNext()) {
                ListStorageTemplatePartitionOraclev10g listSubpartition = (ListStorageTemplatePartitionOraclev10g)listSubpartitions.next();
                if (!firstListPart) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                } else {
                    firstListPart = false;
                }
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!listSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listSubpartition));
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, listSubpartition.getValueList());
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, listSubpartition, prettyPrint);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        boolean result = false;
        if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            Iterator it = subpartitions.iterator();
            boolean first = true;
            while (it.hasNext()) {
                HashPartitionOraclev10g hashPartition = (HashPartitionOraclev10g)it.next();
                if (first) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                    result = true;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ' ');
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
                }
                this.appendPartStorage(buffer, hashPartition, prettyPrint);
            }
            if (!first) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
        return result;
    }

    protected boolean appendHashPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        boolean result = false;
        Iterator it = this.tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOraclev10g hashPartition = (HashPartitionOraclev10g)it.next();
            if (first) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOraclev10g hashPartition, boolean prettyPrint) {
        HashPartitionLobItemSetOraclev10g hashPLobItemSet = (HashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartition.getStorageDesign()).getHashPartitionLobItemSet();
        for (HashPartitionLobItemOraclev10g hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        SSBTableOraclev10g.appendStringWithSpace(buffer, "LOB");
        SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                DDLFileMaker.incrementErrors();
            }
        }
        SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        if (lobObject instanceof LobStorageOraclev11g) {
            String lobStorageType = ((LobStorageOraclev11g)lobObject).getLobStorageType();
            if (lobStorageType.equalsIgnoreCase("SECUREFILE")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
            } else if (lobStorageType.equalsIgnoreCase("BASICFILE")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
            }
        }
        if (!lobSegName.equalsIgnoreCase("")) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOraclev10g lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "LOB");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
            if (lobStorage instanceof LobStorageOraclev11g) {
                if (lobStorage.getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                } else if (lobStorage.getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                }
            }
            if (!lobStorage.getLobSegmentName().equalsIgnoreCase("")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getLobSegmentName()));
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
            if (lobStorage.getChunk() > 0) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                this.appendStringWithSpace(buffer, lobStorage.getChunk());
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "RETENTION");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                this.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                this.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            this.appendStorageInRow(buffer, lobStorage.getStorageInRow(), prettyPrint);
            if (this.isSecureFile(lobStorage.getLobStorageType())) {
                if (lobStorage.getCompression().equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getCompressionType());
                }
                if (lobStorage.getDuplication().equalsIgnoreCase("DEDUPLICATE")) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DEDUPLICATE");
                }
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getCache());
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                String logging = lobStorage.getLogging();
                if (logging.equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if (logging.equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && this.isSecureFile(lobStorage.getLobStorageType())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                }
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean isSecureFile(String lobStorageType) {
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            return !lobStorageType.equalsIgnoreCase("BASICFILE");
        }
        return lobStorageType.equalsIgnoreCase("SECUREFILE");
    }

    private void appendStorageInRow(StringBuffer buffer, String enableDisable, boolean prettyPrint) {
        if ("ENABLE".equalsIgnoreCase(enableDisable)) {
            if (!"INDEX".equals(this.tableProxy.getOrganization())) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORAGE IN ROW");
            }
        } else {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "STORAGE IN ROW");
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev10g segment, boolean pctUsed, boolean prettyPrint, TableSpaceOracle tableSpace, String logging) {
        if (segment != null && segment.isMarkedGenerate()) {
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                    this.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (pctUsed && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTUSED");
                    this.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                    if (segment.getInitrans() > 1) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                        this.appendStringWithSpace(buffer, segment.getInitrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "1");
                    }
                    if (!(this.storageDesign instanceof StorageDesignOraclev11g)) {
                        if (segment.getMaxTrans() > 1) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                            this.appendStringWithSpace(buffer, segment.getMaxTrans());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "255");
                        }
                    }
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (tableSpace != null) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                } else if (segment.getTableSpace() != null) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment.getTableSpace()));
                }
            }
            if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                boolean props = false;
                if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, segment.getSCFreeLists());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    props = true;
                }
                if (props) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        } else {
            if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                }
            }
        }
    }

    private void appendOrganization(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        boolean indexOrg = "INDEX".equalsIgnoreCase(tableProxy.getOrganization());
        if (indexOrg) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "INDEX");
        } else if ("EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization())) {
            this.appendExternalTableClause(buffer, tableProxy, prettyPrint);
            this.appendRejectLimit(buffer, tableProxy, prettyPrint);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() && !this.table.isBST()) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "HEAP");
        }
        if (!"EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization())) {
            if (tableProxy.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev10g)tableProxy.getSegment(), !indexOrg, prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging());
            } else {
                TableSpaceOracle tableSpace = tableProxy.getTableSpace();
                if (tableSpace != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName()) && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if ("YES".equalsIgnoreCase(tableProxy.getLogging())) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(tableProxy.getLogging())) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
        }
        if (indexOrg) {
            if (tableProxy.getIOTMappingTable().equalsIgnoreCase("YES")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "MAPPING TABLE");
            }
            if (tableProxy.getIotPctThreshold() > 0) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                this.appendStringWithSpace(buffer, tableProxy.getIotPctThreshold());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "50");
            }
            if (tableProxy.getIotCompress() > 0) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                this.appendStringWithSpace(buffer, tableProxy.getIotCompress());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            TableSpaceOracle overflowTableSpace = tableProxy.getIotOverflowTablespace();
            String overflowLogging = tableProxy.getIotOverflowLogging();
            SegmentOraclev10g overflowSegment = (SegmentOraclev10g)tableProxy.getIotOverflowSegment();
            ColumnProxy includingColumn = tableProxy.getIotIncluding();
            if (overflowTableSpace != null || !overflowLogging.equals("") || overflowSegment != null || includingColumn != null) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if (includingColumn != null) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "INCLUDING");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(includingColumn));
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                if (overflowTableSpace == null) {
                    overflowTableSpace = tableProxy.getTableSpace();
                }
                if (overflowLogging.equals("")) {
                    overflowLogging = tableProxy.getLogging();
                }
                if (overflowSegment != null) {
                    this.appendSegment(buffer, overflowSegment, true, prettyPrint, overflowTableSpace, overflowLogging);
                } else {
                    if (overflowTableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("NO".equalsIgnoreCase(overflowLogging)) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if ("YES".equalsIgnoreCase(overflowLogging)) {
                            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
            }
        } else if (!"EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization())) {
            if (tableProxy.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                this.appendCompressClause(buffer, tableProxy);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            this.appendInMemoryClause(buffer, tableProxy, prettyPrint);
        }
    }

    protected void appendCompressClause(StringBuffer buffer, TableProxyOracle tableProxy) {
        SSBTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
    }

    protected void appendInMemoryClause(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
    }

    private void appendCluster(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        ClusterOraclev10g cluster = (ClusterOraclev10g)tableProxy.getCluster();
        if (cluster != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "CLUSTER");
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(tableProxy.getClusterColumns())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getClusterColumns()));
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else {
            this.appendOrganization(buffer, tableProxy, prettyPrint);
            if (!this.table.isSpatialTable()) {
                for (int i = 0; i < tableProxy.getLobStorages().size(); ++i) {
                    this.appendLobStorage(buffer, (LobStorageOraclev10g)tableProxy.getLobStorages().getElement(i), prettyPrint);
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null) {
            UniqueSetOraclev10g uniqueSet = (UniqueSetOraclev10g)((StorageDesignOraclev10g)tableProxy.getStorageDesign()).getUniqueSet();
            Iterator it = uniqueSet.iterator();
            while (it.hasNext()) {
                UniqueOraclev10g unique = (UniqueOraclev10g)it.next();
                Index ind = (Index)unique.getObject();
                if (unique.getTableProxy() != tableProxy || !unique.isMarkedGenerate()) continue;
                if (unique.getColumnProxies().length == 0 && "".equals(ind.getIndexExpression())) {
                    SSBTableOraclev10g.appendStringWithSpace(oldbuffer, "-- Error - Unique Constraint " + unique.getTable() + '.' + unique.getName() + " doesn't have columns");
                    DDLFileMaker.incrementErrors();
                    continue;
                }
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                if (unique.isCommentChanged() && !"".equalsIgnoreCase(unique.getComment())) {
                    this.appendComment(oldbuffer, unique);
                } else if (!"".equalsIgnoreCase(unique.getObject().getComment())) {
                    this.appendComment(oldbuffer, unique.getObject());
                }
                String uniqueName = unique.getName();
                if (uniqueName.length() > tableProxy.getMaxNameLength()) {
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                ColumnProxy[] columns = unique.getColumnProxies();
                this.appendPrompt(buffer, tableProxy, "UNIQUE KEY ON");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ADD");
                if (!uniqueName.startsWith("SYS_")) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
                }
                advancedComment = buffer.toString();
                SSBTableOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                if (!"".equals(ind.getIndexExpression())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ind.getIndexExpression());
                } else {
                    for (int i = 0; i < columns.length; ++i) {
                        ColumnProxy column = columns[i];
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
                        if (i >= columns.length - 1) continue;
                        SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                    }
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                if (!"NO".equalsIgnoreCase(unique.getDeferrable())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(unique.getInitially())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                }
                if (!"NO".equalsIgnoreCase(unique.getUsingIndex())) {
                    this.appendUniqueUsingIndex(buffer, unique, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if ("YES".equalsIgnoreCase(unique.getEnable())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    }
                    if ("YES".equalsIgnoreCase(unique.getValidate())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                } else {
                    if (!"YES".equalsIgnoreCase(unique.getEnable())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                        if ("YES".equalsIgnoreCase(unique.getValidate())) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(unique.getValidate())) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
                if (!unique.getRely().equals("YES")) continue;
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getTableProxy()));
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
                advancedComment = buffer.toString();
                SSBTableOraclev10g.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    protected void appendNotNullDefinition(StringBuffer buffer, TableProxy tableProxy, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        String nncName = null;
        if (!this.table.getAppView().getSettings().notNullShortFormGeneration()) {
            String string = nncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : columnProxy.getColumn().getNotNullConstraintName();
            if (nncName != null && nncName.startsWith("SYS_")) {
                nncName = null;
            }
        }
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable()) || !"YES".equalsIgnoreCase(columnProxy.getNncEnable()) || !"YES".equalsIgnoreCase(columnProxy.getNncValidate()) || nncName != null && !"".equals(nncName)) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendString(buffer, ' ');
            if (nncName != null && !"".equals(nncName)) {
                if (nncName.length() > tableProxy.getMaxNameLength()) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Column " + tableProxy.getName() + "." + columnProxy.getName() + " check constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendString(buffer, ' ');
                    DDLFileMaker.incrementErrors();
                }
                nncName = this.storageDesign.getFormatedName(nncName);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, nncName);
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT NULL");
            this.appendNotNullConstraintState(buffer, columnProxy);
        } else {
            SSBTableOraclev10g.appendString(buffer, ' ');
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT NULL");
        }
    }

    private boolean appendNestedColumnNotNullChecks(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint, boolean first) {
        for (Column nestedColumn : this.table.getNestedElements()) {
            String nncName;
            ColumnProxyOraclev10g columnProxy;
            if (!nestedColumn.isMandatory() || (columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(nestedColumn.getObjectID())) == null) continue;
            if (first) {
                first = false;
            } else {
                this.appendComma(buffer);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendString(buffer, ' ');
            String string = nncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : nestedColumn.getNotNullConstraintName();
            if (nncName != null && !nncName.isEmpty() && !nncName.startsWith("SYS_")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nncName));
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            SSBTableOraclev10g.appendStringWithSpace(buffer, "IS");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT NULL");
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendNotNullConstraintState(buffer, columnProxy);
        }
        return first;
    }

    private void appendNotNullConstraintState(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable())) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxy.getNncInitially())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComments = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)tableProxy.getStorageDesign()).getPermissionsSet();
        for (PermissionsOraclev10g permissions : permissionsSet) {
            if (permissions.getTable() != null && permissions.getTable().equals(tableProxy)) {
                if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendComment(buffer, permissions);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivileges(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
                if (!permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivilegesWithGrantOption(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendGrantOption(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
            }
            if (permissions.getColumnsTable() == null || !permissions.getColumnsTable().equals(tableProxy)) continue;
            for (int i = 0; i < 2; ++i) {
                List<String> colEntries = i == 0 ? permissions.getColumnEntries() : permissions.getColumnWithGrantOptionEntries();
                for (String colEntry : colEntries) {
                    int commaIndex = colEntry.indexOf(44);
                    if (commaIndex <= -1) continue;
                    String colName = colEntry.substring(0, commaIndex).trim();
                    String colPriv = colEntry.substring(commaIndex + 1).trim();
                    if (colName.length() <= 0 || colPriv.length() <= 0) continue;
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, colPriv);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    ColumnProxy columnProxy = tableProxy.getColumnProxyByName(colName);
                    if (columnProxy != null) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(colName));
                    }
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    if (i > 0) {
                        this.appendGrantOption(buffer, permissions);
                    }
                    advancedComments = buffer.toString();
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
            }
        }
    }

    private void appendPrivileges(StringBuffer buffer, PermissionsOraclev10g permissions) {
        buffer.append(permissions.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        buffer.append(permissions.getPrivilegesWithGrantOption());
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        TableProxyOracle tableProxy = permissions.getTable();
        if (tableProxy == null) {
            tableProxy = permissions.getColumnsTable();
        }
        if (tableProxy != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getRole() == null) {
            SSBTableOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    public void appendIndexes(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (this.storageDesign == null) {
            this.storageDesign = (StorageDesignOraclev10g)tableProxy.getStorageDesign();
        }
        for (Object object : tableProxy.getIndexes()) {
            SSBIndexOraclev10g ssbIndex;
            if (object instanceof IndexProxyOracle && ((IndexProxyOracle)object).getIndex().isSpatialIndex() || !(ssbIndex = this.getSSBIndex()).canHandle(object)) continue;
            ssbIndex.doAppend(oldbuffer, object, prettyPrint);
        }
        Table table = (Table)tableProxy.getObject();
        this.appendIndexesForConstraints(oldbuffer, table, tableProxy);
    }

    private void appendNestedTableColumnProp(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev10g.appendStringWithSpace(buffer, "NESTED");
        SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, false);
        String storageTableName = columnProxy.getNtStorageTable();
        if (storageTableName.trim().isEmpty()) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "--  WARNING: Using column name as default storage_table name for nested column " + columnProxy.getName());
            DDLFileMaker.incrementWarnings();
            storageTableName = columnProxy.getName();
        }
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        SSBTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(storageTableName));
        if (!columnProxy.getAdditionalNTS().equals("")) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getAdditionalNTS());
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        if (!columnProxy.getNtReturn().equals("")) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "RETURN");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "AS");
            SSBTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getNtReturn());
        }
    }

    private void appendSubstitutableColumnClause(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint, boolean columnClause) {
        Column column = columnProxy.getColumn();
        Table table = (Table)column.getContainerWithKeyObject();
        if (table.isBST() && !table.isSubstitutable()) {
            return;
        }
        if (!column.isReference()) {
            if (column.isAllowSubtypeSubstitution()) {
                if (columnClause && (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1 || columnProxy.getSubtitutable().equals("ONLY FOR TYPE"))) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "IS");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "OF");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "TYPE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "ONLY");
                    if (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1) {
                        StructuredType st = (StructuredType)column.getPermittedSubTypes().get(0);
                        StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                        if (stp != null) {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(stp));
                        } else {
                            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(st));
                        }
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getElementType());
                    }
                    SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else if (columnProxy.getSubtitutable().equals("YES") || columnProxy.getSubtitutable().equals("NO")) {
                    if (columnClause) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    }
                    if (columnProxy.getSubtitutable().equals("NO")) {
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                    }
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "AT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if (columnClause) {
                        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                        SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    }
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "AT");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                }
            } else {
                if (columnClause) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                    SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                }
                SSBTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "AT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
            }
        }
    }

    private boolean hasVarrayClause(ColumnProxyOraclev10g columnProxy) {
        return !columnProxy.getSubtitutable().equals("") || !columnProxy.getLobSegname().equals("");
    }

    private String getPermissionsON(PermissionsOracle permissions) {
        if (permissions.getTable() != null) {
            return permissions.getTable().getLongNameDDL();
        }
        if (permissions.getColumnsTable() != null) {
            return permissions.getColumnsTable().getLongNameDDL();
        }
        return "";
    }

    private String getPermissionsTO(PermissionsOracle permissions) {
        if (permissions.getUser() != null) {
            return permissions.getUser().getName();
        }
        if (permissions.getRole() != null) {
            return permissions.getRole().getName();
        }
        return "";
    }

    protected void appendAdditionalValidTimes(StringBuffer oldbuffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
    }

    private void appendColumnCheckConstraints(StringBuffer oldbuffer, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        ColumnProxy[] cols_pr = tableProxy.getColumnAndNestedColumnProxies();
        for (int i = 0; i < cols_pr.length; ++i) {
            ColumnProxy columnProxy = cols_pr[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefinedForDDL() || !column.isGenerateConstraintInDDL()) continue;
            String text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy));
            if (text.equals("")) {
                CheckConstraint chk = column.getCheck();
                if (chk == null || chk.isEmpty()) continue;
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(oldbuffer, "--  WARNING: Column " + tableProxy.getName() + "." + columnProxy.getName() + " has no check constraint defined for this database type");
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementWarnings();
                continue;
            }
            String cname = column.getConstraintName();
            if (cname.length() > tableProxy.getMaxNameLength()) {
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Column " + tableProxy.getName() + "." + columnProxy.getName() + " check constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            if (SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy)) continue;
            String formattedLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            this.appendPrompt(buffer, tableProxy, "CHECK CONSTRAINT ON");
            SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, formattedLongName);
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!cname.equals("") && !cname.toUpperCase().startsWith("SYS_") && cname.length() <= 30) {
                cname = this.storageDesign.getFormatedName(cname);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, cname);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendString(buffer, text);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            SSBTableOraclev10g.appendConstraintState(buffer, (ColumnProxyOracle)columnProxy, false, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Check Constraint " + cname;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableLevelCheckConstraints(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
            if (!constraint.getTableConstraint().isGenerateInDDL()) continue;
            String rule = constraint.getTableConstraint().getRule();
            String cname = constraint.getName().toUpperCase();
            if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                cname = "";
            }
            if ("".equals(cname) || "".equals(rule)) continue;
            SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (cname.length() > tableProxy.getMaxNameLength()) {
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            String formatedConstraintName = this.storageDesign.getFormatedName(constraint);
            String formattedLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            this.appendPrompt(buffer, tableProxy, "CHECK CONSTRAINT ON");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, formattedLongName);
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!cname.startsWith("SYS_")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(buffer, formatedConstraintName);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev10g.appendString(buffer, '(');
            SSBTableOraclev10g.appendString(buffer, rule);
            SSBTableOraclev10g.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, constraint, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Constraint " + formatedConstraintName;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendIndexesForConstraints(StringBuffer oldbuffer, Table table, TableProxyOracle tableProxy) {
        KeyObject[] keys = table.getKeys();
        boolean genPK = table.getDesign().getDesignLevelSettings().isAutomaticPKGeneration();
        boolean genUK = table.getDesign().getDesignLevelSettings().isAutomaticUKGeneration();
        boolean genFK = table.getDesign().getDesignLevelSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keys.length; ++i) {
            Index ind;
            ContainedObject[] cols;
            SnapshotOracle sn;
            Index index = (Index)keys[i];
            if (genUK && "Unique Constraint".equals(index.getIndexState()) || genFK && index.isFK()) {
                Index ind2;
                ContainedObject[] cols2 = index.getElements();
                if (cols2.length <= 0 || (ind2 = SSBTableOraclev10g.getIndexUsableForColumns(table, index, cols2, true)) != null) continue;
                if (index.isFK()) {
                    ind2 = SSBTableOraclev10g.getPK_UK_AutoIndexCoveringFK_Constr(table, index, cols2, genPK, genUK, this.storageDesign);
                }
                if (ind2 != null) continue;
                SSBIndexOraclev10g ssbIndex = this.getSSBIndex();
                ssbIndex.appendIndexForConstraint(oldbuffer, index, true);
                continue;
            }
            if (!genPK || !"Primary Constraint".equals(index.getIndexState()) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) || (sn = tableProxy.getSnapshot()) != null && sn.getWith().equalsIgnoreCase("PRIMARY KEY") && sn.getRefresh().equals("YES") || (cols = index.getElements()).length <= 0 || (ind = SSBTableOraclev10g.getIndexUsableForColumns(table, index, cols, true)) != null) continue;
            SSBIndexOraclev10g ssbIndex = this.getSSBIndex();
            ssbIndex.appendIndexForConstraint(oldbuffer, index, true);
        }
    }

    public static Index getIndexUsableForColumns(Table table, Index index, ContainedObject[] cols, boolean ascending) {
        Object[] inds = table.getIndexes().toArray();
        for (int i = 0; i < inds.length; ++i) {
            DesignObjectPlaceHolder dph = (DesignObjectPlaceHolder)inds[i];
            Index ind = (Index)dph.getDesignObject();
            ContainedObject[] icols = ind.getElements();
            if (cols.length > icols.length || ind == index) continue;
            boolean brflag = false;
            for (int j = 0; j < cols.length; ++j) {
                ContainedObject col = null;
                for (int k = 0; k < cols.length; ++k) {
                    if (cols[j] != icols[k]) continue;
                    col = icols[k];
                    break;
                }
                if (col != null) {
                    String so;
                    if (!ascending || "ASC".equalsIgnoreCase(so = ind.getColumnSortOrder(col).trim()) || "".equalsIgnoreCase(so)) continue;
                    brflag = true;
                    break;
                }
                brflag = true;
                break;
            }
            if (brflag || ind == index) continue;
            return ind;
        }
        return null;
    }

    public static Index getPK_UK_AutoIndexCoveringFK_Constr(Table table, Index index, ContainedObject[] cols, boolean genPK, boolean genUK, StorageDesignOracle sd) {
        ArrayList list = new ArrayList();
        table.getPKeys().addAllElementsTo(list);
        table.getUKeys().addAllElementsTo(list);
        Object[] inds = list.toArray();
        for (int i = 0; i < inds.length; ++i) {
            IndexProxy ip;
            ContainedObject[] icols;
            DesignObjectPlaceHolder dph = (DesignObjectPlaceHolder)inds[i];
            Index ind = (Index)dph.getDesignObject();
            if ((!ind.isPK() || !genPK) && (!ind.isUnique() || !genUK) || cols.length > (icols = ind.getElements()).length || ind == index) continue;
            boolean brflag = false;
            for (int j = 0; j < cols.length; ++j) {
                ContainedObject col = null;
                for (int k = 0; k < cols.length; ++k) {
                    if (cols[j] != icols[k]) continue;
                    col = icols[k];
                    break;
                }
                if (col != null) continue;
                brflag = true;
                break;
            }
            if (brflag || ind == index) continue;
            boolean ret = false;
            if (ind.isPK()) {
                ip = (IndexProxy)sd.getPKProxySet().getProxy(ind.getObjectID());
                if (ip != null) {
                    ret = ip.isMarkedGenerate();
                }
            } else if (ind.isUnique() && (ip = (IndexProxy)sd.getUniqueSet().getProxy(ind.getObjectID())) != null) {
                ret = ip.isMarkedGenerate();
            }
            if (!ret) continue;
            return ind;
        }
        return null;
    }

    protected SSBIndexOraclev10g getSSBIndex() {
        if (this.ssbIndex == null) {
            this.ssbIndex = new SSBIndexOraclev10g();
            this.ssbIndex.setStorageDesign(this.storageDesign);
        }
        return this.ssbIndex;
    }

    public static boolean willGenerateInlineColumnConstrOra(Column column, ColumnProxy columnProxy) {
        String text;
        if (column.hasConstraintsDefinedForDDL() && !column.isNested() && ((ColumnProxyOracle)columnProxy).getExceptionsTable() == null && !"".equals(text = column.getConstraintsText(column.getName()))) {
            return column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC();
        }
        return false;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }

    private void appendExternalTableClause(StringBuffer buffer, TableProxyOracle table, boolean prettyPrint) {
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
        SSBTableOraclev10g.appendStringWithSpace(buffer, "EXTERNAL");
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
        if (!"".equalsIgnoreCase(table.getAccessDriverType().trim())) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "TYPE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, table.getAccessDriverType());
        }
        if (table.getDefaultDir() != null) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "DIRECTORY");
            SSBTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getDefaultDir()));
        }
        if (table.getAccessParametersType().equalsIgnoreCase("Opaque Format Spec")) {
            String spec = table.getOpaqueFormatSpec().trim();
            if ("ORACLE_HIVE".equalsIgnoreCase(this.tableProxy.getAccessDriverType()) || "ORACLE_HDFS".equalsIgnoreCase(this.tableProxy.getAccessDriverType()) || "ORACLE_BIGDATA".equalsIgnoreCase(this.tableProxy.getAccessDriverType())) {
                Table tab = (Table)this.tableProxy.getObject();
                String hiveName = tab.getProperty(MOHTable.HIVE_NAME);
                if (hiveName != null && !"".equals(hiveName.trim())) {
                    String lname = hiveName = hiveName.trim();
                    String hiveSchema = tab.getProperty(MOHTable.HIVE_SCHEMA);
                    if (hiveSchema != null && !"".equals(hiveSchema.trim())) {
                        hiveSchema = hiveSchema.trim();
                        lname = hiveSchema + "." + hiveName;
                    }
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() || !"default".equals(hiveSchema) || !hiveName.equals(this.tableProxy.getName())) {
                        if (!"".equalsIgnoreCase(spec)) {
                            if (spec.indexOf("com.oracle.bigdata.tablename") == -1) {
                                spec = spec + "\n" + "com.oracle.bigdata.tablename" + ApplicationView.BDA_PROPERTY_SEPARATOR + lname;
                            }
                        } else {
                            spec = "com.oracle.bigdata.tablename" + ApplicationView.BDA_PROPERTY_SEPARATOR + lname;
                        }
                    }
                }
                spec = this.addHiveColMap(table, spec);
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() || !"automatic".equals(table.getBigDataRowProcessing())) {
                    if (!"".equalsIgnoreCase(spec)) {
                        if (spec.indexOf("com.oracle.bigdata.datamode") == -1) {
                            spec = spec + "\n" + "com.oracle.bigdata.datamode" + ApplicationView.BDA_PROPERTY_SEPARATOR + table.getBigDataRowProcessing();
                        }
                    } else {
                        spec = "com.oracle.bigdata.datamode" + ApplicationView.BDA_PROPERTY_SEPARATOR + table.getBigDataRowProcessing();
                    }
                }
            }
            if (!"".equalsIgnoreCase(spec)) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "ACCESS");
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendString(buffer, spec);
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else if (table.getAccessParametersType().equalsIgnoreCase("CLOB Subquery") && !"".equalsIgnoreCase(table.getClobSubquery())) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "ACCESS");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "USING");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "CLOB");
            SSBTableOraclev10g.appendStringWithSpace(buffer, table.getClobSubquery());
        }
        if (!"ORACLE_HIVE".equalsIgnoreCase(this.tableProxy.getAccessDriverType())) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "LOCATION");
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            if (!table.getLocation().startsWith("'")) {
                SSBTableOraclev10g.appendString(buffer, '\'');
            }
            SSBTableOraclev10g.appendString(buffer, table.getLocation());
            if (!table.getLocation().endsWith("'")) {
                SSBTableOraclev10g.appendStringWithSpace(buffer, '\'');
            }
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
    }

    private String addHiveColMap(TableProxy tp, String spec) {
        if (spec.indexOf("com.oracle.bigdata.colMap") == -1) {
            String space = "                          ";
            String res = "";
            String key = "";
            Table table = (Table)tp.getObject();
            Column[] columns = (Column[])table.getElements();
            int count = 0;
            for (Column col : columns) {
                ColumnProxy cp = tp.getColumnProxy(col.getObjectID());
                String hname = col.getProperty(MOHTable.HIVE_NAME);
                String name = cp.getName();
                if (hname == null || "".equals(hname) || name.equalsIgnoreCase(hname)) continue;
                String temp = "{\"col\":\"" + name.toUpperCase() + "\", \\\n" + space + "\"field\":\"" + hname.toLowerCase() + "\"}";
                if (++count == 1) {
                    key = "com.oracle.bigdata.colMap" + ApplicationView.BDA_PROPERTY_SEPARATOR;
                    res = temp;
                    continue;
                }
                res = res + ", \\\n" + space + temp;
            }
            if (!"".equals(spec)) {
                spec = spec + "\n";
            }
            if (count == 1) {
                spec = spec + key + res;
            } else if (count > 1) {
                spec = spec + key + "[" + res + "]";
            }
        }
        return spec;
    }

    private void appendRejectLimit(StringBuffer buffer, TableProxyOracle table, boolean prettyPrint) {
        String rejectLimit = table.getRejectLimit();
        if (rejectLimit.length() > 0) {
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "REJECT");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "LIMIT");
            SSBTableOraclev10g.appendStringWithSpace(buffer, rejectLimit);
        }
    }

    private void appendHiveDDL(StringBuffer buffer, Table table, boolean prettyPrint) {
        ContainedObject[] cols = table.getElements();
        String ln = ContainerRenderer.getLongestName(cols, false);
        int max = ln.length();
        if (cols.length > 0) {
            String com;
            Column col;
            int i;
            Map map = this.getHivePartColumns(table);
            SSBTableOraclev10g.appendStringWithSpace(buffer, "CREATE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            SSBTableOraclev10g.appendStringWithSpace(buffer, table.getLongName());
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            ArrayList<Column> list = new ArrayList<Column>();
            for (i = 0; i < cols.length; ++i) {
                col = (Column)cols[i];
                Column pcol = (Column)map.get(col);
                if (pcol != null) continue;
                list.add(col);
            }
            for (i = 0; i < list.size(); ++i) {
                String com2;
                col = (Column)list.get(i);
                SSBTableOraclev10g.appendStringWithSpace(buffer, col.getName(), max - col.getName().length() + 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, col.getDataTypePresentationForHive());
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS() && (com2 = col.getCommentInRDBMS()) != null && com2.length() > 0) {
                    SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "", max + 1);
                    SSBTableOraclev10g.appendStringWithSpace(buffer, "COMMENT '" + com2 + "'");
                }
                if (i >= list.size() - 1) continue;
                SSBTableOraclev10g.appendStringWithSpace(buffer, ',');
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS() && (com = table.getCommentInRDBMS()) != null && com.length() > 0) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev10g.appendStringWithSpace(buffer, "COMMENT '" + com + "'");
            }
            if (map.size() > 0) {
                SSBTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                String pcols = null;
                for (Column pcol : map.values()) {
                    if (pcols == null) {
                        pcols = "(" + pcol.getName() + " " + pcol.getDataTypePresentationForHive();
                        continue;
                    }
                    pcols = pcols + "," + pcol.getName() + " " + pcol.getDataTypePresentationForHive();
                }
                pcols = pcols + ")";
                SSBTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONED BY " + pcols);
            }
        }
    }

    private Map getHivePartColumns(Table table) {
        HashMap<Column, Column> map;
        block5: {
            String prop;
            block4: {
                map = new HashMap<Column, Column>();
                prop = table.getProperty(MOHTable.HIVE_PART_COLS_ID);
                if (prop == null || "".equals(prop)) break block4;
                String[] ids = prop.split(",");
                for (int i = 0; i < ids.length; ++i) {
                    Column col = (Column)table.getElementByID(ids[i]);
                    if (col == null) {
                        map.clear();
                        return map;
                    }
                    map.put(col, col);
                }
                break block5;
            }
            prop = table.getProperty(MOHTable.HIVE_PART_COLS);
            if (prop == null || "".equals(prop)) break block5;
            String[] ids = prop.split(",");
            for (int i = 0; i < ids.length; ++i) {
                Column col = (Column)table.getElementByName(ids[i]);
                if (col == null) {
                    map.clear();
                    return map;
                }
                map.put(col, col);
            }
        }
        return map;
    }

    @Override
    public String appendConstraints(TableProxy tableProxy) {
        StringBuffer sb = new StringBuffer();
        if (tableProxy != null && tableProxy instanceof TableProxyOraclev10g) {
            SnapshotOracle sn;
            this.tableProxy = (TableProxyOraclev10g)tableProxy;
            this.table = (Table)this.tableProxy.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev10g)tableProxy.getStorageDesign();
            }
            if (!"EXTERNAL".equalsIgnoreCase(this.tableProxy.getOrganization())) {
                this.appendTableLevelCheckConstraints(sb, this.tableProxy, true);
            }
            if (!(this.table.getBasedOnStructuredType() != null || "INDEX".equalsIgnoreCase(this.tableProxy.getOrganization()) || (sn = this.tableProxy.getSnapshot()) != null && sn.getWith().equalsIgnoreCase("PRIMARY KEY") && sn.getRefresh().equals("YES"))) {
                this.appendPKDefinition(sb, this.tableProxy, true);
            }
            this.appendUniqueDefinition(sb, this.tableProxy, true);
        }
        return sb.toString();
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOraclev10g)one).getPosition() > ((PartitionOraclev10g)two).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev10g)one).getPosition() < ((PartitionOraclev10g)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((IndexGlobalPartitionOraclev10g)one).getPosition() > ((IndexGlobalPartitionOraclev10g)two).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev10g)one).getPosition() < ((IndexGlobalPartitionOraclev10g)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

