/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class SSBPlSqlSourceStorageObjectOracle
extends AbstractSSBOracle {
    @Override
    protected void doAppend(StringBuffer oldBuffer, Object object, boolean prettyPrint) {
        PlSqlSourceStorageObjectOracle objectOracle = (PlSqlSourceStorageObjectOracle)object;
        if (objectOracle.isMarkedGenerate()) {
            SSBPlSqlSourceStorageObjectOracle.appendNewLine(oldBuffer, prettyPrint, 0);
            String source = objectOracle.getSource();
            if (source.trim().endsWith(" WRAPPED")) {
                SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(oldBuffer, "--");
                SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(oldBuffer, objectOracle.getObjectTypeName());
                SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(oldBuffer, objectOracle.getStorageDesign().getFormatedLongNameDDL(objectOracle));
                SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(oldBuffer, "is WRAPPED");
                SSBPlSqlSourceStorageObjectOracle.appendNewLine(oldBuffer, prettyPrint, 0);
            } else {
                this.appendComment(oldBuffer, objectOracle);
                StringBuffer buffer = new StringBuffer(source);
                StringBuffer advancedCommentBuffer = new StringBuffer();
                this.appendCreateOrReplace(advancedCommentBuffer, objectOracle);
                this.appendToBuffer(oldBuffer, buffer, advancedCommentBuffer.toString());
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBPlSqlSourceStorageObjectOracle.appendNewLine(oldBuffer, prettyPrint, 0);
                    SSBPlSqlSourceStorageObjectOracle.appendString(oldBuffer, "/");
                }
                SSBPlSqlSourceStorageObjectOracle.appendNewLine(oldBuffer, prettyPrint, 0);
                this.appendPermissions(oldBuffer, objectOracle);
            }
            this.incrementCreateObject(object);
        }
    }

    protected abstract void incrementCreateObject(Object var1);

    protected void appendPermissions(StringBuffer oldBuffer, PlSqlSourceStorageObjectOracle storageObjectOracle) {
        StorageDesignOracle storageDesignOracle = storageObjectOracle.getStorageDesignOracle();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        for (PermissionsOracle permissions : permissionsSet) {
            if (!storageObjectOracle.equals(permissions.getPackage()) && !storageObjectOracle.equals(permissions.getProc()) && !storageObjectOracle.equals(permissions.getFunctionOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, storageObjectOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, storageObjectOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, PlSqlSourceStorageObjectOracle storageObjectOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, storageObjectOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, PlSqlSourceStorageObjectOracle storageObjectOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(buffer, "ON");
        SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(storageObjectOracle));
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

