/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.SequenceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBAutoIncrementColumnDB2
extends AbstractSSBDB2 {
    private static final int MAX_OBJECT_LENGTH = 30;
    private static final String TRIGGER_SUFFIX = "TRG";
    private static final String SEQUENCE_SUFFIX = "SEQ";
    private StorageDesignDB2v80 storageDesign;
    private static Set genSequenceSet = new HashSet();

    public SSBAutoIncrementColumnDB2(StorageDesignDB2v80 storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return (object instanceof TableProxyDB2 || object instanceof Table) && this.storageDesign instanceof StorageDesignDB2v80;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof TableProxyDB2 && ((TableProxyDB2)object).isMarkedGenerate() || object instanceof Table && ((Table)object).isMarkedGenerate()) {
            Table table = object instanceof Table ? (Table)object : (Table)((TableProxyDB2)object).getObject();
            for (Column column : table.getElementsAndNestedElementsCollection()) {
                if (!column.isAutoIncrementColumn() && !column.isIdentityColumn() && !column.isComputed().booleanValue()) continue;
                this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint);
            }
        }
    }

    public static void clearGenSequenceSet() {
        genSequenceSet.clear();
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint) {
        this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint, boolean tableCreated) {
        ColumnProxyDB2v80 columnProxy = null;
        if (!(this.storageDesign instanceof StorageDesignDB2v80)) return;
        columnProxy = (ColumnProxyDB2v80)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (columnProxy == null) return;
        String autoIncDDL = columnProxy.getDDLTypeForAutoIncCol();
        if (autoIncDDL.equalsIgnoreCase("NONE")) {
            return;
        }
        if (autoIncDDL.equalsIgnoreCase("TRIGGER")) {
            if (!tableCreated) {
                return;
            }
        } else {
            String dt;
            if (!autoIncDDL.equalsIgnoreCase("IDENTITY_CLAUSE")) return;
            if (!tableCreated) {
                return;
            }
            if (column.isIdentityColumn() && (dt = column.getDatatypeString(this.storageDesign.getRDBMSType().getName())).toUpperCase(Locale.ROOT).indexOf("CHAR") <= -1) {
                return;
            }
        }
        String sequenceName = "";
        String triggerExpr = columnProxy.getGenerationExpression().trim();
        if ("".equals(triggerExpr)) {
            sequenceName = this.generateSequenceName(buffer, column, prettyPrint);
        }
        if (!column.isAutoIncrementGenerateTrigger()) return;
        TriggerDB2 existingTrigger = null;
        String triggerName = column.getAutoIncrementTriggerName();
        if (StringUtilities.isNotEmpty(triggerName)) {
            TableProxyDB2 tableProxy;
            int indexOfDot = triggerName.indexOf(46);
            if (indexOfDot > -1) {
                triggerName = triggerName.substring(indexOfDot + 1);
            }
            if ((tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(column.getTable().getObjectID())) != null) {
                for (TriggerDB2 tableTrigger : tableProxy.getTriggers()) {
                    if (!tableTrigger.getName().equalsIgnoreCase(triggerName)) continue;
                    existingTrigger = tableTrigger;
                    break;
                }
            }
        }
        if (existingTrigger != null) return;
        Settings settings = column.getDesign().getAppView().getSettings();
        triggerName = this.generateAutoIncrementObjectName(triggerName, settings.getDefaultDB2TriggerName(), TRIGGER_SUFFIX, column);
        if (!"".equals(sequenceName)) {
            this.appendAutoIncrementTrigger(triggerName, sequenceName, column, buffer, prettyPrint);
            return;
        } else {
            if ("".equals(triggerExpr)) return;
            this.appendAutoIncrementTriggerExpr(triggerName, triggerExpr, column, buffer, prettyPrint);
        }
    }

    public String generateSequenceName(StringBuffer buffer, Column column, boolean prettyPrint) {
        Settings settings = column.getDesign().getAppView().getSettings();
        String sequenceName = column.getAutoIncrementSequenceName();
        if (sequenceName != null) {
            sequenceName = sequenceName.trim();
        }
        String seqLongName = this.generateAutoIncrementObjectName(sequenceName, settings.getDefaultDB2SequenceName(), SEQUENCE_SUFFIX, column);
        SequenceDB2 sequence = null;
        String userName = "";
        int dotIndex = seqLongName.indexOf(46);
        if (dotIndex == -1) {
            sequenceName = seqLongName;
        } else {
            sequenceName = seqLongName.substring(dotIndex + 1);
            userName = seqLongName.substring(0, dotIndex);
            sequence = this.storageDesign.getSequenceSet().getBySchemaAndName(userName, sequenceName);
        }
        if (sequence == null) {
            sequence = (SequenceDB2)this.storageDesign.getSequenceSet().getByName(sequenceName);
        }
        if (sequence != null) {
            return this.storageDesign.getFormatedLongNameDDL(sequence);
        }
        if (buffer != null && !genSequenceSet.contains(seqLongName)) {
            this.appendAutoIncrementSequence(seqLongName, column, buffer, prettyPrint);
            genSequenceSet.add(seqLongName);
        }
        return this.storageDesign.getFormatedName(seqLongName);
    }

    private String generateAutoIncrementObjectName(String objectName, String objectNameTemplate, String suffix, Column column) {
        String result;
        String schema = null;
        if (StringUtilities.isNotEmpty(objectName)) {
            int dotIndex = objectName.indexOf(46);
            if (dotIndex > -1) {
                schema = objectName.substring(0, dotIndex);
                result = objectName.substring(dotIndex + 1);
            } else {
                result = objectName;
            }
        } else {
            String columnAbbr;
            String columnName;
            String tableName;
            Table table = (Table)column.getParent();
            ColumnProxyDB2 columnProxy = (ColumnProxyDB2)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
            TableProxyDB2 tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            if (tableProxy == null || columnProxy == null) {
                tableName = table.getName();
                columnName = column.getShortName();
                schema = table.getSchema();
            } else {
                tableName = tableProxy.getName();
                columnName = column.getParentObject() != null ? column.getShortName() : columnProxy.getName();
                String tableLongName = tableProxy.getLongName();
                int userNameLength = tableLongName.length() - tableName.length() - 1;
                schema = userNameLength > 0 ? tableLongName.substring(0, userNameLength) : "";
            }
            String tableAbbr = table.getAbbreviation();
            if (StringUtilities.isEmpty(tableAbbr)) {
                tableAbbr = tableName;
            }
            if (StringUtilities.isEmpty(columnAbbr = column.getAbbreviation())) {
                columnAbbr = columnName;
            }
            if (StringUtilities.isNotEmpty(objectNameTemplate)) {
                tableName = tableName.replaceAll("\\$", "\\\\\\$");
                tableAbbr = tableAbbr.replaceAll("\\$", "\\\\\\$");
                columnName = columnName.replaceAll("\\$", "\\\\\\$");
                columnAbbr = columnAbbr.replaceAll("\\$", "\\\\\\$");
                result = objectNameTemplate.replaceAll("\\{table\\}", tableName).replaceAll("\\{table abbr\\}", tableAbbr).replaceAll("\\{column\\}", columnName).replaceAll("\\{column abbr\\}", columnAbbr);
                result = result.replaceAll("\\\\\\$", "\\$");
            } else {
                result = tableAbbr + '_' + columnAbbr;
                if (result.length() + suffix.length() + 1 <= 30) {
                    result = result + '_' + suffix;
                }
            }
        }
        result = this.getStringWithMaxLength(result, 30);
        if (StringUtilities.isNotEmpty(schema) && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            result = schema + '.' + result;
        }
        return result;
    }

    private void appendAutoIncrementSequence(String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String autoIncrementStartWith = column.getAutoIncrementStartWith();
        Integer autoIncrementIncrementBy = column.getAutoIncrementIncrementBy();
        String autoIncrementMaxValue = column.getAutoIncrementMaxValue();
        String autoIncrementMinValue = column.getAutoIncrementMinValue();
        Integer autoIncrementCache = column.getAutoIncrementCache();
        SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 0);
        SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CREATE");
        SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "SEQUENCE");
        SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sequenceName));
        String advancedComment = buffer.toString();
        SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
        SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "AS");
        SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "INTEGER");
        if (autoIncrementStartWith != null && !"".equals(autoIncrementStartWith)) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "START");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "WITH");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, autoIncrementStartWith);
        }
        if (autoIncrementIncrementBy != null && autoIncrementIncrementBy != 1) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, autoIncrementIncrementBy);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "BY");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "1");
        }
        if (autoIncrementMinValue != null) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "MINVALUE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, autoIncrementMinValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "MINVALUE");
        }
        if (autoIncrementMaxValue != null) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "MAXVALUE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, autoIncrementMaxValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "MAXVALUE");
        }
        if (column.isAutoIncrementCycle()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CYCLE");
        }
        if (column.isAutoIncrementDisableCache()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CACHE");
        } else if (autoIncrementCache != null) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CACHE");
            this.appendStringWithSpace(buffer, autoIncrementCache);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CACHE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "20");
        }
        if (column.isAutoIncrementOrder()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "ORDER");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "ORDER");
        }
        SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBAutoIncrementColumnDB2.appendNewLine(oldbuffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateSequence();
    }

    private void appendAutoIncrementTrigger(String triggerName, String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        ColumnProxyDB2 columnProxy;
        Table table = (Table)column.getParent();
        TableProxyDB2 tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && (columnProxy = (ColumnProxyDB2)tableProxy.getColumnProxy(column.getObjectID())) != null) {
            StringBuffer buffer = new StringBuffer();
            String tableName = this.storageDesign.getFormatedName(tableProxy);
            String columnName = this.storageDesign.getFormatedName(columnProxy);
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CREATE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "TRIGGER");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CASCADE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "BEFORE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "INSERT");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "ON");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, tableName);
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "FOR");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "EACH");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "ROW");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "MODE DB2SQL");
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "WHEN");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, '(');
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, columnName);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "IS");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "NULL");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, ')');
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "BEGIN");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "ATOMIC");
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 2);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "SET");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, columnName);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, '=');
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, sequenceName + '.' + "NEXTVAL");
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "END");
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAutoIncrementColumnDB2.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
        }
    }

    private void appendAutoIncrementTriggerExpr(String triggerName, String triggerExpr, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        ColumnProxyDB2 columnProxy;
        Table table = (Table)column.getParent();
        TableProxyDB2 tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && (columnProxy = (ColumnProxyDB2)tableProxy.getColumnProxy(column.getObjectID())) != null) {
            StringBuffer buffer = new StringBuffer();
            String tableName = this.storageDesign.getFormatedName(tableProxy);
            String columnName = this.storageDesign.getFormatedName(columnProxy);
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CREATE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "TRIGGER");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "CASCADE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "BEFORE");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "INSERT");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "ON");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, tableName);
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "FOR");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "EACH");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "ROW");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "MODE DB2SQL");
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "BEGIN");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "ATOMIC");
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 2);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "SET");
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, columnName);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, '=');
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, triggerExpr);
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnDB2.appendStringWithSpace(buffer, "END");
            SSBAutoIncrementColumnDB2.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAutoIncrementColumnDB2.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
        }
    }
}

