/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVConstants;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.model.design.Design;

public abstract class ExportHandler
implements CSVConstants {
    private CSVExporter csvExporter;

    public ExportHandler(CSVExporter csvExporter) {
        this.csvExporter = csvExporter;
    }

    public abstract void Export();

    public abstract String getFileName();

    protected void saveToFile(List lines) {
        try {
            File file = new File(this.csvExporter.getExportFolder(), this.getFileName());
            file.getParentFile().mkdirs();
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
            for (String line : lines) {
                out.println(line);
            }
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CSVExporter getCsvExporter() {
        return this.csvExporter;
    }

    public Design getDesign() {
        return this.csvExporter.getDesign();
    }

    protected String quotedString(String text) {
        if (text != null && !"".equalsIgnoreCase(text)) {
            return "\"" + text + "\"";
        }
        return "";
    }

    protected String quotedIfHasSpatias(String text) {
        if (text != null && !"".equalsIgnoreCase(text)) {
            if (!text.equals(text.trim())) {
                return "'" + text + "'";
            }
            return text;
        }
        return "";
    }

    protected String replaceString(String text) {
        if (text != null && !"".equalsIgnoreCase(text)) {
            String string = text.replaceAll("[\n]", "|||");
            string = string.replaceAll("[\r]", "|||");
            string = string.replaceAll("[\"]", "\"\"");
            return string;
        }
        return "";
    }

    protected String replaceAndQuoteString(String text) {
        if (text != null && !"".equalsIgnoreCase(text)) {
            return "\"" + this.replaceString(text) + "\"";
        }
        return "";
    }
}

