/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class EHProcessEntities
extends ExportHandler {
    public EHProcessEntities(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Process_ID").append(",");
        sb.append("Num_Process_ID").append(",");
        sb.append("Entity_ID").append(",");
        sb.append("Num_Entity_ID").append(",");
        sb.append("Flow_ID").append(",");
        sb.append("Num_Flow_ID").append(",");
        sb.append("DFD_ID").append(",");
        sb.append("Num_DFD_ID").append(",");
        sb.append("Process_Name").append(",");
        sb.append("Entity_Name").append(",");
        sb.append("Flow_Name").append(",");
        sb.append("DFD_Name").append(",");
        sb.append("OP_Read").append(",");
        sb.append("OP_Create").append(",");
        sb.append("OP_Update").append(",");
        sb.append("OP_Delete").append(",");
        sb.append("CRUD_Code").append(",");
        sb.append("Flow_Direction");
        lines.add(sb.toString());
        ProcessModel processModel = this.getDesign().getProcessModel();
        for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
            String tlName = dfd.getTopLevelDataFlowDesign().getName();
            Iterator dfdit = dfd.getProcessSet().iterator();
            while (dfdit.hasNext()) {
                Process process = (Process)dfdit.next();
                if (process.getType() != 0) continue;
                for (Process.ProcessedObject po : process.getProcessedEntitiesAndFlows(false)) {
                    sb = new StringBuffer();
                    sb.append(process.getObjectID()).append(",");
                    sb.append(process.getNumID()).append(",");
                    sb.append(po.getObject().getObjectID()).append(",");
                    sb.append(po.getObject().getNumID()).append(",");
                    sb.append(po.getFlow().getObjectID()).append(",");
                    sb.append(po.getFlow().getNumID()).append(",");
                    sb.append(dfd.getObjectID()).append(",");
                    sb.append(dfd.getNumID()).append(",");
                    sb.append(this.replaceAndQuoteString(process.getName())).append(",");
                    sb.append(this.replaceAndQuoteString(po.getObject().getName())).append(",");
                    sb.append(po.getFlow().getName()).append(",");
                    sb.append(this.replaceAndQuoteString(tlName)).append(",");
                    sb.append(po.isOpRead() ? YES : NO).append(",");
                    sb.append(po.isOpCreate() ? YES : NO).append(",");
                    sb.append(po.isOpUpdate() ? YES : NO).append(",");
                    sb.append(po.isOpDelete() ? YES : NO).append(",");
                    if (po.isOpRead()) {
                        sb.append("R").append(",");
                    } else {
                        String crud = "";
                        if (po.isOpCreate()) {
                            crud = "C";
                        }
                        if (po.isOpUpdate()) {
                            crud = crud + "U";
                        }
                        if (po.isOpDelete()) {
                            crud = crud + "D";
                        }
                        sb.append(crud).append(",");
                    }
                    sb.append(po.isInbound() ? IN : OUT).append(",");
                    lines.add(sb.toString());
                }
                this.getCsvExporter().addNote(process.getObjectID(), process.getNumID(), "Process", process.getNotes());
                this.getCsvExporter().addComment(process.getObjectID(), process.getNumID(), "Process", process.getComment());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Process_Entities.csv";
    }
}

