/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class EHMappings
extends ExportHandler {
    public EHMappings(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Logical_Model_ID").append(",");
        sb.append("Num_Logical_Model_ID").append(",");
        sb.append("Logical_Model_Name").append(",");
        sb.append("Logical_Object_ID").append(",");
        sb.append("Num_Logical_Object_ID").append(",");
        sb.append("Logical_Object_Name").append(",");
        sb.append("Relational_Model_ID").append(",");
        sb.append("Num_Relational_Model_ID").append(",");
        sb.append("Relational_Model_Name").append(",");
        sb.append("Relational_Object_ID").append(",");
        sb.append("Num_Relational_Object_ID").append(",");
        sb.append("Relational_Object_Name").append(",");
        sb.append("Entity_Name").append(",");
        sb.append("Table_Name");
        lines.add(sb.toString());
        ArrayList allMappings = new ArrayList();
        allMappings.addAll(this.getDesign().getExtendedMap().getAllMappings());
        for (RelationalDesign rd : this.getDesign().getRelationalDesigns()) {
            if (!rd.isLoaded()) continue;
            allMappings.addAll(rd.getRMExtendedMap().getAllMappings());
        }
        for (XtdMapping xtdMap : allMappings) {
            DesignObject relObj;
            DesignObject logicalObj;
            if (xtdMap.getOwnerDesignPart() instanceof LogicalDesign) {
                logicalObj = xtdMap.getOwnerObject();
                relObj = xtdMap.getTargetObject();
            } else {
                logicalObj = xtdMap.getTargetObject();
                relObj = xtdMap.getOwnerObject();
            }
            if (logicalObj == null || relObj == null) continue;
            sb = new StringBuffer();
            sb.append(logicalObj.getDesignPart().getObjectID()).append(",");
            sb.append(logicalObj.getDesignPart().getNumID()).append(",");
            sb.append(this.replaceAndQuoteString(logicalObj.getDesignPart().getName())).append(",");
            sb.append(logicalObj.getObjectID()).append(",");
            sb.append(logicalObj.getNumID()).append(",");
            sb.append(this.replaceAndQuoteString(logicalObj.getName())).append(",");
            sb.append(relObj.getDesignPart().getObjectID()).append(",");
            sb.append(relObj.getDesignPart().getNumID()).append(",");
            sb.append(this.replaceAndQuoteString(relObj.getDesignPart().getName())).append(",");
            sb.append(relObj.getObjectID()).append(",");
            sb.append(relObj.getNumID()).append(",");
            sb.append(this.replaceAndQuoteString(relObj.getName())).append(",");
            if (logicalObj instanceof Entity) {
                sb.append(logicalObj.getName()).append(",");
            } else if (logicalObj instanceof Attribute) {
                try {
                    sb.append(this.replaceAndQuoteString(((Attribute)logicalObj).getContainer().getName())).append(",");
                }
                catch (Exception e) {
                    System.out.println("Wrong Mapping - EHMappings.Attribute: " + logicalObj.getName());
                    sb.append("").append(",");
                }
            } else if (logicalObj instanceof CandidateKey) {
                try {
                    sb.append(this.replaceAndQuoteString(((CandidateKey)logicalObj).getContainerObject().getName())).append(",");
                }
                catch (Exception e) {
                    System.out.println("Wrong Mapping - EHMappings.CandidateKey: " + logicalObj.getName());
                    sb.append("").append(",");
                }
            } else {
                sb.append("").append(",");
            }
            if (relObj instanceof Table) {
                sb.append(this.replaceAndQuoteString(relObj.getName())).append(",");
            } else if (relObj instanceof Column) {
                sb.append(this.replaceAndQuoteString(((Column)relObj).getContainer().getName())).append(",");
            } else if (relObj instanceof Index) {
                sb.append(this.replaceAndQuoteString(((Index)relObj).getContainerObject().getName())).append(",");
            } else {
                sb.append("").append(",");
            }
            lines.add(sb.toString());
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Mappings.csv";
    }
}

